/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.macro.JSSuggestVariableNameMacro;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSForOfPostfixTemplate
extends StringBasedPostfixTemplate {
    public JSForOfPostfixTemplate() {
        this("forof", "for (let obj of expr)");
    }

    protected JSForOfPostfixTemplate(String name, String example) {
        super(name, example, JSPostfixTemplateUtils.selectorWithFeature(JSPostfixTemplateUtils.selectorTopmost(JSPostfixTemplateUtils.ARRAY_ITERABLE_ANY_TYPE), JSLanguageFeature.FOR_OF, null), null);
    }

    @Nullable
    public String getTemplateString(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSForOfPostfixTemplate.$$$reportNull$$$0(0);
        }
        String prefix = JSChangeUtil.getVariablePrefix(element2);
        String forKeyword = ES6PsiUtil.isAsyncFunction((JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, JSFunction.class)) && JSTypeUtils.isAsyncIterable(JSPostfixTemplateUtils.computeType((JSExpression)element2)) ? "for await" : "for";
        return forKeyword + " (" + prefix + " $name$ of $expr$) {\n$END$\n}";
    }

    public void setVariables(@NotNull Template template, @NotNull PsiElement element2) {
        if (template == null) {
            JSForOfPostfixTemplate.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            JSForOfPostfixTemplate.$$$reportNull$$$0(2);
        }
        MacroCallNode name = new MacroCallNode((Macro)new JSSuggestVariableNameMacro());
        template.addVariable("name", (Expression)name, (Expression)name, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSForOfPostfixTemplate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplateString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setVariables";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

