/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.parallelStacks.threads.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.parallelStacks.base.XDebuggerParallelStacksBundle;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksColors;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeHeader;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ScalableIcon;
import com.intellij.xdebugger.impl.parallelStacks.base.view.UpdatableGraph2DView;
import com.intellij.xdebugger.impl.parallelStacks.threads.MultipleFramesNode;
import com.intellij.xdebugger.impl.parallelStacks.threads.StackWithId;
import com.intellij.xdebugger.impl.parallelStacks.threads.view.ParallelThreadsView;
import com.intellij.xdebugger.impl.parallelStacks.threads.view.ThreadsViewNodeRealizer;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeHeader;", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeHeader;", "frameRealizer", "Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeRealizer;", "parentView", "Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ParallelThreadsView;", "graphView", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "ThreadsViewNodeHeader", "(Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeRealizer;Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ParallelThreadsView;Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;)V", "createHeaderHintComponent", "Ljavax/swing/JComponent;", "shouldShowHint", "", "intellij.platform.debugger.parallelStacks"})
@SourceDebugExtension(value={"SMAP\nThreadsViewNodeHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadsViewNodeHeader.kt\ncom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1#2:74\n1788#3,4:75\n1761#3,3:79\n*S KotlinDebug\n*F\n+ 1 ThreadsViewNodeHeader.kt\ncom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeHeader\n*L\n32#1:75,4\n49#1:79,3\n*E\n"})
public final class ThreadsViewNodeHeader
extends ParallelStacksNodeHeader {
    @NotNull
    private final ThreadsViewNodeRealizer frameRealizer;
    @NotNull
    private final ParallelThreadsView parentView;

    public ThreadsViewNodeHeader(@NotNull ThreadsViewNodeRealizer frameRealizer, @NotNull ParallelThreadsView parentView, @NotNull UpdatableGraph2DView graphView) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)frameRealizer, (String)"frameRealizer");
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
        super(frameRealizer, graphView);
        this.frameRealizer = frameRealizer;
        this.parentView = parentView;
        MultipleFramesNode multipleFramesNode = this.frameRealizer.getData();
        List<XExecutionStack> list = this.frameRealizer.getStacks();
        if (multipleFramesNode.getStacks().size() == 1) {
            Object v12;
            block10: {
                if (multipleFramesNode.getStacks().get(0).isFrozen()) {
                    Icon icon = AllIcons.Debugger.Freeze;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Freeze");
                    this.setIcon(new ScalableIcon(icon));
                }
                XExecutionStack xExecutionStack = multipleFramesNode.getFrames().get(0).getStack();
                Iterable iterable = list;
                for (Object t2 : iterable) {
                    var13_14 = (XExecutionStack)t2;
                    var14_15 = false;
                    if (!Intrinsics.areEqual((Object)var13_14, (Object)xExecutionStack)) continue;
                    v12 = t2;
                    break block10;
                }
                v12 = null;
            }
            if ((object = (XExecutionStack)v12) == null || (object = object.getDisplayName()) == null) {
                object = "@" + multipleFramesNode.getStacks().get(0);
            }
        } else {
            int n10;
            Object[] objectArray = (Object[])multipleFramesNode.getStacks();
            boolean bl = false;
            if (objectArray instanceof Collection && ((Collection)objectArray).isEmpty()) {
                v3 = 0;
            } else {
                int n11 = 0;
                for (Object t2 : objectArray) {
                    var13_14 = (StackWithId)t2;
                    var14_15 = false;
                    if (!var13_14.isFrozen() || ++n11 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v3 = n10 = n11;
            }
            if (n10 == 0) {
                objectArray = new Object[]{multipleFramesNode.getStacks().size()};
                object = XDebuggerParallelStacksBundle.message("label.threads", objectArray);
            } else {
                objectArray = new Object[]{multipleFramesNode.getStacks().size(), n10};
                object = XDebuggerParallelStacksBundle.message("label.threads.with.frozen", objectArray);
            }
        }
        Object object2 = object;
        this.setText((String)object2);
    }

    @Override
    @NotNull
    protected JComponent createHeaderHintComponent() {
        int n10;
        SimpleColoredComponent simpleColoredComponent;
        boolean bl;
        int n11;
        List<StackWithId> list;
        JPanel jPanel;
        JPanel jPanel2;
        block5: {
            jPanel = jPanel2 = new JPanel();
            boolean bl2 = false;
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBackground(IdeTooltipManager.Companion.getInstance().getTextBackground(true));
            list = this.frameRealizer.getData().getStacks();
            Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)list);
            n11 = 0;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                simpleColoredComponent = iterable.iterator();
                while (simpleColoredComponent.hasNext()) {
                    int n12;
                    n10 = n12 = ((IntIterator)simpleColoredComponent).nextInt();
                    boolean bl3 = false;
                    if (!list.get(n10).isFrozen()) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        n11 = ((Collection)list).size();
        for (int i2 = 0; i2 < n11; ++i2) {
            SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent = new SimpleColoredComponent();
            JPanel jPanel3 = jPanel;
            n10 = 0;
            if (bl4) {
                simpleColoredComponent2.setIcon(list.get(i2).isFrozen() ? AllIcons.Debugger.Freeze : AllIcons.Empty);
            }
            Long l2 = this.parentView.getActiveThreadId();
            SimpleTextAttributes simpleTextAttributes = l2 != null && list.get(i2).getThreadId() == l2.longValue() ? new SimpleTextAttributes(0, (Color)ParallelStacksColors.INSTANCE.getACTIVE_HEADER_TEXT_COLOR()) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleColoredComponent2.append(list.get(i2).getStack().getDisplayName(), simpleTextAttributes);
            jPanel3.add((Component)simpleColoredComponent);
        }
        return jPanel2;
    }

    @Override
    protected boolean shouldShowHint() {
        return this.frameRealizer.getData().getStacks().size() > 1;
    }
}

