/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectSettings;

@Service
public final class HgExecutableManager {
    @NonNls
    private static final String[] DEFAULT_WINDOWS_PATHS = new String[]{"C:\\Program Files\\Mercurial", "C:\\Program Files (x86)\\Mercurial", "C:\\cygwin\\bin"};
    @NonNls
    private static final String[] DEFAULT_UNIX_PATHS = new String[]{"/usr/local/bin", "/usr/bin", "/opt/local/bin", "/opt/bin", "/usr/local/mercurial"};
    @NonNls
    private static final String DEFAULT_WINDOWS_HG = "hg.exe";
    @NonNls
    private static final String DEFAULT_UNIX_HG = "hg";
    @NotNull
    private final NotNullLazyValue<String> myDetectedExecutable = NotNullLazyValue.atomicLazy(HgExecutableManager::identifyDefaultHgExecutable);

    public static HgExecutableManager getInstance() {
        return (HgExecutableManager)ApplicationManager.getApplication().getService(HgExecutableManager.class);
    }

    @NotNull
    public String getHgExecutable() {
        String path = HgGlobalSettings.getInstance().getHgExecutable();
        String string = path == null ? this.getDefaultExecutable() : path;
        if (string == null) {
            HgExecutableManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getHgExecutable(@NotNull Project project) {
        HgProjectSettings projectSettings;
        if (project == null) {
            HgExecutableManager.$$$reportNull$$$0(1);
        }
        if (!(projectSettings = HgProjectSettings.getInstance(project)).isHgExecutableOverridden()) {
            String string = this.getHgExecutable();
            if (string == null) {
                HgExecutableManager.$$$reportNull$$$0(2);
            }
            return string;
        }
        String path = projectSettings.getHgExecutable();
        String string = path == null ? this.getDefaultExecutable() : path;
        if (string == null) {
            HgExecutableManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDefaultExecutable() {
        String string = (String)this.myDetectedExecutable.getValue();
        if (string == null) {
            HgExecutableManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String identifyDefaultHgExecutable() {
        String[] paths;
        String programName;
        File hgExecutableFromPath = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? DEFAULT_WINDOWS_HG : DEFAULT_UNIX_HG), (String)PathEnvironmentVariableUtil.getPathVariableValue(), null);
        if (hgExecutableFromPath != null) {
            String string = hgExecutableFromPath.getPath();
            if (string == null) {
                HgExecutableManager.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (SystemInfo.isWindows) {
            programName = DEFAULT_WINDOWS_HG;
            paths = DEFAULT_WINDOWS_PATHS;
        } else {
            programName = DEFAULT_UNIX_HG;
            paths = DEFAULT_UNIX_PATHS;
        }
        for (String p : paths) {
            Path programPath = Paths.get(p, programName);
            if (!Files.isExecutable(programPath)) continue;
            String string = programPath.toAbsolutePath().toString();
            if (string == null) {
                HgExecutableManager.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = programName;
        if (string == null) {
            HgExecutableManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgExecutableManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHgExecutable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgExecutableManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExecutable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyDefaultHgExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHgExecutable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

