/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\bH\u0000\u001a*\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u00022\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\rH\u0000\u001a1\u0010\u0011\u001a\u0002H\u0002\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\rH\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\u001a\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"writeListOfObjects", "", "T", "dataOutput", "Ljava/io/DataOutput;", "objects", "", "objectWriter", "Lkotlin/Function1;", "readListOfObjects", "dataInput", "Ljava/io/DataInput;", "objectReader", "Lkotlin/Function0;", "INDEXED_SPECIFICATION_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/swagger/core/SwSpecificationType;", "processWithPrecomputedSpecificationType", "psiFile", "Lcom/intellij/psi/PsiFile;", "specificationType", "action", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/swagger/core/SwSpecificationType;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "storeVirtualFileInUserData", "getPrecomputedSpecificationTypeFromUserData", "isIndexingRightNow", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger.core"})
public final class SwIndexUtilsKt {
    @NotNull
    private static final Key<SwSpecificationType> INDEXED_SPECIFICATION_TYPE_KEY;

    public static final <T> void writeListOfObjects(@NotNull DataOutput dataOutput, @NotNull List<? extends T> objects, @NotNull Function1<? super T, Unit> objectWriter) {
        Intrinsics.checkNotNullParameter((Object)dataOutput, (String)"dataOutput");
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter(objectWriter, (String)"objectWriter");
        DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)objects.size());
        for (T singleObject : objects) {
            objectWriter.invoke(singleObject);
        }
    }

    @NotNull
    public static final <T> List<T> readListOfObjects(@NotNull DataInput dataInput, @NotNull Function0<? extends T> objectReader) {
        Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
        Intrinsics.checkNotNullParameter(objectReader, (String)"objectReader");
        int size = DataInputOutputUtil.readINT((DataInput)dataInput);
        ArrayList<Object> objects = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            objects.add(objectReader.invoke());
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T processWithPrecomputedSpecificationType(@NotNull PsiFile psiFile, @NotNull SwSpecificationType specificationType, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)specificationType, (String)"specificationType");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            SwIndexUtilsKt.storeVirtualFileInUserData(psiFile, specificationType);
            object = action.invoke();
        }
        finally {
            SwIndexUtilsKt.storeVirtualFileInUserData(psiFile, null);
        }
        return (T)object;
    }

    private static final void storeVirtualFileInUserData(PsiFile psiFile, SwSpecificationType specificationType) {
        psiFile.putUserData(INDEXED_SPECIFICATION_TYPE_KEY, (Object)specificationType);
    }

    @Nullable
    public static final SwSpecificationType getPrecomputedSpecificationTypeFromUserData(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return (SwSpecificationType)psiFile.getUserData(INDEXED_SPECIFICATION_TYPE_KEY);
    }

    public static final boolean isIndexingRightNow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DumbService.Companion.isDumb(project) || FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null;
    }

    static {
        Key key = Key.create((String)"swIndexedSpecificationType");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INDEXED_SPECIFICATION_TYPE_KEY = key;
    }
}

