/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.frontend.split.editor;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlFileType;
import com.jetbrains.rd.ide.model.ActionCallStrategyKind;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionHandlerStrategyCustomizer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/frontend/split/editor/SqlFrontendActionStrategyCustomizer;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendEditorActionHandlerStrategyCustomizer;", "<init>", "()V", "frontendActionIds", "", "", "getCustomStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "actionId", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.database.frontend.split"})
public final class SqlFrontendActionStrategyCustomizer
implements FrontendEditorActionHandlerStrategyCustomizer {
    @NotNull
    private final List<String> frontendActionIds;

    public SqlFrontendActionStrategyCustomizer() {
        Object[] objectArray = new String[]{"EditorSelectWord", "EditorUnSelectWord", "MoveStatementUp", "MoveStatementDown", "MoveElementLeft", "MoveElementRight", "EditorJoinLines"};
        this.frontendActionIds = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public ActionCallStrategyKind getCustomStrategy(@NotNull String actionId, @NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!this.frontendActionIds.contains(actionId)) {
            return null;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(virtualFile2.getNameSequence());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType fileType2 = fileType;
        return Intrinsics.areEqual((Object)fileType2, (Object)SqlFileType.INSTANCE) ? ActionCallStrategyKind.FrontendFirst : null;
    }
}

