/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanValueConverter
extends ResolvingConverter<String> {
    @NonNls
    private static final String BOOLEAN = "boolean";
    @NonNls
    private static final String[] VARIANTS = new String[]{"false", "true"};
    private final boolean myAllowEmpty;

    public static BooleanValueConverter getInstance(boolean allowEmpty) {
        return new BooleanValueConverter(allowEmpty);
    }

    public BooleanValueConverter() {
        this(false);
    }

    public BooleanValueConverter(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
    }

    @NonNls
    public String[] getAllValues() {
        Object[] strings = ArrayUtil.mergeArrays((String[])this.getTrueValues(), (String[])this.getFalseValues());
        Arrays.sort(strings);
        return strings;
    }

    @NonNls
    public String[] getTrueValues() {
        return new String[]{"true"};
    }

    @NonNls
    public String[] getFalseValues() {
        return new String[]{"false"};
    }

    public boolean isTrue(String s) {
        return Arrays.binarySearch(this.getTrueValues(), s) >= 0;
    }

    @Override
    public String fromString(@Nullable @NonNls String stringValue, @NotNull ConvertContext context) {
        if (context == null) {
            BooleanValueConverter.$$$reportNull$$$0(0);
        }
        if (stringValue != null && (this.myAllowEmpty && stringValue.trim().isEmpty() || Arrays.binarySearch(this.getAllValues(), stringValue) >= 0)) {
            return stringValue;
        }
        return null;
    }

    @Override
    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            BooleanValueConverter.$$$reportNull$$$0(1);
        }
        return s;
    }

    @Override
    @NotNull
    public Collection<String> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            BooleanValueConverter.$$$reportNull$$$0(2);
        }
        List<String> list = Arrays.asList(VARIANTS);
        if (list == null) {
            BooleanValueConverter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            BooleanValueConverter.$$$reportNull$$$0(4);
        }
        return XmlDomBundle.message("dom.converter.format.exception", s, BOOLEAN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/converters/values/BooleanValueConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/converters/values/BooleanValueConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

