/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.utils;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.javadoc.JavaDocHighlightingManagerImpl;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.java.utils.NullabilityUtils;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.uml.java.utils.UmlNodeItemsHighlightingUtil;
import com.intellij.uml.java.utils.UmlPsiUtil;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlJavaUtils {
    private UmlJavaUtils() {
    }

    public static boolean containsJavaFiles(@NotNull PsiDirectory element) {
        if (element == null) {
            UmlJavaUtils.$$$reportNull$$$0(0);
        }
        return !DumbService.isDumb((Project)element.getProject()) && FileTypeIndex.containsFileOfType((FileType)JavaFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)element, (boolean)true));
    }

    public static void appendPresentableNameForJavaType(@NotNull SimpleColoredText text, @NotNull PsiType psiType, @NotNull Project project, boolean isNullable) {
        if (text == null) {
            UmlJavaUtils.$$$reportNull$$$0(1);
        }
        if (psiType == null) {
            UmlJavaUtils.$$$reportNull$$$0(2);
        }
        if (project == null) {
            UmlJavaUtils.$$$reportNull$$$0(3);
        }
        if (psiType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)psiType;
            PsiClass resolved = classType.resolve();
            TextAttributes attributes = resolved instanceof PsiTypeParameter ? UmlNodeItemsHighlightingUtil.resolveTextAttributes(JavaHighlightingColors.TYPE_PARAMETER_NAME_ATTRIBUTES) : (resolved != null ? JavaDocHighlightingManagerImpl.getInstance().getClassDeclarationAttributes(resolved) : UmlNodeItemsHighlightingUtil.resolveTextAttributes(JavaHighlightingColors.CLASS_NAME_ATTRIBUTES));
            UmlNodeItemsHighlightingUtil.appendColored(text, attributes, classType.getClassName());
            PsiType[] typeParameters = classType.getParameters();
            if (typeParameters.length > 0) {
                UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.OPERATION_SIGN, "<", 1);
            }
            for (int i = 0; i < typeParameters.length; ++i) {
                UmlJavaUtils.appendPresentableNameForJavaType(text, typeParameters[i], project, NullabilityUtils.isNullable((PsiAnnotationOwner)typeParameters[i], project));
                if (i == typeParameters.length - 1) continue;
                UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.COMMA, ", ", 1);
            }
            if (typeParameters.length > 0) {
                UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.OPERATION_SIGN, ">", 1);
            }
            if (isNullable) {
                UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.OPERATION_SIGN, "?", 1);
            }
        } else if (psiType instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            PsiType componentType = arrayType.getComponentType();
            UmlJavaUtils.appendPresentableNameForJavaType(text, componentType, project, NullabilityUtils.isNullable((PsiAnnotationOwner)componentType, project));
            UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.BRACKETS, "[]", 1);
            if (isNullable) {
                UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.OPERATION_SIGN, "?", 1);
            }
        } else if (psiType instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)psiType;
            PsiType typeBound = wildcardType.getBound();
            if (typeBound != null) {
                UmlJavaUtils.appendPresentableNameForJavaType(text, typeBound, project, NullabilityUtils.isNullable((PsiAnnotationOwner)typeBound, project));
            } else {
                UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.OPERATION_SIGN, wildcardType.getPresentableText());
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)psiType;
            UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.KEYWORD, primitiveType.getPresentableText());
        } else {
            UmlNodeItemsHighlightingUtil.appendColored(text, JavaHighlightingColors.CLASS_NAME_ATTRIBUTES, psiType.getPresentableText());
        }
    }

    @Nullable
    public static String getPackageName(PsiElement element) {
        if (element instanceof PsiClass) {
            return (String)ReadAction.compute(() -> ((PsiClassOwner)element.getContainingFile()).getPackageName());
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static String getRealPackageName(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            PsiClass aClass = (PsiClass)psiElement;
            while (aClass.getContainingClass() != null) {
                PsiClass c = aClass.getContainingClass();
                if (c == null) {
                    return UmlJavaUtils.getPackageName((PsiElement)c);
                }
                aClass = c;
            }
            return UmlJavaUtils.getPackageName((PsiElement)aClass);
        }
        return UmlJavaUtils.getPackageName(psiElement);
    }

    @Nullable
    public static PsiPackage getPackage(PsiElement element) {
        String fqn = UmlJavaUtils.getRealPackageName(element);
        return fqn == null ? null : JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(fqn);
    }

    public static PackageInfo getInfo(PsiPackage p) {
        return new PackageInfo(p);
    }

    public static boolean prepareClassForWrite(PsiClass psiClass) {
        boolean prepared = CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])new PsiElement[]{psiClass});
        if (!prepared) {
            Messages.showErrorDialog((Project)psiClass.getProject(), (String)DiagramBundle.message((String)"class.is.readonly", (Object[])new Object[]{psiClass.getName()}), (String)DiagramBundle.message((String)"error", (Object[])new Object[0]));
        }
        return prepared;
    }

    @Nullable
    public static String getFQN(@NotNull PsiElement element) {
        if (element == null) {
            UmlJavaUtils.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiClass) {
            return UmlPsiUtil.getClassQualifiedName((PsiClass)element);
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/java/utils/UmlJavaUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containsJavaFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendPresentableNameForJavaType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFQN";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class PackageInfo {
        private int myTotalClassesCount;
        private int myTotalSubpackagesCount;
        private final int myClassesCount;
        private final int mySubpackagesCount;
        @NotNull
        private final String myFqn;

        private PackageInfo(@NotNull PsiPackage p) {
            if (p == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            this.myTotalClassesCount = 0;
            this.myTotalSubpackagesCount = 0;
            this.myFqn = p.getQualifiedName();
            this.myClassesCount = PackageInfo.distinct(PackageInfo.filterKotlinTopLevelClasses(p.getClasses())).length;
            this.mySubpackagesCount = PackageInfo.distinct(p.getSubPackages()).length;
            this.traverse(p);
        }

        private static PsiClass @NotNull [] filterKotlinTopLevelClasses(PsiClass @NotNull [] classes) {
            if (classes == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            PsiClass[] psiClassArray = (PsiClass[])Arrays.stream(classes).filter(it -> !UmlKotlinUtils.TopLevel.isImplicitClassForTopLevelDeclarations(it) || !PackageInfo.isEmpty(it)).toArray(PsiClass[]::new);
            if (psiClassArray == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            return psiClassArray;
        }

        private static boolean isEmpty(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                PackageInfo.$$$reportNull$$$0(3);
            }
            return ArrayUtil.isEmpty((Object[])psiClass.getFields()) && ArrayUtil.isEmpty((Object[])psiClass.getMethods());
        }

        private static <T> T @NotNull [] distinct(T @NotNull [] elements) {
            if (elements == null) {
                PackageInfo.$$$reportNull$$$0(4);
            }
            Set set = ConcurrentCollectionFactory.createConcurrentIdentitySet();
            ContainerUtil.addAll((Collection)set, (Object[])elements);
            T[] TArray = set.toArray(Arrays.copyOf(elements, 0));
            if (TArray == null) {
                PackageInfo.$$$reportNull$$$0(5);
            }
            return TArray;
        }

        private void traverse(@NotNull PsiPackage p) {
            if (p == null) {
                PackageInfo.$$$reportNull$$$0(6);
            }
            this.myTotalClassesCount += PackageInfo.distinct(PackageInfo.filterKotlinTopLevelClasses(p.getClasses())).length;
            this.myTotalSubpackagesCount += PackageInfo.distinct(p.getSubPackages()).length;
            for (PsiPackage aPackage : PackageInfo.distinct(p.getSubPackages())) {
                this.traverse(aPackage);
            }
        }

        @NotNull
        @Nls
        public String toString() {
            String string = DiagramJavaBundle.message("package.info.message", this.myFqn, this.myClassesCount, this.myClassesCount, this.mySubpackagesCount, this.mySubpackagesCount, this.myTotalClassesCount, this.myTotalClassesCount, this.myTotalSubpackagesCount, this.myTotalSubpackagesCount);
            if (string == null) {
                PackageInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/utils/UmlJavaUtils$PackageInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/utils/UmlJavaUtils$PackageInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterKotlinTopLevelClasses";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "distinct";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filterKotlinTopLevelClasses";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEmpty";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "distinct";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "traverse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 7 -> new IllegalStateException(string);
            };
        }
    }
}

