/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex.commit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.commit.CommitChunkCollector;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.CommitSessionInfo;
import com.intellij.vcs.commit.LocalChangesCommitter;
import com.intellij.vcs.commit.NonModalCommitWorkflow;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0016H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/ex/commit/CommitChunkWorkflow;", "Lcom/intellij/vcs/commit/NonModalCommitWorkflow;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "getState", "()Lcom/intellij/vcs/commit/ChangeListCommitState;", "setState", "(Lcom/intellij/vcs/commit/ChangeListCommitState;)V", "range", "Lcom/intellij/openapi/vcs/ex/LocalRange;", "getRange", "()Lcom/intellij/openapi/vcs/ex/LocalRange;", "setRange", "(Lcom/intellij/openapi/vcs/ex/LocalRange;)V", "isDefaultCommitEnabled", "", "()Z", "performCommit", "", "sessionInfo", "Lcom/intellij/vcs/commit/CommitSessionInfo;", "logCommit", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCommitChunkComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitChunkComponent.kt\ncom/intellij/openapi/vcs/ex/commit/CommitChunkWorkflow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,431:1\n774#2:432\n865#2,2:433\n*S KotlinDebug\n*F\n+ 1 CommitChunkComponent.kt\ncom/intellij/openapi/vcs/ex/commit/CommitChunkWorkflow\n*L\n252#1:432\n252#1:433,2\n*E\n"})
final class CommitChunkWorkflow
extends NonModalCommitWorkflow {
    public ChangeListCommitState state;
    public LocalRange range;

    public CommitChunkWorkflow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        Set vcses = ArraysKt.toSet((Object[])abstractVcsArray);
        this.updateVcses(vcses);
    }

    @NotNull
    public final ChangeListCommitState getState() {
        ChangeListCommitState changeListCommitState = this.state;
        if (changeListCommitState != null) {
            return changeListCommitState;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        return null;
    }

    public final void setState(@NotNull ChangeListCommitState changeListCommitState) {
        Intrinsics.checkNotNullParameter((Object)changeListCommitState, (String)"<set-?>");
        this.state = changeListCommitState;
    }

    @NotNull
    public final LocalRange getRange() {
        LocalRange localRange = this.range;
        if (localRange != null) {
            return localRange;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"range");
        return null;
    }

    public final void setRange(@NotNull LocalRange localRange) {
        Intrinsics.checkNotNullParameter((Object)localRange, (String)"<set-?>");
        this.range = localRange;
    }

    @Override
    public boolean isDefaultCommitEnabled() {
        return true;
    }

    @Override
    protected void performCommit(@NotNull CommitSessionInfo sessionInfo) {
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        LocalChangesCommitter committer = new LocalChangesCommitter(this.getProject(), this.getState(), this.getCommitContext(), null, 8, null);
        this.addCommonResultHandlers(sessionInfo, committer);
        committer.addResultHandler(new ShowNotificationCommitResultHandler(committer));
        this.logCommit();
        String string = VcsBundle.message((String)"commit.changes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        committer.runCommit(string, false);
    }

    /*
     * WARNING - void declaration
     */
    private final void logCommit() {
        void $this$filterTo$iv$iv;
        String message = this.getState().getCommitMessage();
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)message);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List messageLines = (List)destination$iv$iv;
        String string = (String)CollectionsKt.getOrNull((List)messageLines, (int)0);
        int subjectLength = string != null ? string.length() : 0;
        int lines = this.getRange().getLine2() - this.getRange().getLine1();
        CommitChunkCollector.INSTANCE.logCommit(AbstractCommitWorkflowKt.isAmendCommitMode(this.getCommitContext()), lines, messageLines.size(), subjectLength);
    }
}

