/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.model;

import com.intellij.database.dialects.hivebase.model.HiveBaseLikeTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseTableColumn;
import com.intellij.database.dialects.hivebase.model.HiveBaseView;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicView;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0004J\u0016\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0004\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/hivebase/model/HiveBaseDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "<init>", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeView", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseView;", "appendProperties", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseLikeTable;", "desc", "joinProperties", "properties", "", "Lcom/intellij/database/model/NameValue;", "describeTableColumn", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTableColumn;", "describeTable", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTable;", "intellij.database.dialects.hivebase"})
@SourceDebugExtension(value={"SMAP\nHiveBaseDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveBaseDescriptionService.kt\ncom/intellij/database/dialects/hivebase/model/HiveBaseDescriptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public class HiveBaseDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof HiveBaseTable ? this.describeTable((HiveBaseTable)e, context) : (basicElement instanceof HiveBaseTableColumn ? this.describeTableColumn((HiveBaseTableColumn)e, context) : (basicElement instanceof HiveBaseView ? this.describeView((HiveBaseView)e, context) : super.content(e, context)));
    }

    private final String describeView(HiveBaseView e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(HiveBaseView.PROPERTIES);
        String desc = super.describeView((BasicView)e, context);
        return this.appendProperties(e, desc);
    }

    @NotNull
    protected final String appendProperties(@NotNull HiveBaseLikeTable e, @NotNull String desc) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        List<NameValue> list = e.getProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProperties(...)");
        List<NameValue> nonIgnoredProperties = list;
        if (!((Collection)nonIgnoredProperties).isEmpty()) {
            return desc + " properties: " + this.joinProperties(nonIgnoredProperties);
        }
        return desc;
    }

    private final String joinProperties(List<? extends NameValue> properties) {
        return CollectionsKt.joinToString$default((Iterable)properties, null, null, null, (int)0, null, HiveBaseDescriptionService::joinProperties$lambda$0, (int)31, null);
    }

    private final String describeTableColumn(HiveBaseTableColumn e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(HiveBaseTableColumn.TYPE);
        ((Collection)context.getDescribed()).add(HiveBaseTableColumn.SORTING);
        Object desc = super.describeColumn((BasicLikeColumn)e, context, "default");
        if (e.getType() != HiveTableColumnType.REGULAR) {
            desc = (String)desc + " " + e.getType();
        }
        if (e.getSorting() != HiveTableColumnSortingOrder.NONE) {
            desc = (String)desc + " " + e.getSorting();
        }
        return desc;
    }

    @NotNull
    protected final String describeTable(@NotNull HiveBaseTable e, @NotNull DescriptionService.Context context) {
        Object desc;
        block6: {
            String it;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ((Collection)context.getDescribed()).add(HiveBaseTable.BUCKETS_NUM);
            ((Collection)context.getDescribed()).add(HiveBaseTable.ROW_FORMAT_SERDE);
            ((Collection)context.getDescribed()).add(HiveBaseTable.SERDE_PROPERTIES);
            ((Collection)context.getDescribed()).add(HiveBaseTable.INPUT_FORMAT);
            ((Collection)context.getDescribed()).add(HiveBaseTable.OUTPUT_FORMAT);
            ((Collection)context.getDescribed()).add(HiveBaseTable.INPUT_DRIVER);
            ((Collection)context.getDescribed()).add(HiveBaseTable.OUTPUT_DRIVER);
            ((Collection)context.getDescribed()).add(HiveBaseTable.PROPERTIES);
            desc = null;
            desc = super.describeTable((BasicTable)e, context);
            if (e.getBucketsNum() != 0) {
                desc = desc + " buckets: " + e.getBucketsNum();
            }
            String string = e.getRowFormatSerde();
            if (string != null) {
                it = string;
                boolean bl = false;
                desc = desc + " serde: " + it;
            }
            List<NameValue> list = e.getSerdeProperties();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSerdeProperties(...)");
            if (!((Collection)list).isEmpty()) {
                List<NameValue> list2 = e.getSerdeProperties();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getSerdeProperties(...)");
                desc = desc + " serdeproperties: " + this.joinProperties(list2);
            }
            String string2 = e.getInputFormat();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                desc = desc + " inputformat: " + it;
            }
            String string3 = e.getOutputFormat();
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                desc = desc + " outputformat: " + it;
            }
            String string4 = e.getInputDriver();
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                desc = desc + " inputdriver: " + it;
            }
            String string5 = e.getOutputDriver();
            if (string5 == null) break block6;
            it = string5;
            boolean bl = false;
            desc = desc + " outputdriver: " + it;
        }
        return this.appendProperties(e, (String)desc);
    }

    private static final CharSequence joinProperties$lambda$0(NameValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName() + " = " + it.getValue();
    }
}

