/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.ActionCallback;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SubmitMutations
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SubmitMutations.$$$reportNull$$$0(0);
        }
        SubmitMutations.updateAvailability(e);
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        e.getPresentation().setEnabled(e.getPresentation().isEnabled() && grid != null && !grid.getDataSupport().hasUnparsedValues());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SubmitMutations.$$$reportNull$$$0(1);
        }
        boolean showPreviewForSeveralTables = DatabaseSettings.getSettings().isEnableShowPreviewForSqlJoins();
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid != null && (grid.getDataHookup().isForSingleSource() || !showPreviewForSeveralTables)) {
            SubmitMutations.submitChangesIfExists(e);
        } else {
            AnAction previewDmAction = e.getActionManager().getActionOrStub("Console.TableResult.PreviewDml");
            if (previewDmAction != null) {
                previewDmAction.actionPerformed(e);
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SubmitMutations.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public static void updateAvailability(@NotNull AnActionEvent e) {
        if (e == null) {
            SubmitMutations.$$$reportNull$$$0(3);
        }
        if (!SubmitMutations.isVisible(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(SubmitMutations.hasChangesToSubmit(e));
    }

    public static boolean hasChangesToSubmit(AnActionEvent e) {
        if (!SubmitMutations.isVisible(e)) {
            return false;
        }
        DataGrid dataGrid = Objects.requireNonNull(GridUtil.getDataGrid((DataContext)e.getDataContext()));
        GridDataSupport support = dataGrid.getDataSupport();
        return support.hasPendingChanges() && !dataGrid.isEditing();
    }

    @NotNull
    public static ActionCallback submitChangesIfExists(AnActionEvent e) {
        if (!SubmitMutations.hasChangesToSubmit(e)) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                SubmitMutations.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }
        DataGrid dataGrid = Objects.requireNonNull(GridUtil.getDataGrid((DataContext)e.getDataContext()));
        ActionCallback actionCallback = dataGrid.submit();
        if (actionCallback == null) {
            SubmitMutations.$$$reportNull$$$0(5);
        }
        return actionCallback;
    }

    public static boolean isVisible(AnActionEvent e) {
        DataGrid dataGrid = GridUtil.getDataGrid((DataContext)e.getDataContext());
        if (dataGrid == null || !dataGrid.isEditable() && DataGridUtilCore.getDatabaseTable((CoreGrid)dataGrid) == null) {
            return false;
        }
        GridDataSupport support = dataGrid.getDataSupport();
        return (!support.isSubmitImmediately() || support.hasPendingChanges()) && !GridUtil.hideEditActions((DataGrid)dataGrid, (String)e.getPlace());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/SubmitMutations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/SubmitMutations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "submitChangesIfExists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateAvailability";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

