/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extensions.SchemaLayoutScripts;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.ScriptedScriptConsumer;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.Version;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.model.Pointer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.CanonicalPathPrefixTree;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceAutoSyncManager;
import com.intellij.sql.database.SqlDataSourceIntrospector;
import com.intellij.sql.database.SqlDataSourceRootsList;
import com.intellij.sql.database.SqlDataSourceTextStorage;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.prefixTree.PrefixTreeFactory;
import com.intellij.util.containers.prefixTree.set.PrefixTreeSet;
import com.intellij.util.containers.prefixTree.set.PrefixTreeSets;
import icons.DatabaseIcons;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlDataSourceImpl
extends AbstractDataSource
implements SqlDataSource,
PersistentStateComponent<State>,
Iconable {
    private final Project myProject;
    private String myParentId;
    private Dbms myDefinedDbms;
    private volatile UrlsStorage myUrlsStorage;
    private String myFilterId;
    private PackageSet myInlineFilter;
    private String myCodeStyleName;
    private String myOutputPath;
    private String myOutputLayout;
    private boolean myAutoSync;
    private final Map<String, String> myScriptOptions;
    private final Map<String, String> myScopes;
    private volatile ModelFactory myModelFactory;
    private volatile BasicModModel myModel;
    private volatile Map<BasicElement, Pointer<DasObject>> myElements;
    private volatile long myRevision;
    private final SimpleModificationTracker myFilesCounter;
    private final SimpleModificationTracker myModelCounter;

    public SqlDataSourceImpl(@NotNull String name2, @NotNull Project project, @Nullable DasDataSource parent) {
        if (name2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(1);
        }
        this.myUrlsStorage = new UrlsStorage(Collections.emptyList());
        this.myOutputLayout = SqlDataSourceImpl.getDefaultLayout();
        this.myAutoSync = true;
        this.myScriptOptions = new LinkedHashMap<String, String>();
        this.myScopes = new LinkedHashMap<String, String>();
        this.myModelFactory = new ModelFactory((ModelTextStorage)new SqlDataSourceTextStorage(this));
        this.myElements = new HashMap<BasicElement, Pointer<DasObject>>();
        this.myRevision = Long.MIN_VALUE;
        this.myFilesCounter = new SimpleModificationTracker();
        this.myModelCounter = new SimpleModificationTracker();
        this.setName(name2);
        this.myProject = project;
        this.myParentId = parent == null ? null : parent.getUniqueId();
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return null;
    }

    private void check() {
        if (!this.isAutoSync()) {
            return;
        }
        ((SqlDataSourceAutoSyncManager)this.myProject.getService(SqlDataSourceAutoSyncManager.class)).check(this);
    }

    public Map<BasicElement, Pointer<DasObject>> getElements() {
        return this.myElements;
    }

    @Nullable
    public Dbms getDefinedDbms() {
        return this.myDefinedDbms;
    }

    public void setDefinedDbms(@Nullable Dbms dbms) {
        this.myDefinedDbms = dbms;
    }

    @Nullable
    public String getFilterId() {
        return this.myFilterId;
    }

    public void setFilterId(@Nullable String filterId) {
        this.myFilterId = filterId;
    }

    @Nullable
    public String getInlineFilter() {
        return this.myInlineFilter == null ? null : this.myInlineFilter.getText();
    }

    public void setInlineFilter(@Nullable String inlineFilter) {
        this.myInlineFilter = SqlDataSourceRootsList.compile(inlineFilter);
    }

    @NotNull
    public NameVersion getDatabaseVersion() {
        DbDataSource parent = this.getParentDataSource();
        NameVersion nameVersion = parent != null ? parent.getDatabaseVersion() : NameVersion.UNKNOWN;
        if (nameVersion == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(2);
        }
        return nameVersion;
    }

    @Nullable
    public DbDataSource getParentDataSource() {
        return this.myParentId == null ? null : DbPsiFacade.getInstance((Project)this.myProject).findDataSource(this.myParentId);
    }

    public void setParentUniqueId(@Nullable String id) {
        this.myParentId = id;
    }

    @Nullable
    public String getParentUniqueId() {
        return this.myParentId;
    }

    @NotNull
    public List<String> getUrls() {
        List<String> list = this.myUrlsStorage.getUrls();
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(4);
        }
        this.myUrlsStorage = new UrlsStorage(urls);
        this.incModificationCount();
        this.incModelModCount();
    }

    public boolean isAutoSync() {
        return this.myAutoSync;
    }

    public void setAutoSync(boolean auto) {
        this.myAutoSync = auto;
    }

    public void sync() {
        ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        SqlDataSourceIntrospector introspector = new SqlDataSourceIntrospector(this);
        try {
            introspector.setModelFactory(this.myModelFactory);
            introspector.compute(indicator);
            this.myRevision = SqlDataSourceImpl.getTotalModCount(introspector.getFilesRevision(), introspector.getNonFilesRevision());
        }
        finally {
            introspector.changed();
        }
    }

    public void clearModel() {
        BasicModModel oldModel = this.myModel;
        this.myModel = null;
        this.myElements = new HashMap<BasicElement, Pointer<DasObject>>();
        this.myRevision = Long.MIN_VALUE;
        this.incModelModCount();
        if (oldModel != null) {
            this.notifyModelReplaced((BasicModel)oldModel, null);
        }
    }

    private void incModelModCount() {
        this.myModelCounter.incModificationCount();
    }

    void onFilesModified() {
        this.myFilesCounter.incModificationCount();
    }

    @NotNull
    public List<SqlFile> getSqlFiles() {
        List list = (List)ReadAction.compute(() -> ContainerUtil.mapNotNull(this.getPsiFilesInner(), f -> (SqlFile)ObjectUtils.tryCast((Object)f, SqlFile.class)));
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getRoots() {
        List<VirtualFile> list = this.myUrlsStorage.getFiles();
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void processFiles(@NotNull Processor<VirtualFile> processor2) {
        if (processor2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(7);
        }
        this.processFilesInner(true, processor2);
    }

    void processFilesInner(final boolean andDirs, final @NotNull Processor<VirtualFile> processor2) {
        if (processor2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(8);
        }
        final FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        final ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        final HashSet visited = new HashSet();
        final GlobalSearchScope filter = this.createFilter();
        for (final VirtualFile file : this.myUrlsStorage.getFiles()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile f) {
                    if (f == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!visited.add(f)) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return result;
                    }
                    if (filter != null && !filter.contains(f)) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result;
                    }
                    if (SqlDataSourceImpl.this.myProject.isDisposed()) {
                        throw new ProcessCanceledException();
                    }
                    if (!((Boolean)ReadAction.compute(() -> fileIndex.isInContent(f))).booleanValue()) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return result;
                    }
                    if (f.isDirectory()) {
                        VirtualFileVisitor.Result result = !andDirs || processor2.process((Object)f) ? CONTINUE : 1.skipTo((VirtualFile)file);
                        if (result == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return result;
                    }
                    SqlLanguageDialect language = SqlDataSourceImpl.getLanguageFast(SqlDataSourceImpl.this.myProject, fileManager, f);
                    if (language != null) {
                        VirtualFileVisitor.Result result = processor2.process((Object)f) ? CONTINUE : 1.skipTo((VirtualFile)file);
                        if (result == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        return result;
                    }
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2, 3, 4, 5, 6 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "f";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/sql/database/SqlDataSourceImpl$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/sql/database/SqlDataSourceImpl$1";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
                    };
                }
            });
        }
    }

    @Nullable
    private GlobalSearchScope createFilter() {
        GlobalSearchScope filter;
        GlobalSearchScope globalSearchScope = filter = this.myFilterId == null ? null : ScopeChooserUtils.findScopeByName((Project)this.myProject, (String)this.myFilterId);
        if (filter != null || this.myInlineFilter == null) {
            return filter;
        }
        return GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)new NamedScope("", this.myInlineFilter));
    }

    private void processPsiFilesInner(@NotNull Processor<PsiFile> processor2) {
        if (processor2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(9);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        this.processFilesInner(false, (Processor<VirtualFile>)((Processor)f -> {
            PsiFile file = psiManager.findFile(f);
            return file == null || processor2.process((Object)file);
        }));
    }

    private List<PsiFile> getPsiFilesInner() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        this.processPsiFilesInner((Processor<PsiFile>)((Processor)files2::add));
        return files2;
    }

    public boolean containsFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        GlobalSearchScope filter = this.createFilter();
        if (filter != null && !filter.contains(file)) {
            return false;
        }
        String url = file.getUrl();
        return this.myUrlsStorage.containsPath(url);
    }

    @NotNull
    public DasModel getModel() {
        this.check();
        Object object = this.myModel == null ? DasUtil.emptyModel() : this.myModel;
        if (object == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(10);
        }
        return object;
    }

    @Nullable
    BasicModModel getModelInner() {
        return this.myModel;
    }

    public void setFiles(VirtualFile[] virtualFiles) {
        this.setUrls(JBIterable.of((Object[])virtualFiles).filterMap(VirtualFile::getUrl).toList());
    }

    public SqlDataSourceImpl copy(boolean withId) {
        SqlDataSourceImpl result = new SqlDataSourceImpl(this.getName(), this.myProject, null);
        result.myParentId = this.myParentId;
        result.myFilterId = this.myFilterId;
        result.myInlineFilter = this.myInlineFilter;
        result.myUrlsStorage = this.myUrlsStorage;
        if (withId) {
            result.setUniqueId(this.getUniqueId());
        }
        result.setOutputLayout(this.myOutputLayout);
        result.setOutputPath(this.myOutputPath);
        result.setCodeStyleName(this.myCodeStyleName);
        result.setScriptOptions(this.myScriptOptions);
        result.setScopes(this.myScopes);
        return result;
    }

    public State getState() {
        State state = new State();
        state.id = this.getUniqueId();
        state.name = this.getName();
        state.dbmsName = this.myDefinedDbms == null ? null : this.myDefinedDbms.getName();
        state.parent = this.myParentId;
        state.filterId = this.myFilterId;
        state.inlineFilter = this.myInlineFilter == null ? null : this.myInlineFilter.getText();
        state.urls = ArrayUtilRt.toStringArray(this.getUrls());
        state.remarks = this.getComment();
        state.group = this.getGroupName();
        state.outLayout = this.myOutputLayout;
        state.outPath = this.myOutputPath;
        state.codeStyleName = this.myCodeStyleName;
        state.scriptOptions = this.myScriptOptions.isEmpty() ? null : new LinkedHashMap<String, String>(this.myScriptOptions);
        state.autoSync = this.myAutoSync;
        state.scopes = this.myScopes.isEmpty() ? null : new LinkedHashMap<String, String>(this.myScopes);
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(11);
        }
        this.setUniqueId(state.id);
        this.setName(state.name);
        this.setDefinedDbms(Dbms.byName((String)state.dbmsName));
        if (state.dbmsName == null && state.languageId != null) {
            SqlLanguageDialect dialect = SqlDialects.findDialectById((String)state.languageId);
            this.myDefinedDbms = dialect == null ? null : dialect.getDbms();
        }
        this.setComment(state.remarks);
        this.setGroupName(StringUtil.nullize((String)state.group));
        this.setUrls(state.urls == null ? Collections.emptyList() : Arrays.asList(state.urls));
        this.myOutputLayout = state.outLayout;
        this.myOutputPath = state.outPath;
        this.myCodeStyleName = state.codeStyleName;
        this.myParentId = state.parent;
        this.myFilterId = state.filterId;
        this.setInlineFilter(state.inlineFilter);
        this.myAutoSync = state.autoSync;
        this.setScriptOptions(state.scriptOptions == null ? Collections.emptyMap() : state.scriptOptions);
        this.setScopes(state.scopes == null ? Collections.emptyMap() : state.scopes);
        if (this.myDefinedDbms == null) {
            try {
                this.setDefinedDbms(this.detectDbms());
            }
            catch (Throwable th) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn(th);
            }
        }
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect((Dbms)this.getDbms());
        if (databaseDialectEx == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(12);
        }
        return databaseDialectEx;
    }

    @NotNull
    public SqlLanguageDialect getSqlDialect() {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect((Dbms)this.getDbms());
        if (sqlLanguageDialect == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(13);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public Dbms detectDbms() {
        DbDataSource parent = this.getParentDataSource();
        if (parent != null) {
            Dbms dbms = parent.getDbms();
            if (dbms == null) {
                SqlDataSourceImpl.$$$reportNull$$$0(14);
            }
            return dbms;
        }
        Dbms dbms = this.detectSqlDialect().getDbms();
        if (dbms == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(15);
        }
        return dbms;
    }

    @NotNull
    private SqlLanguageDialect detectSqlDialect() {
        SqlLanguageDialect dialect = this.getSqlDialectFromFiles();
        if (dialect == null) {
            dialect = SqlDialectMappings.getMapping((Project)this.getProject(), null);
        }
        SqlLanguageDialect sqlLanguageDialect = dialect;
        if (sqlLanguageDialect == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(16);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    private SqlLanguageDialect getSqlDialectFromFiles() {
        Set<SqlLanguageDialect> dialects = this.getSqlDialectsFromFiles();
        if (dialects.isEmpty()) {
            return null;
        }
        SqlLanguageDialect def = SqlDialectMappings.getMapping((Project)this.myProject, null);
        dialects.remove(def);
        SqlLanguageDialect nonDef = (SqlLanguageDialect)ContainerUtil.getFirstItem(dialects);
        return (SqlLanguageDialect)ObjectUtils.notNull((Object)nonDef, (Object)def);
    }

    @NotNull
    private Set<SqlLanguageDialect> getSqlDialectsFromFiles() {
        FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        LinkedHashSet<SqlLanguageDialect> res2 = new LinkedHashSet<SqlLanguageDialect>();
        SqlDialectMappings dialects = SqlDialectMappings.getInstance((Project)this.myProject);
        this.processFilesInner(true, (Processor<VirtualFile>)((Processor)f -> {
            if (f.isDirectory()) {
                ContainerUtil.addIfNotNull((Collection)res2, (Object)((SqlLanguageDialect)dialects.getImmediateMapping(f)));
            } else {
                ContainerUtil.addIfNotNull((Collection)res2, (Object)SqlDataSourceImpl.getLanguageFast(this.myProject, fileManager, f));
            }
            return true;
        }));
        List<VirtualFile> roots = this.getRoots();
        if (roots.isEmpty()) {
            res2.add(dialects.getMapping(null));
        } else {
            for (VirtualFile root : roots) {
                res2.add(dialects.getMapping(root));
            }
        }
        LinkedHashSet<SqlLanguageDialect> linkedHashSet = res2;
        if (linkedHashSet == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(17);
        }
        return linkedHashSet;
    }

    @Nullable
    private static SqlLanguageDialect getLanguageFast(Project project, FileManager fileManager, VirtualFile f) {
        FileViewProvider vp = (FileViewProvider)ReadAction.compute(() -> fileManager.findViewProvider(f));
        Language bl = vp.getBaseLanguage();
        if (bl instanceof SqlLanguageDialect) {
            return (SqlLanguageDialect)bl;
        }
        Language pl = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)f);
        return (SqlLanguageDialect)ObjectUtils.tryCast((Object)pl, SqlLanguageDialect.class);
    }

    public Icon getIcon(int flags) {
        Icon icon = this.getDbms().getIcon();
        return LayeredIcon.layeredIcon((Icon[])((Icon[])ContainerUtil.ar((Object[])new Icon[]{icon, DatabaseIcons.DdlDataSourceOverlay})));
    }

    public void update(@NotNull Map<BasicElement, Pointer<DasObject>> mapping) {
        if (mapping == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(18);
        }
        this.myElements = mapping;
        this.incModificationCount();
    }

    public void setModel(BasicModModel newModel) {
        BasicModModel oldModel = this.myModel;
        if (oldModel == newModel) {
            return;
        }
        if (oldModel != null) {
            this.myModel.shelve(false);
        }
        this.myModel = newModel;
        this.myElements.clear();
        this.incModificationCount();
        this.notifyModelReplaced((BasicModel)oldModel, (BasicModel)newModel);
    }

    public long getModelRevision() {
        return this.myRevision;
    }

    public long getModificationCount() {
        return super.getModificationCount() + this.getModelModificationCount();
    }

    public boolean equalConfiguration(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(19);
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (!Objects.equals(this.getDefinedDbms(), o.getDefinedDbms())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myParentId, (CharSequence)o.myParentId)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myFilterId, (CharSequence)o.myFilterId)) {
            return false;
        }
        if (this.myInlineFilter == null || o.myInlineFilter == null ? this.myInlineFilter != o.myInlineFilter : !this.myInlineFilter.getText().equals(o.myInlineFilter.getText())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myOutputLayout, (CharSequence)o.myOutputLayout)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myOutputPath, (CharSequence)o.myOutputPath)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myCodeStyleName, (CharSequence)o.myCodeStyleName)) {
            return false;
        }
        if (!Objects.equals(this.myScriptOptions, o.myScriptOptions)) {
            return false;
        }
        if (!Objects.equals(this.myAutoSync, o.myAutoSync)) {
            return false;
        }
        if (!Objects.equals(this.myScopes, o.myScopes)) {
            return false;
        }
        return this.getUrls().equals(o.getUrls());
    }

    @NotNull
    public Map<String, String> getScriptOptions() {
        Map<String, String> map2 = this.myScriptOptions;
        if (map2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(20);
        }
        return map2;
    }

    public void setScriptOptions(@NotNull Map<String, String> scriptOptions) {
        if (scriptOptions == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(21);
        }
        this.myScriptOptions.clear();
        this.myScriptOptions.putAll(scriptOptions);
    }

    @NlsSafe
    @Nullable
    public String getCodeStyleName() {
        return this.myCodeStyleName;
    }

    public void setCodeStyleName(@Nullable String codeStyleName) {
        this.myCodeStyleName = codeStyleName;
    }

    public void setOutputPath(@Nullable String outputPath) {
        this.myOutputPath = outputPath;
    }

    public void setOutputLayout(@Nullable String outputLayout) {
        this.myOutputLayout = outputLayout;
    }

    @Nullable
    public String getOutputPath() {
        return this.myOutputPath == null ? SqlDataSourceImpl.getDefaultOutputPath(this.myProject, this.myUrlsStorage.getFiles()) : this.myOutputPath;
    }

    @Nullable
    public String getOutputLayout() {
        return this.myOutputLayout == null ? SqlDataSourceImpl.getDefaultLayout() : this.myOutputLayout;
    }

    @Nullable
    @NlsSafe
    public static String getDefaultOutputPath(Project project, List<VirtualFile> files2) {
        VirtualFile candidate = VfsUtil.getCommonAncestor(files2);
        VirtualFile ancestor = candidate != null && !candidate.isDirectory() ? candidate.getParent() : candidate;
        boolean good = ancestor != null && (Boolean)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)project).isInContent(ancestor)) != false;
        return good ? ancestor.getPath() : null;
    }

    @NlsSafe
    @Nullable
    public static String getDefaultLayout() {
        Path def = SchemaLayoutScripts.getDefaultScript();
        if (def == null) {
            List<Path> files2 = SchemaLayoutScripts.getScriptFiles();
            def = (Path)ContainerUtil.getFirstItem(files2);
        }
        return def == null ? null : def.getFileName().toString();
    }

    @Nullable
    public DasObject fromModel(@Nullable DasObject delegate) {
        DasObject res2;
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        Pointer<DasObject> element = this.myElements == null ? null : this.myElements.get(delegate);
        DasObject dasObject = res2 = element == null ? null : (DasObject)element.dereference();
        if (res2 == null && delegate != null && (res2 = this.findSqlElement(delegate)) != null && delegate instanceof BasicElement) {
            Object pointer = res2 instanceof PsiElement ? new SqlModelBuilder.CastedPointer((Pointer)SmartPointerManager.createPointer((PsiElement)((PsiElement)res2)), DasObject.class) : new RefPointer<DasObject>(new WeakReference<DasObject>(res2));
            this.myElements.put((BasicElement)delegate, (Pointer<DasObject>)pointer);
        }
        return res2;
    }

    private DasObject findSqlElement(@NotNull DasObject e) {
        if (e == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(22);
        }
        NamingService ns = NamingServices.getNamingService((Dbms)this.getDbms());
        JBIterable<DasObject> candidates2 = this.findInFiles(e, this.getSqlDialect(), ns);
        JBIterable psiObjects = candidates2.filter(o -> !(o instanceof DbElement)).filter(PsiObject.class).collect();
        String identity = ObjectPaths.getIdentity((DasObject)e);
        if (identity == null) {
            return (DasObject)psiObjects.first();
        }
        return (DasObject)psiObjects.filter(o -> identity.equals(ObjectPaths.getIdentity((DasObject)o))).append((Iterable)psiObjects).first();
    }

    @NotNull
    private JBIterable<DasObject> findInFiles(@NotNull DasObject e, SqlLanguageDialect dialect, NamingService ns) {
        if (e == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(23);
        }
        StringBuilder text = new StringBuilder();
        for (DasObject o = e; o != null && !o.getName().isEmpty(); o = o.getDasParent()) {
            if (!text.isEmpty()) {
                text.insert(0, '.');
            }
            text.insert(0, ns.enquote(o.getName(), o.getKind()));
        }
        if (text.isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDataSourceImpl.$$$reportNull$$$0(24);
            }
            return jBIterable;
        }
        DbDataSource dbDs = DbPsiFacade.getInstance((Project)this.myProject).findDataSource(this.getUniqueId());
        if (dbDs == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDataSourceImpl.$$$reportNull$$$0(25);
            }
            return jBIterable;
        }
        JBIterable jBIterable = SqlDataSourceImpl.findCandidatesInContext(e, dialect, (PsiElement)dbDs, text.toString()).map(r -> r.getTargetSymbol().getDasObject()).unique();
        if (jBIterable == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<SqlResolveResult> findCandidatesInContext(@NotNull DasObject e, SqlLanguageDialect dialect, PsiElement psiContext, String text) {
        SqlReferenceExpression ref2;
        if (e == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(27);
        }
        if ((ref2 = SqlPsiElementFactory.createReferenceFromText((String)text, (SqlLanguageDialect)dialect, (SqlReferenceElementType)SqlCompositeElementTypes.SQL_REFERENCE, (PsiElement)psiContext)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDataSourceImpl.$$$reportNull$$$0(28);
            }
            return jBIterable;
        }
        SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)ref2.getContainingFile(), (Object)true);
        JBIterable jBIterable = JBIterable.of((Object[])ref2.multiResolve(false)).filter(SqlResolveResult.class).filter(o -> o.getTargetSymbol().getKind() == e.getKind());
        if (jBIterable == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    public long getModelModificationCount() {
        return SqlDataSourceImpl.getTotalModCount(this.getFileModCount(), this.getNonFileModCount());
    }

    private static long getTotalModCount(long fileModCount, long nonFileModCount) {
        return fileModCount + nonFileModCount;
    }

    long getNonFileModCount() {
        return this.myModelCounter.getModificationCount();
    }

    long getFileModCount() {
        return this.myFilesCounter.getModificationCount();
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getDefinedDbms();
        Dbms dbms2 = dbms == null ? this.detectDbms() : dbms;
        if (dbms2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(30);
        }
        return dbms2;
    }

    @Nullable
    public Version getVersion() {
        DbDataSource parent = this.getParentDataSource();
        return parent != null ? parent.getVersion() : null;
    }

    @TestOnly
    public void waitComputed() {
        ((SqlDataSourceAutoSyncManager)this.myProject.getService(SqlDataSourceAutoSyncManager.class)).waitComputed(this);
    }

    @TestOnly
    public void setModelFactory(ModelFactory mf) {
        this.myModelFactory = mf;
        this.incModelModCount();
    }

    @Nullable
    public ObjectPath getScope(@NotNull VirtualFile file, @NotNull Dbms dbms) {
        if (file == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(31);
        }
        if (dbms == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(32);
        }
        ObjectPath manual = this.getScopeFromScopes(file, dbms);
        ObjectPath automatic = this.getScopeFromScript(file);
        return SqlDataSourceImpl.extendAndMerge(automatic, manual, dbms);
    }

    @Nullable
    private ObjectPath getScopeFromScript(@NotNull VirtualFile file) {
        if (file == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(33);
        }
        try {
            return this.getScopeFromScriptRaw(file);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    public Map<String, String> getScopes() {
        Map<String, String> map2 = Collections.unmodifiableMap(this.myScopes);
        if (map2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(34);
        }
        return map2;
    }

    public void setScopes(@NotNull Map<String, String> scopes) {
        if (scopes == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(35);
        }
        this.myScopes.clear();
        for (Map.Entry<String, String> entry : scopes.entrySet()) {
            this.myScopes.put(StringUtil.trimEnd((String)PathUtil.toSystemIndependentName((String)entry.getKey()), (String)"/"), entry.getValue());
        }
        this.incModelModCount();
    }

    public void handleScopeRename(@NotNull ObjectPath path, @NotNull String newName) {
        if (path == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(36);
        }
        if (newName == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(37);
        }
        path = this.cleanUp(path);
        ObjectPath renamedPath = ObjectPath.create((String)newName, (ObjectKind)path.kind, (boolean)false, null, (ObjectPath)path.parent);
        LinkedHashMap<String, ObjectPath> scopes = new LinkedHashMap<String, ObjectPath>();
        ObjectKind rootKind = path.parent == null ? path.kind : path.parent.kind;
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)SqlDialects.getGenericDialect())).createLexer(this.myProject);
        NamingService ns = NamingServices.getNamingService((Dbms)Dbms.UNKNOWN);
        LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>(this.myScopes);
        boolean changed = false;
        for (Map.Entry entry : copy.entrySet()) {
            ObjectPath newPath;
            String scope2 = (String)entry.getValue();
            ObjectPath scopePath = (ObjectPath)scopes.get(scope2);
            if (scopePath == null) {
                scopePath = SqlDataSourceImpl.convertToObjectPath(scope2, rootKind, lexer, ns);
                scopes.put(scope2, scopePath);
            }
            if (path.isAncestorOf(scopePath, false)) {
                newPath = scopePath.rebase(renamedPath);
            } else {
                if (path.parent != scopePath || !path.name.isEmpty()) continue;
                newPath = renamedPath;
            }
            String newScope = SqlDataSourceImpl.getScopeText(newPath, ns);
            entry.setValue(newScope);
            changed = true;
        }
        if (!changed && path.name.isEmpty() && (path.parent == null || path.parent.name.isEmpty())) {
            String root = this.getOutputPath();
            copy.put(root, SqlDataSourceImpl.getScopeText(renamedPath, ns));
            changed = true;
        }
        if (changed) {
            this.setScopes(copy);
        }
    }

    @NotNull
    private ObjectPath cleanUp(@NotNull ObjectPath path) {
        if (path == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(38);
        }
        ObjectPath objectPath = (ObjectPath)path.reduce(null, (r, o) -> ObjectPath.create((String)o.name, (ObjectKind)o.kind, (boolean)true, null, (ObjectPath)r));
        if (objectPath == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(39);
        }
        return objectPath;
    }

    @NotNull
    private static String getScopeText(ObjectPath path, NamingService ns) {
        String string = ((StringBuilder)path.reduce((Object)new StringBuilder(), (r, o) -> {
            if (!r.isEmpty()) {
                r.append('.');
            }
            r.append(ns.catToScript(o.name, o.kind, !o.isQuoted()));
            return r;
        })).toString();
        if (string == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Nullable
    private ObjectPath getScopeFromScopes(@NotNull VirtualFile file, @NotNull Dbms dbms) {
        String path;
        if (file == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(41);
        }
        if (dbms == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(42);
        }
        String output = this.getOutputPath();
        String scope2 = null;
        for (VirtualFile f = file; f != null && (scope2 = this.myScopes.get(path = f.getPath())) == null && !path.equals(output); f = f.getParent()) {
        }
        if (scope2 == null) {
            return null;
        }
        return this.convertToObjectPath(scope2, dbms);
    }

    @NotNull
    private ObjectPath convertToObjectPath(@NotNull String scope2, @NotNull Dbms dbms) {
        BasicMetaModel mm;
        if (scope2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(43);
        }
        if (dbms == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(44);
        }
        ObjectKind rootKind = (mm = DbImplUtilCore.getMetaModel((Dbms)dbms)).getRootNamespaceKinds().contains((Object)ObjectKind.DATABASE) ? ObjectKind.DATABASE : ObjectKind.SCHEMA;
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)SqlDialects.getGenericDialect())).createLexer(this.myProject);
        NamingService ns = NamingServices.getNamingService((Dbms)Dbms.UNKNOWN);
        return SqlDataSourceImpl.convertToObjectPath(scope2, rootKind, lexer, ns);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static ObjectPath convertToObjectPath(@NotNull String scope2, ObjectKind rootKind, Lexer lexer, NamingService ns) {
        if (scope2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(45);
        }
        @Nullable @NotNull Pair ref2 = BasicParentReference.parseNameRef((String)scope2, (NamingService)ns, (Lexer)lexer);
        ObjectPath path = ObjectPath.create((String)(ref2.first == null ? (String)ref2.second : (String)ref2.first), (ObjectKind)rootKind);
        if (ref2.first == null || rootKind != ObjectKind.DATABASE) {
            ObjectPath objectPath = path;
            if (objectPath == null) {
                SqlDataSourceImpl.$$$reportNull$$$0(46);
            }
            return objectPath;
        }
        ObjectPath objectPath = path.append((String)ref2.second, ObjectKind.SCHEMA);
        if (objectPath == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(47);
        }
        return objectPath;
    }

    @Nullable
    private ObjectPath getScopeFromScriptRaw(@NotNull VirtualFile file) {
        ScriptedScriptConsumer consumer;
        if (file == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(48);
        }
        if ((consumer = DumpToDdlDataSourceActionKt.createScriptConsumerSafe(this.getProject(), this, (Function2<? super Path, ? super ScriptingResult, Unit>)((Function2)(path, result) -> null))) == null) {
            return null;
        }
        Path path2 = file.toNioPath();
        return consumer.getScope(path2);
    }

    @Nullable
    private static ObjectPath extendAndMerge(@Nullable ObjectPath path, @Nullable ObjectPath other, Dbms dbms) {
        if (path == null) {
            return other;
        }
        if (other != null && other.findParent(path.kind, false) != null) {
            return other;
        }
        BasicMetaModel metaModel = DbImplUtilCore.getMetaModel((Dbms)dbms);
        ObjectKind topKind = (ObjectKind)path.reduce(null, (k, p2) -> k == null ? p2.kind : k);
        if (metaModel.getRootNamespaceKinds().contains((Object)topKind)) {
            return path;
        }
        ObjectPath res2 = null;
        List rp = (List)metaModel.getPathsToRoot(path.kind).first();
        if (rp == null) {
            return other;
        }
        for (int i = rp.size() - 2; i > 0; --i) {
            ObjectPath otherPart = other == null ? null : other.findParent((ObjectKind)rp.get(i), false);
            res2 = otherPart == null ? ObjectPath.create((String)"", (ObjectKind)((ObjectKind)rp.get(i)), (boolean)true, null, (ObjectPath)res2) : ObjectPath.copyUnder((ObjectPath)otherPart, res2);
        }
        if (res2 == null) {
            return other;
        }
        return (ObjectPath)path.reduce(res2, (r, o) -> r.append(o.name, o.kind, o.isQuoted(), o.getIdentity()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 10, 12, 13, 14, 15, 16, 17, 20, 24, 25, 26, 28, 29, 30, 34, 39, 40, 46, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 39: 
            case 40: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptOptions";
                break;
            }
            case 22: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 31: 
            case 33: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "detectDbms";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "detectSqlDialect";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectsFromFiles";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptOptions";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findInFiles";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findCandidatesInContext";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopes";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUp";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeText";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToObjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 39: 
            case 40: 
            case 46: 
            case 47: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFilesInner";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setScriptOptions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSqlElement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findInFiles";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findCandidatesInContext";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getScopeFromScript";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setScopes";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "handleScopeRename";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "cleanUp";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getScopeFromScopes";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "convertToObjectPath";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getScopeFromScriptRaw";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 10, 12, 13, 14, 15, 16, 17, 20, 24, 25, 26, 28, 29, 30, 34, 39, 40, 46, 47 -> new IllegalStateException(string);
        };
    }

    private static class UrlsStorage {
        private final PrefixTreeSet<String> trie;
        private final List<String> urls;
        private final Collection<LightFilePointer> pointers;

        UrlsStorage(List<String> urls) {
            this.urls = Collections.unmodifiableList(urls);
            this.trie = PrefixTreeSets.toPrefixTreeSet(urls, (PrefixTreeFactory)CanonicalPathPrefixTree.INSTANCE);
            this.pointers = ContainerUtil.map(urls, LightFilePointer::new);
        }

        public boolean containsPath(String path) {
            return !this.trie.getAncestors((Object)path).isEmpty();
        }

        public List<String> getUrls() {
            return this.urls;
        }

        public List<VirtualFile> getFiles() {
            return ContainerUtil.mapNotNull(this.pointers, it -> it.getFile());
        }
    }

    public static final class State {
        public String id;
        public String name;
        public String languageId;
        public String dbmsName;
        public String parent;
        public String inlineFilter;
        public String filterId;
        public String[] urls;
        public String remarks;
        public String group;
        public String outPath;
        public String codeStyleName;
        @NlsSafe
        public String outLayout;
        public Map<String, String> scriptOptions;
        public Map<String, String> scopes;
        public boolean autoSync = true;
    }

    private static class RefPointer<T>
    implements Pointer<T> {
        private final Reference<T> myRef;

        private RefPointer(@NotNull Reference<T> ref2) {
            if (ref2 == null) {
                RefPointer.$$$reportNull$$$0(0);
            }
            this.myRef = ref2;
        }

        @Nullable
        public T dereference() {
            return this.myRef.get();
        }

        public boolean equals(Object o) {
            return o instanceof RefPointer && ((RefPointer)o).myRef.equals(this.myRef);
        }

        public int hashCode() {
            return this.myRef.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/database/SqlDataSourceImpl$RefPointer", "<init>"));
        }
    }
}

