/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.models.chat;

import com.intellij.aiplayground.models.LlmModelId;
import com.intellij.aiplayground.models.LlmProviderId;
import com.intellij.aiplayground.models.LlmProviderInstanceId;
import com.intellij.aiplayground.models.chat.AssistantMessage;
import com.intellij.aiplayground.models.chat.Chat;
import com.intellij.aiplayground.models.chat.ChatId;
import com.intellij.aiplayground.models.chat.ChatMessage;
import com.intellij.aiplayground.models.chat.ChatMessageId;
import com.intellij.aiplayground.models.chat.ChatModelLink;
import com.intellij.aiplayground.models.chat.ChatModelLinkId;
import com.intellij.aiplayground.models.chat.ChatPersistenceSerializer$ChatDto$;
import com.intellij.aiplayground.models.chat.ChatPersistenceSerializer$ChatMessageDto$;
import com.intellij.aiplayground.models.chat.ChatPersistenceSerializer$ChatModelLinkDto$;
import com.intellij.aiplayground.models.chat.ChatPersistenceSerializer$TokenUsageDto$;
import com.intellij.aiplayground.models.chat.SystemMessage;
import com.intellij.aiplayground.models.chat.TokenUsage;
import com.intellij.aiplayground.models.chat.UserMessage;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.BooleanSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fJ\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "json", "Lkotlinx/serialization/json/Json;", "chatDirectoryPath", "", "getChatDirectoryPath", "()Ljava/lang/String;", "loadChats", "", "Lcom/intellij/aiplayground/models/chat/Chat;", "syncChats", "", "chats", "saveChat", "chat", "chatDir", "Ljava/io/File;", "ChatDto", "ChatModelLinkDto", "ChatMessageDto", "TokenUsageDto", "intellij.aiplayground.models"})
@SourceDebugExtension(value={"SMAP\nChatPersistenceSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPersistenceSerializer.kt\ncom/intellij/aiplayground/models/chat/ChatPersistenceSerializer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n11546#2,9:255\n13472#2:264\n13473#2:267\n11555#2:268\n222#3:265\n205#3:274\n1#4:266\n1068#5:269\n1563#5:270\n1634#5,3:271\n*S KotlinDebug\n*F\n+ 1 ChatPersistenceSerializer.kt\ncom/intellij/aiplayground/models/chat/ChatPersistenceSerializer\n*L\n38#1:255,9\n38#1:264\n38#1:267\n38#1:268\n41#1:265\n88#1:274\n38#1:266\n48#1:269\n61#1:270\n61#1:271,3\n*E\n"})
public final class ChatPersistenceSerializer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Json json;

    public ChatPersistenceSerializer() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.json = JsonKt.Json$default(null, ChatPersistenceSerializer::json$lambda$0, (int)1, null);
    }

    private final String getChatDirectoryPath() {
        return PathManager.getSystemPath() + "/aiplayground/chats";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Chat> loadChats() {
        void $this$mapNotNullTo$iv$iv;
        File[] chatFiles;
        File chatDir = new File(this.getChatDirectoryPath());
        if (!chatDir.exists()) {
            chatDir.mkdirs();
            return CollectionsKt.emptyList();
        }
        File[] fileArray = chatDir.listFiles(ChatPersistenceSerializer::loadChats$lambda$1);
        if (fileArray == null) {
            return CollectionsKt.emptyList();
        }
        File[] $this$mapNotNull$iv = chatFiles = fileArray;
        boolean $i$f$mapNotNull = false;
        File[] fileArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Chat it$iv$iv;
            Chat chat2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void file = element$iv$iv;
            boolean bl2 = false;
            try {
                void this_$iv;
                Intrinsics.checkNotNull((Object)file);
                String serializedChat = FilesKt.readText$default((File)file, null, (int)1, null);
                Json json = this.json;
                String string$iv = serializedChat;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                ChatDto chatDto = (ChatDto)this_$iv.decodeFromString((DeserializationStrategy)ChatDto.Companion.serializer(), string$iv);
                chat2 = chatDto.toChat();
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse chat file: " + file.getName(), (Throwable)e);
                chat2 = null;
            }
            if (chat2 == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Chat it = (Chat)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getUpdatedAt());
                it = (Chat)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getUpdatedAt()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void syncChats(@NotNull List<Chat> chats) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chats, (String)"chats");
        File chatDir = new File(this.getChatDirectoryPath());
        if (!chatDir.exists()) {
            chatDir.mkdirs();
        }
        Iterable $this$map$iv = chats;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Chat chat2 = (Chat)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChatId.box-impl(it.getId-RNhTleA()));
        }
        Set existingChatIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        File[] fileArray = chatDir.listFiles(ChatPersistenceSerializer::syncChats$lambda$5);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (File file : fileArray) {
            Intrinsics.checkNotNull((Object)file);
            String fileId = FilesKt.getNameWithoutExtension((File)file);
            if (existingChatIds.contains(ChatId.box-impl(ChatId.constructor-impl(fileId)))) continue;
            file.delete();
        }
        for (Chat chat3 : chats) {
            this.saveChat(chat3, chatDir);
        }
    }

    public final void saveChat(@NotNull Chat chat2) {
        Intrinsics.checkNotNullParameter((Object)chat2, (String)"chat");
        File chatDir = new File(this.getChatDirectoryPath());
        if (!chatDir.exists()) {
            chatDir.mkdirs();
        }
        this.saveChat(chat2, chatDir);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveChat(Chat chat2, File chatDir) {
        try {
            void this_$iv;
            ChatDto chatDto = ChatDto.Companion.fromChat(chat2);
            Json json = this.json;
            ChatDto value$iv = chatDto;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String serializedChat = this_$iv.encodeToString((SerializationStrategy)ChatDto.Companion.serializer(), (Object)value$iv);
            FilesKt.writeText$default((File)new File(chatDir, chat2.getId-RNhTleA() + ".json"), (String)serializedChat, null, (int)2, null);
        }
        catch (Exception e) {
            this.logger.error("Failed to save chat: " + ChatId.toString-impl(chat2.getId-RNhTleA()), (Throwable)e);
        }
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    private static final boolean loadChats$lambda$1(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".json", (boolean)false, (int)2, null);
    }

    private static final boolean syncChats$lambda$5(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".json", (boolean)false, (int)2, null);
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 32\u00020\u0001:\u000234BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u00a2\u0006\u0004\b\r\u0010\u000eB_\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\r\u0010\u0013J\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u00c6\u0003JS\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0010H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001J%\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\b2R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018\u00a8\u00065"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatDto;", "", "id", "", "title", "messages", "", "Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatMessageDto;", "createdAt", "", "updatedAt", "activeModels", "Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatModelLinkDto;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;JJLjava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/List;JJLjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()Ljava/lang/String;", "getTitle", "getMessages", "()Ljava/util/List;", "getCreatedAt", "()J", "getUpdatedAt", "getActiveModels", "toChat", "Lcom/intellij/aiplayground/models/chat/Chat;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_aiplayground_models", "Companion", "$serializer", "intellij.aiplayground.models"})
    @SourceDebugExtension(value={"SMAP\nChatPersistenceSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPersistenceSerializer.kt\ncom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatDto\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1563#2:255\n1634#2,3:256\n1208#2,2:259\n1236#2,4:261\n1617#2,9:265\n1869#2:274\n1870#2:276\n1626#2:277\n1#3:275\n*S KotlinDebug\n*F\n+ 1 ChatPersistenceSerializer.kt\ncom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatDto\n*L\n124#1:255\n124#1:256,3\n127#1:259,2\n127#1:261,4\n131#1:265,9\n131#1:274\n131#1:276\n131#1:277\n131#1:275\n*E\n"})
    private static final class ChatDto {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @Nullable
        private final String title;
        @NotNull
        private final List<ChatMessageDto> messages;
        private final long createdAt;
        private final long updatedAt;
        @NotNull
        private final List<ChatModelLinkDto> activeModels;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public ChatDto(@NotNull String id, @Nullable String title, @NotNull List<ChatMessageDto> messages, long createdAt, long updatedAt, @NotNull List<ChatModelLinkDto> activeModels) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(messages, (String)"messages");
            Intrinsics.checkNotNullParameter(activeModels, (String)"activeModels");
            this.id = id;
            this.title = title;
            this.messages = messages;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.activeModels = activeModels;
        }

        public /* synthetic */ ChatDto(String string, String string2, List list, long l, long l2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2, list, l, l2, list2);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final List<ChatMessageDto> getMessages() {
            return this.messages;
        }

        public final long getCreatedAt() {
            return this.createdAt;
        }

        public final long getUpdatedAt() {
            return this.updatedAt;
        }

        @NotNull
        public final List<ChatModelLinkDto> getActiveModels() {
            return this.activeModels;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Chat toChat() {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$associateByTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.activeModels;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it;
                ChatModelLinkDto chatModelLinkDto = (ChatModelLinkDto)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(new ChatModelLink(ChatModelLinkId.constructor-impl(((ChatModelLinkDto)((Object)it)).getId()), LlmProviderId.constructor-impl(((ChatModelLinkDto)((Object)it)).getProviderId()), LlmProviderInstanceId.constructor-impl(((ChatModelLinkDto)((Object)it)).getInstanceId()), LlmModelId.constructor-impl(((ChatModelLinkDto)((Object)it)).getModelId()), null, 16, null));
            }
            List activeModels = (List)destination$iv$iv;
            Iterable $this$associateBy$iv = activeModels;
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo22 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ChatModelLink chatModelLink = (ChatModelLink)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.put(ChatModelLinkId.box-impl(it.getId-Zfeyzjw()), element$iv$iv);
            }
            Map modelsById = destination$iv$iv2;
            $this$associateBy$iv = this.messages;
            String string = null;
            String string2 = this.title;
            String string3 = ChatId.constructor-impl(this.id);
            boolean $i$f$mapNotNull = false;
            void capacity$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChatMessage it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ChatMessageDto it = (ChatMessageDto)element$iv$iv;
                boolean bl2 = false;
                if (it.toChatMessage(modelsById) == null) continue;
                boolean bl3 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 132;
            boolean bl = false;
            List list2 = activeModels;
            long l = this.updatedAt;
            long l2 = this.createdAt;
            List list3 = list;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            return new Chat(string6, string5, string4, list3, l2, l, list2, bl, n, defaultConstructorMarker);
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.title;
        }

        @NotNull
        public final List<ChatMessageDto> component3() {
            return this.messages;
        }

        public final long component4() {
            return this.createdAt;
        }

        public final long component5() {
            return this.updatedAt;
        }

        @NotNull
        public final List<ChatModelLinkDto> component6() {
            return this.activeModels;
        }

        @NotNull
        public final ChatDto copy(@NotNull String id, @Nullable String title, @NotNull List<ChatMessageDto> messages, long createdAt, long updatedAt, @NotNull List<ChatModelLinkDto> activeModels) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(messages, (String)"messages");
            Intrinsics.checkNotNullParameter(activeModels, (String)"activeModels");
            return new ChatDto(id, title, messages, createdAt, updatedAt, activeModels);
        }

        public static /* synthetic */ ChatDto copy$default(ChatDto chatDto, String string, String string2, List list, long l, long l2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = chatDto.id;
            }
            if ((n & 2) != 0) {
                string2 = chatDto.title;
            }
            if ((n & 4) != 0) {
                list = chatDto.messages;
            }
            if ((n & 8) != 0) {
                l = chatDto.createdAt;
            }
            if ((n & 0x10) != 0) {
                l2 = chatDto.updatedAt;
            }
            if ((n & 0x20) != 0) {
                list2 = chatDto.activeModels;
            }
            return chatDto.copy(string, string2, list, l, l2, list2);
        }

        @NotNull
        public String toString() {
            return "ChatDto(id=" + this.id + ", title=" + this.title + ", messages=" + this.messages + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", activeModels=" + this.activeModels + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
            result = result * 31 + ((Object)this.messages).hashCode();
            result = result * 31 + Long.hashCode(this.createdAt);
            result = result * 31 + Long.hashCode(this.updatedAt);
            result = result * 31 + ((Object)this.activeModels).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChatDto)) {
                return false;
            }
            ChatDto chatDto = (ChatDto)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)chatDto.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)chatDto.title)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.messages, chatDto.messages)) {
                return false;
            }
            if (this.createdAt != chatDto.createdAt) {
                return false;
            }
            if (this.updatedAt != chatDto.updatedAt) {
                return false;
            }
            return Intrinsics.areEqual(this.activeModels, chatDto.activeModels);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_aiplayground_models(ChatDto self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.id);
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.title != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.title);
            }
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.messages);
            output.encodeLongElement(serialDesc, 3, self.createdAt);
            output.encodeLongElement(serialDesc, 4, self.updatedAt);
            output.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), self.activeModels);
        }

        public /* synthetic */ ChatDto(int seen0, String id, String title, List messages, long createdAt, long updatedAt, List activeModels, SerializationConstructorMarker serializationConstructorMarker) {
            if (61 != (0x3D & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)61, (SerialDescriptor)ChatDto$$serializer.INSTANCE.getDescriptor());
            }
            this.id = id;
            this.title = (seen0 & 2) == 0 ? null : title;
            this.messages = messages;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.activeModels = activeModels;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)ChatMessageDto$$serializer.INSTANCE)), null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)ChatModelLinkDto$$serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatDto$Companion;", "", "<init>", "()V", "fromChat", "Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatDto;", "chat", "Lcom/intellij/aiplayground/models/chat/Chat;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.aiplayground.models"})
        @SourceDebugExtension(value={"SMAP\nChatPersistenceSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPersistenceSerializer.kt\ncom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatDto$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n1563#2:255\n1634#2,3:256\n1563#2:259\n1634#2,3:260\n*S KotlinDebug\n*F\n+ 1 ChatPersistenceSerializer.kt\ncom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatDto$Companion\n*L\n113#1:255\n113#1:256,3\n116#1:259\n116#1:260,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ChatDto fromChat(@NotNull Chat chat2) {
                Collection<ChatModelLinkDto> collection;
                ChatModelLink it;
                Collection<ChatMessageDto> collection2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)chat2, (String)"chat");
                Iterable iterable = chat2.getMessages();
                String string = chat2.getTitle();
                String string2 = chat2.getId-RNhTleA();
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ChatMessage chatMessage = (ChatMessage)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(ChatMessageDto.Companion.fromChatMessage((ChatMessage)((Object)it)));
                }
                collection2 = (List)destination$iv$iv;
                $this$map$iv = chat2.getActiveModels();
                long l = chat2.getUpdatedAt();
                long l2 = chat2.getCreatedAt();
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void link;
                    it = (ChatModelLink)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new ChatModelLinkDto(link.getId-Zfeyzjw(), link.getProviderId-rTbPaiE(), link.getInstanceId-6sz_EWc(), link.getModelId-jY8-qq0()));
                }
                Collection<ChatModelLinkDto> collection3 = collection = (List)destination$iv$iv;
                long l3 = l;
                long l4 = l2;
                Collection<ChatMessageDto> collection4 = collection2;
                String string3 = string;
                String string4 = string2;
                return new ChatDto(string4, string3, (List<ChatMessageDto>)collection4, l4, l3, (List<ChatModelLinkDto>)collection3);
            }

            @NotNull
            public final KSerializer<ChatDto> serializer() {
                return (KSerializer)ChatDto$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 <2\u00020\u0001:\u0002<=BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fBi\b\u0010\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u000e\u0010\u0014J\u001c\u0010 \u001a\u0004\u0018\u00010!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010*\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010+\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\t\u0010,\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\rH\u00c6\u0003Jf\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\u0011H\u00d6\u0001J\t\u00103\u001a\u00020\u0003H\u00d6\u0001J%\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0001\u00a2\u0006\u0002\b;R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0007\u0010\u001aR\u0015\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\t\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006>"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatMessageDto;", "", "type", "", "id", "content", "modelId", "isStreaming", "", "isError", "timestamp", "", "tokenUsage", "Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$TokenUsageDto;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;JLcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$TokenUsageDto;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;JLcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$TokenUsageDto;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getType", "()Ljava/lang/String;", "getId", "getContent", "getModelId", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getTimestamp", "()J", "getTokenUsage", "()Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$TokenUsageDto;", "toChatMessage", "Lcom/intellij/aiplayground/models/chat/ChatMessage;", "models", "", "Lcom/intellij/aiplayground/models/chat/ChatModelLinkId;", "Lcom/intellij/aiplayground/models/chat/ChatModelLink;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;JLcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$TokenUsageDto;)Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatMessageDto;", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_aiplayground_models", "Companion", "$serializer", "intellij.aiplayground.models"})
    @SourceDebugExtension(value={"SMAP\nChatPersistenceSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPersistenceSerializer.kt\ncom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatMessageDto\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
    private static final class ChatMessageDto {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String type;
        @NotNull
        private final String id;
        @NotNull
        private final String content;
        @Nullable
        private final String modelId;
        @Nullable
        private final Boolean isStreaming;
        @Nullable
        private final Boolean isError;
        private final long timestamp;
        @Nullable
        private final TokenUsageDto tokenUsage;

        public ChatMessageDto(@NotNull String type, @NotNull String id, @NotNull String content, @Nullable String modelId, @Nullable Boolean isStreaming, @Nullable Boolean isError, long timestamp, @Nullable TokenUsageDto tokenUsage) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.type = type;
            this.id = id;
            this.content = content;
            this.modelId = modelId;
            this.isStreaming = isStreaming;
            this.isError = isError;
            this.timestamp = timestamp;
            this.tokenUsage = tokenUsage;
        }

        public /* synthetic */ ChatMessageDto(String string, String string2, String string3, String string4, Boolean bl, Boolean bl2, long l, TokenUsageDto tokenUsageDto, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                bl = null;
            }
            if ((n & 0x20) != 0) {
                bl2 = null;
            }
            if ((n & 0x80) != 0) {
                tokenUsageDto = null;
            }
            this(string, string2, string3, string4, bl, bl2, l, tokenUsageDto);
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @Nullable
        public final String getModelId() {
            return this.modelId;
        }

        @Nullable
        public final Boolean isStreaming() {
            return this.isStreaming;
        }

        @Nullable
        public final Boolean isError() {
            return this.isError;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public final TokenUsageDto getTokenUsage() {
            return this.tokenUsage;
        }

        /*
         * WARNING - bad return control flow
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final ChatMessage toChatMessage(@NotNull Map<ChatModelLinkId, ChatModelLink> models) {
            ChatMessage chatMessage;
            block8: {
                String string;
                Intrinsics.checkNotNullParameter(models, (String)"models");
                String string2 = this.type;
                switch (string2.hashCode()) {
                    case -887328209: {
                        if (!string2.equals("system")) {
                            return null;
                        }
                        break block8;
                    }
                    case 1429828318: {
                        if (string2.equals("assistant")) break;
                        return null;
                    }
                    case 3599307: {
                        if (!string2.equals("user")) return null;
                        chatMessage = new UserMessage(ChatMessageId.constructor-impl(this.id), this.content, this.timestamp, null);
                        return chatMessage;
                    }
                }
                String string3 = ChatMessageId.constructor-impl(this.id);
                String string4 = this.content;
                Map<ChatModelLinkId, ChatModelLink> map2 = models;
                String string5 = this.modelId;
                if (string5 != null) {
                    String it = string5;
                    boolean bl = false;
                    string = ChatModelLinkId.constructor-impl(it);
                } else {
                    string = null;
                }
                ChatModelLink chatModelLink = map2.get(string != null ? ChatModelLinkId.box-impl(string) : null);
                Intrinsics.checkNotNull((Object)chatModelLink);
                ChatModelLink chatModelLink2 = chatModelLink;
                Boolean bl = this.isStreaming;
                boolean bl2 = bl != null ? bl : false;
                Boolean bl3 = this.isError;
                boolean bl4 = bl3 != null ? bl3 : false;
                long l = this.timestamp;
                TokenUsageDto tokenUsageDto = this.tokenUsage;
                TokenUsage tokenUsage = tokenUsageDto != null ? tokenUsageDto.toTokenUsage() : null;
                chatMessage = new AssistantMessage(string3, string4, tokenUsage, bl2, bl4, chatModelLink2, l, null);
                return chatMessage;
            }
            chatMessage = new SystemMessage(ChatMessageId.constructor-impl(this.id), this.content, this.timestamp, null);
            return chatMessage;
            return null;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final String component3() {
            return this.content;
        }

        @Nullable
        public final String component4() {
            return this.modelId;
        }

        @Nullable
        public final Boolean component5() {
            return this.isStreaming;
        }

        @Nullable
        public final Boolean component6() {
            return this.isError;
        }

        public final long component7() {
            return this.timestamp;
        }

        @Nullable
        public final TokenUsageDto component8() {
            return this.tokenUsage;
        }

        @NotNull
        public final ChatMessageDto copy(@NotNull String type, @NotNull String id, @NotNull String content, @Nullable String modelId, @Nullable Boolean isStreaming, @Nullable Boolean isError, long timestamp, @Nullable TokenUsageDto tokenUsage) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new ChatMessageDto(type, id, content, modelId, isStreaming, isError, timestamp, tokenUsage);
        }

        public static /* synthetic */ ChatMessageDto copy$default(ChatMessageDto chatMessageDto, String string, String string2, String string3, String string4, Boolean bl, Boolean bl2, long l, TokenUsageDto tokenUsageDto, int n, Object object) {
            if ((n & 1) != 0) {
                string = chatMessageDto.type;
            }
            if ((n & 2) != 0) {
                string2 = chatMessageDto.id;
            }
            if ((n & 4) != 0) {
                string3 = chatMessageDto.content;
            }
            if ((n & 8) != 0) {
                string4 = chatMessageDto.modelId;
            }
            if ((n & 0x10) != 0) {
                bl = chatMessageDto.isStreaming;
            }
            if ((n & 0x20) != 0) {
                bl2 = chatMessageDto.isError;
            }
            if ((n & 0x40) != 0) {
                l = chatMessageDto.timestamp;
            }
            if ((n & 0x80) != 0) {
                tokenUsageDto = chatMessageDto.tokenUsage;
            }
            return chatMessageDto.copy(string, string2, string3, string4, bl, bl2, l, tokenUsageDto);
        }

        @NotNull
        public String toString() {
            return "ChatMessageDto(type=" + this.type + ", id=" + this.id + ", content=" + this.content + ", modelId=" + this.modelId + ", isStreaming=" + this.isStreaming + ", isError=" + this.isError + ", timestamp=" + this.timestamp + ", tokenUsage=" + this.tokenUsage + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.id.hashCode();
            result = result * 31 + this.content.hashCode();
            result = result * 31 + (this.modelId == null ? 0 : this.modelId.hashCode());
            result = result * 31 + (this.isStreaming == null ? 0 : ((Object)this.isStreaming).hashCode());
            result = result * 31 + (this.isError == null ? 0 : ((Object)this.isError).hashCode());
            result = result * 31 + Long.hashCode(this.timestamp);
            result = result * 31 + (this.tokenUsage == null ? 0 : this.tokenUsage.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChatMessageDto)) {
                return false;
            }
            ChatMessageDto chatMessageDto = (ChatMessageDto)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)chatMessageDto.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)chatMessageDto.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)chatMessageDto.content)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.modelId, (Object)chatMessageDto.modelId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isStreaming, (Object)chatMessageDto.isStreaming)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isError, (Object)chatMessageDto.isError)) {
                return false;
            }
            if (this.timestamp != chatMessageDto.timestamp) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tokenUsage, (Object)chatMessageDto.tokenUsage);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_aiplayground_models(ChatMessageDto self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.type);
            output.encodeStringElement(serialDesc, 1, self.id);
            output.encodeStringElement(serialDesc, 2, self.content);
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.modelId != null) {
                output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.modelId);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.isStreaming != null) {
                output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.isStreaming);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.isError != null) {
                output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.isError);
            }
            output.encodeLongElement(serialDesc, 6, self.timestamp);
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.tokenUsage != null) {
                output.encodeNullableSerializableElement(serialDesc, 7, (SerializationStrategy)TokenUsageDto$$serializer.INSTANCE, (Object)self.tokenUsage);
            }
        }

        public /* synthetic */ ChatMessageDto(int seen0, String type, String id, String content, String modelId, Boolean isStreaming, Boolean isError, long timestamp, TokenUsageDto tokenUsage, SerializationConstructorMarker serializationConstructorMarker) {
            if (71 != (0x47 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)71, (SerialDescriptor)ChatMessageDto$$serializer.INSTANCE.getDescriptor());
            }
            this.type = type;
            this.id = id;
            this.content = content;
            this.modelId = (seen0 & 8) == 0 ? null : modelId;
            this.isStreaming = (seen0 & 0x10) == 0 ? null : isStreaming;
            this.isError = (seen0 & 0x20) == 0 ? null : isError;
            this.timestamp = timestamp;
            this.tokenUsage = (seen0 & 0x80) == 0 ? null : tokenUsage;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatMessageDto$Companion;", "", "<init>", "()V", "fromChatMessage", "Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatMessageDto;", "message", "Lcom/intellij/aiplayground/models/chat/ChatMessage;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.aiplayground.models"})
        @SourceDebugExtension(value={"SMAP\nChatPersistenceSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPersistenceSerializer.kt\ncom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatMessageDto$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ChatMessageDto fromChatMessage(@NotNull ChatMessage message) {
                ChatMessageDto chatMessageDto;
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                ChatMessage chatMessage = message;
                if (chatMessage instanceof UserMessage) {
                    chatMessageDto = new ChatMessageDto("user", ((UserMessage)message).getId-Zy0mImg(), ((UserMessage)message).getContent(), null, null, null, ((UserMessage)message).getTimestamp(), null, 56, null);
                } else if (chatMessage instanceof AssistantMessage) {
                    TokenUsageDto tokenUsageDto;
                    String string = "assistant";
                    String string2 = ((AssistantMessage)message).getId-Zy0mImg();
                    String string3 = ((AssistantMessage)message).getContent();
                    String string4 = ((AssistantMessage)message).getModel().getId-Zfeyzjw();
                    Boolean bl = ((AssistantMessage)message).isStreaming();
                    Boolean bl2 = ((AssistantMessage)message).isError();
                    long l = ((AssistantMessage)message).getTimestamp();
                    TokenUsage tokenUsage = ((AssistantMessage)message).getTokenUsage();
                    if (tokenUsage != null) {
                        void it;
                        TokenUsage tokenUsage2 = tokenUsage;
                        long l2 = l;
                        Boolean bl3 = bl2;
                        Boolean bl4 = bl;
                        String string5 = string4;
                        String string6 = string3;
                        String string7 = string2;
                        String string8 = string;
                        boolean bl5 = false;
                        TokenUsageDto tokenUsageDto2 = TokenUsageDto.Companion.fromTokenUsage((TokenUsage)it);
                        string = string8;
                        string2 = string7;
                        string3 = string6;
                        string4 = string5;
                        bl = bl4;
                        bl2 = bl3;
                        l = l2;
                        tokenUsageDto = tokenUsageDto2;
                    } else {
                        tokenUsageDto = null;
                    }
                    TokenUsageDto tokenUsageDto3 = tokenUsageDto;
                    long l3 = l;
                    Boolean bl6 = bl2;
                    Boolean bl7 = bl;
                    String string9 = string4;
                    String string10 = string3;
                    String string11 = string2;
                    String string12 = string;
                    chatMessageDto = new ChatMessageDto(string12, string11, string10, string9, bl7, bl6, l3, tokenUsageDto3);
                } else if (chatMessage instanceof SystemMessage) {
                    chatMessageDto = new ChatMessageDto("system", ((SystemMessage)message).getId-Zy0mImg(), ((SystemMessage)message).getContent(), null, null, null, ((SystemMessage)message).getTimestamp(), null, 56, null);
                } else {
                    throw new IllegalArgumentException("Unknown message type: " + message.getClass());
                }
                return chatMessageDto;
            }

            @NotNull
            public final KSerializer<ChatMessageDto> serializer() {
                return (KSerializer)ChatMessageDto$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 &2\u00020\u0001:\u0002%&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bBC\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0002\b$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatModelLinkDto;", "", "id", "", "providerId", "instanceId", "modelId", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()Ljava/lang/String;", "getProviderId", "getInstanceId", "getModelId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_aiplayground_models", "$serializer", "Companion", "intellij.aiplayground.models"})
    private static final class ChatModelLinkDto {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String providerId;
        @NotNull
        private final String instanceId;
        @NotNull
        private final String modelId;

        public ChatModelLinkDto(@NotNull String id, @NotNull String providerId, @NotNull String instanceId, @NotNull String modelId) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
            Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
            this.id = id;
            this.providerId = providerId;
            this.instanceId = instanceId;
            this.modelId = modelId;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getProviderId() {
            return this.providerId;
        }

        @NotNull
        public final String getInstanceId() {
            return this.instanceId;
        }

        @NotNull
        public final String getModelId() {
            return this.modelId;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.providerId;
        }

        @NotNull
        public final String component3() {
            return this.instanceId;
        }

        @NotNull
        public final String component4() {
            return this.modelId;
        }

        @NotNull
        public final ChatModelLinkDto copy(@NotNull String id, @NotNull String providerId, @NotNull String instanceId, @NotNull String modelId) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
            Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
            return new ChatModelLinkDto(id, providerId, instanceId, modelId);
        }

        public static /* synthetic */ ChatModelLinkDto copy$default(ChatModelLinkDto chatModelLinkDto, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = chatModelLinkDto.id;
            }
            if ((n & 2) != 0) {
                string2 = chatModelLinkDto.providerId;
            }
            if ((n & 4) != 0) {
                string3 = chatModelLinkDto.instanceId;
            }
            if ((n & 8) != 0) {
                string4 = chatModelLinkDto.modelId;
            }
            return chatModelLinkDto.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ChatModelLinkDto(id=" + this.id + ", providerId=" + this.providerId + ", instanceId=" + this.instanceId + ", modelId=" + this.modelId + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.providerId.hashCode();
            result = result * 31 + this.instanceId.hashCode();
            result = result * 31 + this.modelId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChatModelLinkDto)) {
                return false;
            }
            ChatModelLinkDto chatModelLinkDto = (ChatModelLinkDto)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)chatModelLinkDto.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.providerId, (Object)chatModelLinkDto.providerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.instanceId, (Object)chatModelLinkDto.instanceId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.modelId, (Object)chatModelLinkDto.modelId);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_aiplayground_models(ChatModelLinkDto self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.id);
            output.encodeStringElement(serialDesc, 1, self.providerId);
            output.encodeStringElement(serialDesc, 2, self.instanceId);
            output.encodeStringElement(serialDesc, 3, self.modelId);
        }

        public /* synthetic */ ChatModelLinkDto(int seen0, String id, String providerId, String instanceId, String modelId, SerializationConstructorMarker serializationConstructorMarker) {
            if (15 != (0xF & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)ChatModelLinkDto$$serializer.INSTANCE.getDescriptor());
            }
            this.id = id;
            this.providerId = providerId;
            this.instanceId = instanceId;
            this.modelId = modelId;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatModelLinkDto$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$ChatModelLinkDto;", "intellij.aiplayground.models"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ChatModelLinkDto> serializer() {
                return (KSerializer)ChatModelLinkDto$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 $2\u00020\u0001:\u0002$%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B3\b\u0010\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006&"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$TokenUsageDto;", "", "inputTokenCount", "", "outputTokenCount", "totalTokenCount", "<init>", "(III)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getInputTokenCount", "()I", "getOutputTokenCount", "getTotalTokenCount", "toTokenUsage", "Lcom/intellij/aiplayground/models/chat/TokenUsage;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_aiplayground_models", "Companion", "$serializer", "intellij.aiplayground.models"})
    private static final class TokenUsageDto {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int inputTokenCount;
        private final int outputTokenCount;
        private final int totalTokenCount;

        public TokenUsageDto(int inputTokenCount, int outputTokenCount, int totalTokenCount) {
            this.inputTokenCount = inputTokenCount;
            this.outputTokenCount = outputTokenCount;
            this.totalTokenCount = totalTokenCount;
        }

        public final int getInputTokenCount() {
            return this.inputTokenCount;
        }

        public final int getOutputTokenCount() {
            return this.outputTokenCount;
        }

        public final int getTotalTokenCount() {
            return this.totalTokenCount;
        }

        @NotNull
        public final TokenUsage toTokenUsage() {
            return new TokenUsage(this.inputTokenCount, this.outputTokenCount, this.totalTokenCount);
        }

        public final int component1() {
            return this.inputTokenCount;
        }

        public final int component2() {
            return this.outputTokenCount;
        }

        public final int component3() {
            return this.totalTokenCount;
        }

        @NotNull
        public final TokenUsageDto copy(int inputTokenCount, int outputTokenCount, int totalTokenCount) {
            return new TokenUsageDto(inputTokenCount, outputTokenCount, totalTokenCount);
        }

        public static /* synthetic */ TokenUsageDto copy$default(TokenUsageDto tokenUsageDto, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = tokenUsageDto.inputTokenCount;
            }
            if ((n4 & 2) != 0) {
                n2 = tokenUsageDto.outputTokenCount;
            }
            if ((n4 & 4) != 0) {
                n3 = tokenUsageDto.totalTokenCount;
            }
            return tokenUsageDto.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "TokenUsageDto(inputTokenCount=" + this.inputTokenCount + ", outputTokenCount=" + this.outputTokenCount + ", totalTokenCount=" + this.totalTokenCount + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.inputTokenCount);
            result = result * 31 + Integer.hashCode(this.outputTokenCount);
            result = result * 31 + Integer.hashCode(this.totalTokenCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenUsageDto)) {
                return false;
            }
            TokenUsageDto tokenUsageDto = (TokenUsageDto)other;
            if (this.inputTokenCount != tokenUsageDto.inputTokenCount) {
                return false;
            }
            if (this.outputTokenCount != tokenUsageDto.outputTokenCount) {
                return false;
            }
            return this.totalTokenCount == tokenUsageDto.totalTokenCount;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_aiplayground_models(TokenUsageDto self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeIntElement(serialDesc, 0, self.inputTokenCount);
            output.encodeIntElement(serialDesc, 1, self.outputTokenCount);
            output.encodeIntElement(serialDesc, 2, self.totalTokenCount);
        }

        public /* synthetic */ TokenUsageDto(int seen0, int inputTokenCount, int outputTokenCount, int totalTokenCount, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)TokenUsageDto$$serializer.INSTANCE.getDescriptor());
            }
            this.inputTokenCount = inputTokenCount;
            this.outputTokenCount = outputTokenCount;
            this.totalTokenCount = totalTokenCount;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$TokenUsageDto$Companion;", "", "<init>", "()V", "fromTokenUsage", "Lcom/intellij/aiplayground/models/chat/ChatPersistenceSerializer$TokenUsageDto;", "tokenUsage", "Lcom/intellij/aiplayground/models/chat/TokenUsage;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.aiplayground.models"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TokenUsageDto fromTokenUsage(@NotNull TokenUsage tokenUsage) {
                Intrinsics.checkNotNullParameter((Object)tokenUsage, (String)"tokenUsage");
                return new TokenUsageDto(tokenUsage.getInputTokenCount(), tokenUsage.getOutputTokenCount(), tokenUsage.getTotalTokenCount());
            }

            @NotNull
            public final KSerializer<TokenUsageDto> serializer() {
                return (KSerializer)TokenUsageDto$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

