/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.resolver;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.emmet.CssEmmetUtil;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssEmmetFuzzySearcher {
    private static final double MIN_SCORE = 0.3;
    private static final double FUZZINESS = 0.1;

    @Nullable
    public TemplateImpl findTemplateWithFuzzySearch(@NotNull String abbreviation, @NotNull CustomTemplateCallback callback) {
        if (abbreviation == null) {
            CssEmmetFuzzySearcher.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            CssEmmetFuzzySearcher.$$$reportNull$$$0(1);
        }
        abbreviation = CssEmmetFuzzySearcher.normalizeName(abbreviation);
        TemplateImpl result = null;
        double currentScore = 0.3;
        List templates = TemplateManagerImpl.listApplicableTemplates((TemplateActionContext)TemplateActionContext.expanding((PsiFile)callback.getFile(), (int)callback.getOffset()));
        for (TemplateImpl template : templates) {
            String singlePropertyName = CssEmmetUtil.getSinglePropertyName(template);
            if (singlePropertyName == null) continue;
            double score = CssEmmetFuzzySearcher.score(CssEmmetFuzzySearcher.normalizeName(template.getKey()), abbreviation);
            if (singlePropertyName.startsWith(abbreviation)) {
                score += CssEmmetFuzzySearcher.score(singlePropertyName, abbreviation);
            }
            if (!(score >= currentScore)) continue;
            currentScore = score;
            result = template;
        }
        return result;
    }

    @NotNull
    private static String normalizeName(@NotNull String name) {
        if (name == null) {
            CssEmmetFuzzySearcher.$$$reportNull$$$0(2);
        }
        if (StringUtil.endsWithChar((CharSequence)name, (char)':')) {
            name = name.substring(0, name.length() - 1);
        }
        String string = name.replace(':', '-');
        if (string == null) {
            CssEmmetFuzzySearcher.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static double score(@NotNull String string, @NotNull String abbreviation) {
        if (string == null) {
            CssEmmetFuzzySearcher.$$$reportNull$$$0(4);
        }
        if (abbreviation == null) {
            CssEmmetFuzzySearcher.$$$reportNull$$$0(5);
        }
        if (abbreviation.isEmpty() || string.isEmpty()) {
            return 0.0;
        }
        if (string.equalsIgnoreCase(abbreviation)) {
            return 1.0;
        }
        double totalCharacterScore = 0.0;
        double fuzzies = 1.0;
        boolean startOfStringBonus = false;
        double stringInitialLength = string.length();
        for (int i = 0; i < abbreviation.length(); ++i) {
            int indexInString;
            int upperCaseIndex;
            char ch = abbreviation.charAt(i);
            int lowerCaseIndex = string.indexOf(Character.toLowerCase(ch));
            int minIndex = Math.min(lowerCaseIndex, upperCaseIndex = string.indexOf(Character.toUpperCase(ch)));
            int n = indexInString = minIndex > -1 ? minIndex : Math.max(lowerCaseIndex, upperCaseIndex);
            if (indexInString == -1) {
                fuzzies += 0.9;
                continue;
            }
            double characterScore = 0.1;
            if (string.charAt(indexInString) == ch) {
                characterScore += 0.1;
            }
            if (indexInString == 0) {
                characterScore += 0.6;
                if (i == 0) {
                    startOfStringBonus = true;
                }
            } else if (string.charAt(indexInString - 1) == ' ') {
                characterScore += 0.8;
            }
            string = string.substring(indexInString + 1);
            totalCharacterScore += characterScore;
        }
        double abbreviationScore = totalCharacterScore / (double)abbreviation.length();
        double result = (abbreviationScore * ((double)abbreviation.length() / stringInitialLength) + abbreviationScore) / 2.0;
        result /= fuzzies;
        if (startOfStringBonus && result + 0.15 < 1.0) {
            result += 0.15;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/resolver/CssEmmetFuzzySearcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/resolver/CssEmmetFuzzySearcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateWithFuzzySearch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizeName";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "score";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

