/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.reference.CssDownloadedLibraryReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.css.resolve.impl.CssResolverImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssResolveManagerImpl
extends CssResolveManager {
    public CssResolveManagerImpl() {
        PluginVerifier.verifyUltimatePlugin();
    }

    @Override
    public CssResolver getNewResolver() {
        return new CssResolverImpl();
    }

    @Override
    public CssDeclaration[] resolve(XmlTag tag, XmlFile[] xhtmlFiles, CssStylesheet defaultStylesheet) {
        CssResolverImpl resolver = new CssResolverImpl();
        if (defaultStylesheet != null) {
            resolver.setDefaultStylesheet(defaultStylesheet);
        }
        return resolver.resolve(tag, (PsiFile[])xhtmlFiles, null);
    }

    @Override
    public PsiFile @NotNull [] resolveFiles(@Nullable PsiElement uriElement) {
        if (uriElement instanceof CssUri) {
            uriElement = ((CssUri)uriElement).getValueElement();
        }
        if (uriElement == null) {
            if (PsiFile.EMPTY_ARRAY == null) {
                CssResolveManagerImpl.$$$reportNull$$$0(0);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        PsiReference[] references = uriElement.getReferences();
        if (references.length == 0) {
            references = CssResolveManagerImpl.getJspHackReferences(uriElement);
        }
        for (PsiReference reference : references) {
            VirtualFile vFile;
            PsiElement resolve;
            if (reference instanceof FileReference) {
                if (!((FileReference)reference).isLast()) continue;
                for (ResolveResult resolveResult : ((FileReference)reference).multiResolve(false)) {
                    CssResolveManagerImpl.addStylesheetFile(result, resolveResult.getElement());
                }
                continue;
            }
            if (reference instanceof PsiDynaReference) {
                PsiFileReference fileReference = ((PsiDynaReference)reference).getLastFileReference();
                if (fileReference == null) continue;
                for (ResolveResult resolveResult : fileReference.multiResolve(false)) {
                    CssResolveManagerImpl.addStylesheetFile(result, resolveResult.getElement());
                }
                continue;
            }
            if (reference instanceof UrlReference) {
                CssResolveManagerImpl.addStylesheetFile(result, reference.resolve());
                continue;
            }
            if (!(reference instanceof CssDownloadedLibraryReference) || (resolve = reference.resolve()) == null || (vFile = resolve.getContainingFile().getVirtualFile()) == null || !GlobalSearchScope.allScope((Project)resolve.getProject()).contains(vFile)) continue;
            CssResolveManagerImpl.addStylesheetFile(result, resolve);
        }
        PsiFile[] psiFileArray = !result.isEmpty() ? result.toArray(PsiFile.EMPTY_ARRAY) : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(1);
        }
        return psiFileArray;
    }

    private static void addStylesheetFile(@NotNull Collection<PsiFile> result, @Nullable PsiElement element) {
        PsiFile stylesheetFile;
        if (result == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PsiFile)) {
            return;
        }
        if (!(element instanceof StylesheetFile) && (stylesheetFile = ((PsiFile)element).getViewProvider().getPsi((Language)CSSLanguage.INSTANCE)) instanceof StylesheetFile) {
            result.add(stylesheetFile);
            return;
        }
        result.add((PsiFile)element);
    }

    private static PsiReference @NotNull [] getJspHackReferences(@NotNull PsiElement element) {
        XmlAttributeValue valueElement;
        XmlAttribute[] attributes;
        PsiElement elementAt;
        XmlTag tag;
        String value;
        if (element == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(3);
        }
        OuterLanguageElement childOfType = null;
        for (PsiElement sibling = element.getFirstChild(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof OuterLanguageElement)) continue;
            childOfType = (OuterLanguageElement)sibling;
            break;
        }
        if (childOfType != null && (value = ElementManipulators.getValueText((PsiElement)element)).equals(childOfType.getText()) && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = element.getContainingFile().findElementAt(childOfType.getTextOffset())), XmlTag.class)) != null && (attributes = tag.getAttributes()).length == 1 && !"http://java.sun.com/JSP/Page".equals(tag.getNamespace()) && CssResolveManagerImpl.isUrlDecoratingCustomTag(tag) && tag.getTextRange().equals((Object)childOfType.getTextRange()) && (valueElement = attributes[0].getValueElement()) != null) {
            PsiReference[] psiReferenceArray = valueElement.getReferences();
            if (psiReferenceArray == null) {
                CssResolveManagerImpl.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isUrlDecoratingCustomTag(@NotNull XmlTag tag) {
        String localName;
        if (tag == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(6);
        }
        if ("url".equals(localName = tag.getLocalName())) {
            return Arrays.binarySearch(XmlUtil.JSTL_CORE_URIS, tag.getNamespace()) >= 0;
        }
        return "rewrite".equals(localName) && "http://struts.apache.org/tags-html".equals(tag.getNamespace());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFiles";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJspHackReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStylesheetFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJspHackReferences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUrlDecoratingCustomTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6 -> new IllegalArgumentException(string);
        };
    }
}

