/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker.compose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposePort;
import com.intellij.docker.agent.compose.beans.RestartPolicy;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.compose.cli.DockerComposeCliCmd;
import com.intellij.docker.compose.cli.DockerComposeCliSubCmd;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeRunCmd;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.compose.process.DockerComposeProcessUtil;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.python.docker.PyDockerBundle;
import com.intellij.python.docker.PyDockerCommandLinePatcher;
import com.intellij.python.docker.PyDockerProcessUtil;
import com.intellij.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.intellij.python.docker.remote.PyDockerComposeProcessHandler;
import com.intellij.python.remoteInterpreter.PyRemoteInterpreterCommandLineUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkPropertiesPaths;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.remote.PyCommandLineStateUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDockerComposeProcessUtil {
    private PyDockerComposeProcessUtil() {
    }

    @NotNull
    public static ProcessOutput executeRemoteProcess(@Nullable Project project, String @NotNull [] command, @Nullable String workingDir, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper) throws ExecutionException, InterruptedException {
        if (sdkAdditionalData == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(0);
        }
        if (pathMapper == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(1);
        }
        if (command == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(2);
        }
        PyDockerComposeProcessConnectionData data = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(sdkAdditionalData);
        Pair<String[], String> commandWithWorkingDir = PyRemoteInterpreterCommandLineUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, command, workingDir, data.getInterpreterPath());
        HashMap env = new HashMap();
        PythonEnvUtil.setPythonUnbuffered(env);
        try {
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)project);
            SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withRemove(true).withServiceName(data.getComposeServiceName())).withCommand((String[])commandWithWorkingDir.getFirst())).withWorkingDir((String)commandWithWorkingDir.getSecond())).withEnvironment(env)).withSharedVolume(helpersSharedVolume)).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
            KillableColoredProcessHandler processHandler = runServiceCmd.execute();
            String[] dockerCliCommandLine = ParametersList.parse((String)processHandler.getCommandLine());
            return PyDockerComposeProcessUtil.assertSuccessfulExecution(dockerCliCommandLine, new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess());
        }
        catch (ProcessNotCreatedException e) {
            DockerComposeCliUtil.notifyDockerComposeExecutionFailed((Project)project, (ProcessNotCreatedException)e);
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            throw (UndeclaredThrowableException)DockerUtil.propagateRuntimeExceptionCause((RuntimeException)e, InterruptedException.class);
        }
    }

    @NotNull
    private static ProcessOutput assertSuccessfulExecution(String @NotNull [] command, @NotNull ProcessOutput processOutput) throws ExecutionException {
        if (processOutput == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(3);
        }
        if (command == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(4);
        }
        if (processOutput.isExitCodeSet() && processOutput.getExitCode() == 0) {
            ProcessOutput processOutput2 = processOutput;
            if (processOutput2 == null) {
                PyDockerComposeProcessUtil.$$$reportNull$$$0(5);
            }
            return processOutput2;
        }
        List<String> commandList = Arrays.asList(command);
        String executable = (String)ContainerUtil.getFirstItem(commandList, (Object)"");
        List args = commandList.isEmpty() ? Collections.emptyList() : ContainerUtil.subList(commandList, (int)1);
        throw new PyExecutionException(PyDockerBundle.message("docker.compose.finished.with.exit.code", processOutput.getExitCode()), executable, args, processOutput);
    }

    @NotNull
    public static ProcessHandler startRemoteProcess(@Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper) throws RemoteSdkException {
        if (commandLine == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(6);
        }
        if (sdkAdditionalData == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(7);
        }
        if (pathMapper == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(8);
        }
        return PyDockerComposeProcessUtil.startRemoteProcess(project, commandLine, sdkAdditionalData, pathMapper, null);
    }

    @NotNull
    public static ProcessHandler startRemoteProcess(@Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper, @Nullable List<DockerComposePort> debuggerPorts) throws RemoteSdkException {
        if (commandLine == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(9);
        }
        if (sdkAdditionalData == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(10);
        }
        if (pathMapper == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(11);
        }
        DockerComposeCliCmd dockerComposeCliCmd = commandLine.getUserData(PyRemoteProcessStarter.RUN_AS_AUXILIARY_PROCESS) == Boolean.TRUE ? new DockerComposeCliCmd(new ArrayList(), (DockerComposeCliSubCmd)new DockerComposeRunCmd()) : DockerComposeProcessUtil.getComposeCommandOptions((GeneralCommandLine)commandLine);
        PathMappingSettings additionalMappings = (PathMappingSettings)commandLine.getUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS);
        PyDockerComposeProcessConnectionData data = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(sdkAdditionalData);
        ParamsGroup exeGroup = commandLine.getParametersList().getParamsGroup("Exe Options");
        if (exeGroup != null) {
            PythonRemoteInterpreterManager.addUnbuffered((ParamsGroup)exeGroup);
        }
        PyRemoteSocketToLocalHostProvider dockerSocketProvider = data.getPyRemoteSocketToLocalHostProvider();
        PyDockerCommandLinePatcher.patchCommandLineForDocker(commandLine, (RemoteSdkPropertiesPaths)data, dockerSocketProvider, pathMapper);
        PyCommandLineStateUtil.remap((String)data.getInterpreterPath(), (GeneralCommandLine)commandLine, (PathMapper)pathMapper);
        if (commandLine.getWorkDirectory() != null) {
            commandLine.setWorkDirectory(pathMapper.convertToRemote(commandLine.getWorkDirectory().getPath()));
        }
        String[] command = ArrayUtilRt.toStringArray((Collection)commandLine.getCommandLineList(null));
        String workingDir = commandLine.getWorkDirectory() != null ? commandLine.getWorkDirectory().getPath() : null;
        VolumesBuilder volumesBinds = PyDockerComposeProcessUtil.setupVolumeBinds(project, additionalMappings);
        Pair<String[], String> commandWithWorkingDir = PyRemoteInterpreterCommandLineUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, command, workingDir, data.getInterpreterPath());
        HashMap env = new HashMap(commandLine.getEnvironment());
        PythonEnvUtil.setPythonUnbuffered(env);
        try {
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)project);
            SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            AbstractServiceCmd serviceCmd = DockerComposeProcessUtil.createComposeServiceCmd((DockerComposeServiceClient)serviceClient, (DockerComposeCliCmd)dockerComposeCliCmd, debuggerPorts).withConfigurationPath(ContainerUtil.concat(data.getComposeFilePaths(), (List)dockerComposeCliCmd.getFiles())).withEnvs(data.getEnvs()).withServiceName(data.getComposeServiceName()).withEnvironment(env).withCommand((String[])commandWithWorkingDir.getFirst()).withWorkingDir((String)commandWithWorkingDir.getSecond()).withSharedVolume(helpersSharedVolume).withVolumes(PyDockerComposeProcessUtil.removeRepeatedContainerPaths(volumesBinds.build()));
            return new PyDockerComposeProcessHandler(serviceCmd.buildCommandLine(dockerRuntime), pathMapper, dockerSocketProvider);
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
    }

    @NotNull
    public static VolumesBuilder setupVolumeBinds(@Nullable Project project, @Nullable PathMappingSettings additionalMappings) {
        DockerContainerSettings containerSettings = project != null ? DockerContainerSettings.defaultSettings((Project)project) : null;
        VolumesBuilder volumesBuilder = DockerProcessUtil.setupVolumesBinds((PathMappingSettings)additionalMappings, (DockerContainerSettings)containerSettings);
        if (volumesBuilder == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(12);
        }
        return volumesBuilder;
    }

    public static DockerVolumeBinding @NotNull [] removeRepeatedContainerPaths(DockerVolumeBinding @NotNull [] bindings) {
        if (bindings == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(13);
        }
        ArrayList<DockerVolumeBinding> filtered = new ArrayList<DockerVolumeBinding>();
        HashSet<String> containerPaths = new HashSet<String>();
        for (DockerVolumeBinding binding : bindings) {
            if (containerPaths.contains(binding.getContainerPath())) continue;
            filtered.add(binding);
            containerPaths.add(binding.getContainerPath());
        }
        DockerVolumeBinding[] dockerVolumeBindingArray = filtered.toArray(new DockerVolumeBinding[0]);
        if (dockerVolumeBindingArray == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(14);
        }
        return dockerVolumeBindingArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/docker/compose/PyDockerComposeProcessUtil";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/docker/compose/PyDockerComposeProcessUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "assertSuccessfulExecution";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setupVolumeBinds";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRepeatedContainerPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeRemoteProcess";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertSuccessfulExecution";
                break;
            }
            case 5: 
            case 12: 
            case 14: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeRepeatedContainerPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 14 -> new IllegalStateException(string);
        };
    }
}

