/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.parser;

import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.python.pro.cython.parser.CythonDeclParsing;
import com.intellij.python.pro.cython.parser.CythonParsingContext;
import com.intellij.python.pro.cython.parser.CythonParsingScope;
import com.intellij.python.pro.cython.parser.CythonTokenTypes;
import com.intellij.python.pro.cython.psi.elementTypes.CythonElementTypes;
import com.intellij.python.pro.cython.psi.elementTypes.CythonStubElementTypes;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.ParsingScope;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CythonStatementParsing
extends StatementParsing {
    @NonNls
    protected static final String TOK_CIMPORT = "cimport";
    @NonNls
    protected static final String TOK_STRUCT = "struct";
    @NonNls
    protected static final String TOK_NEWLINE = "newline";
    @NonNls
    protected static final String TOK_CONST = "const";

    protected CythonStatementParsing(CythonParsingContext context) {
        super((ParsingContext)context);
    }

    public CythonParsingContext getParsingContext() {
        return (CythonParsingContext)this.myContext;
    }

    protected IElementType getReferenceType() {
        return CythonElementTypes.REFERENCE_EXPRESSION;
    }

    public void parseStatement() {
        CythonParsingContext context = this.getParsingContext();
        CythonParsingScope scope = context.getScope();
        boolean isCdef = scope.isCdef();
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker marker = null;
        if (this.atToken((IElementType)PyTokenTypes.PASS_KEYWORD) && isCdef) {
            this.parseKeywordStatement(builder, (IElementType)PyElementTypes.PASS_STATEMENT);
            return;
        }
        if (this.atToken((IElementType)CythonTokenTypes.CTYPEDEF_KEYWORD)) {
            this.parseTypedefStatement();
            return;
        }
        if (this.atToken((IElementType)CythonTokenTypes.UPPPER_DEF_KEYWORD)) {
            this.parseMacroDefStatement();
            return;
        }
        if (this.atToken((IElementType)CythonTokenTypes.UPPPER_IF_KEYWORD)) {
            this.parseIfStatement(CythonTokenTypes.UPPPER_IF_KEYWORD, CythonTokenTypes.UPPER_ELIF_KEYWORD, CythonTokenTypes.UPPER_ELSE_KEYWORD, CythonElementTypes.MACRO_IF_STATEMENT);
            return;
        }
        if (this.atToken((IElementType)CythonTokenTypes.CIMPORT_KEYWORD)) {
            this.parseImportStatement((IElementType)CythonElementTypes.CIMPORT_STATEMENT, (IElementType)CythonElementTypes.CIMPORT_ELEMENT);
            return;
        }
        if (this.atToken((IElementType)CythonTokenTypes.CDEF_KEYWORD) || this.atToken((IElementType)CythonTokenTypes.CPDEF_KEYWORD)) {
            isCdef = true;
            marker = builder.mark();
            this.nextToken();
        }
        if (isCdef) {
            if (marker == null) {
                marker = builder.mark();
            }
            this.parseCdefStatement(marker);
        } else if (this.atToken((IElementType)CythonTokenTypes.INCLUDE_KEYWORD)) {
            this.parseIncludeStatement();
        } else if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, "property")) {
            this.parsePropertyDeclaration();
        } else {
            super.parseStatement();
        }
    }

    private void parsePropertyDeclaration() {
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            CythonStatementParsing.buildTokenElement((IElementType)CythonElementTypes.NAME_DECL, (SyntaxTreeBuilder)this.myBuilder);
        } else {
            this.myBuilder.error(PyParsingBundle.message((String)"PARSE.expected.identifier", (Object[])new Object[0]));
        }
        this.checkMatches((IElementType)PyTokenTypes.COLON, PyParsingBundle.message((String)"PARSE.expected.colon", (Object[])new Object[0]));
        this.parseSuite(marker, (IElementType)CythonElementTypes.PROPERTY_DECLARATION);
    }

    private void parseIncludeStatement() {
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        if (!this.getExpressionParser().parseStringLiteralExpression()) {
            this.myBuilder.error(PyParsingBundle.message((String)"PARSE.string.literal.expected", (Object[])new Object[0]));
        }
        this.checkEndOfStatement();
        marker.done((IElementType)CythonElementTypes.INCLUDE_STATEMENT);
    }

    private void parseTypedefStatement() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker marker = builder.mark();
        this.nextToken();
        CythonParsingContext context = this.getParsingContext();
        CythonDeclParsing parser2 = context.getDeclParser();
        parser2.parseVisibilityDecl();
        parser2.parseApiDecl();
        String text = builder.getTokenText();
        if (this.atToken((IElementType)PyTokenTypes.CLASS_KEYWORD)) {
            context.pushScope(context.getScope().withCdef(false));
            this.parseCdefClassDeclaration(builder.mark());
            context.popScope();
        } else if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER) && (TOK_STRUCT.equals(text) || "union".equals(text) || "packed".equals(text))) {
            this.parseStructOrUnionDeclaration(builder.mark());
        } else if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, "enum")) {
            this.parseEnumDeclaration(builder.mark());
        } else if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, "fused")) {
            this.parseFusedDeclaration(builder.mark());
        } else {
            parser2.parseBaseTypeDecl(true);
            parser2.parseNameDecl(false, true, false);
            this.checkEndOfStatement();
        }
        marker.done((IElementType)CythonElementTypes.TYPEDEF_STATEMENT);
    }

    public void parseCdefClassDeclaration(SyntaxTreeBuilder.Marker endMarker) {
        SyntaxTreeBuilder.Marker marker;
        this.nextToken();
        SyntaxTreeBuilder.Marker decl = this.myBuilder.mark();
        this.parseIdentifier();
        while (this.atToken((IElementType)PyTokenTypes.DOT)) {
            this.nextToken();
            decl.drop();
            decl = this.myBuilder.mark();
            this.parseIdentifier();
        }
        CythonParsingContext context = this.getParsingContext();
        context.getDeclParser().parseCanonicalName();
        decl.done((IElementType)CythonElementTypes.NAME_DECL);
        CythonParsingScope scope = context.getScope();
        if (this.atToken((IElementType)PyTokenTypes.LBRACKET) && scope.isCdef()) {
            marker = this.myBuilder.mark();
            this.nextToken();
            this.parseIdentifier();
            while (this.atToken((IElementType)PyTokenTypes.COMMA)) {
                this.nextToken();
                this.parseIdentifier();
            }
            this.checkMatches((IElementType)PyTokenTypes.RBRACKET, PyParsingBundle.message((String)"PARSE.expected.rbracket", (Object[])new Object[0]));
            marker.done(PyElementTypes.PARAMETER_LIST);
        }
        if (this.atToken((IElementType)PyTokenTypes.AS_KEYWORD)) {
            this.nextToken();
            this.parseIdentifier();
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
            this.getExpressionParser().parseArgumentList();
        } else {
            marker = this.myBuilder.mark();
            marker.done((IElementType)PyElementTypes.ARGUMENT_LIST);
        }
        if (this.atToken((IElementType)PyTokenTypes.LBRACKET)) {
            this.parseClassOptions();
        }
        if (this.atToken((IElementType)PyTokenTypes.COLON)) {
            this.nextToken();
            this.parseSuite();
        } else {
            marker = this.myBuilder.mark();
            marker.done(PyElementTypes.STATEMENT_LIST);
            this.checkEndOfStatement();
        }
        endMarker.done(CythonStubElementTypes.CLASS_DECLARATION);
    }

    private void parseClassOptions() {
        this.assertCurrentToken(PyTokenTypes.LBRACKET);
        this.nextToken();
        while (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            String text = this.myBuilder.getTokenText();
            if ("object".equals(text) || "type".equals(text)) {
                this.nextToken();
                this.parseIdentifier();
            }
            if (!this.atToken((IElementType)PyTokenTypes.COMMA)) break;
            this.nextToken();
        }
        this.checkMatches((IElementType)PyTokenTypes.RBRACKET, PyParsingBundle.message((String)"PARSE.expected.symbols", (Object[])new Object[]{"object", "type"}));
    }

    protected StatementParsing.ImportTypes checkFromImportKeyword() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        IElementType tokenType = builder.getTokenType();
        IElementType statementType = PyElementTypes.FROM_IMPORT_STATEMENT;
        IElementType elementType = PyElementTypes.IMPORT_ELEMENT;
        IElementType starElementType = PyElementTypes.STAR_IMPORT_ELEMENT;
        if (tokenType == PyTokenTypes.IMPORT_KEYWORD) {
            this.nextToken();
        } else if (tokenType == CythonTokenTypes.CIMPORT_KEYWORD) {
            this.nextToken();
            statementType = CythonElementTypes.FROM_CIMPORT_STATEMENT;
            elementType = CythonElementTypes.CIMPORT_ELEMENT;
            starElementType = CythonElementTypes.STAR_CIMPORT_ELEMENT;
        } else {
            builder.error(PyParsingBundle.message((String)"PARSE.expected.symbols", (Object[])new Object[]{"import", TOK_CIMPORT}));
        }
        return new StatementParsing.ImportTypes(statementType, elementType, starElementType);
    }

    protected void parseForPart() {
        SyntaxTreeBuilder.Marker forPart = this.myBuilder.mark();
        ExpressionParsing parser2 = this.getExpressionParser();
        PyElementType elementType = PyElementTypes.FOR_PART;
        this.myBuilder.advanceLexer();
        parser2.parseExpression(true, true);
        if (this.atToken((IElementType)PyTokenTypes.IN_KEYWORD)) {
            this.nextToken();
            parser2.parseExpression();
        } else if (this.atToken((IElementType)PyTokenTypes.FROM_KEYWORD)) {
            elementType = CythonElementTypes.FOR_PART;
            this.nextToken();
            parser2.parseExpression();
            if (this.atToken((IElementType)CythonTokenTypes.BY_KEYWORD)) {
                this.nextToken();
                parser2.parseExpression();
            }
        } else {
            this.myBuilder.error(PyParsingBundle.message((String)"PARSE.expected.symbols", (Object[])new Object[]{"in", "from"}));
        }
        this.checkMatches((IElementType)PyTokenTypes.COLON, PyParsingBundle.message((String)"PARSE.expected.colon", (Object[])new Object[0]));
        this.parseSuite();
        forPart.done((IElementType)elementType);
    }

    private void parseMacroDefStatement() {
        this.assertCurrentToken(CythonTokenTypes.UPPPER_DEF_KEYWORD);
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker marker = builder.mark();
        this.nextToken();
        SyntaxTreeBuilder.Marker target = builder.mark();
        this.parseIdentifier();
        target.done(PyElementTypes.TARGET_EXPRESSION);
        this.checkMatches((IElementType)PyTokenTypes.EQ, PyParsingBundle.message((String)"PARSE.eq.expected", (Object[])new Object[0]));
        this.getExpressionParser().parseExpression();
        this.checkEndOfStatement();
        marker.done((IElementType)CythonElementTypes.MACRO_DEF_STATEMENT);
    }

    protected void parseCdefStatement(SyntaxTreeBuilder.Marker endMarker) {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        CythonParsingContext context = this.getParsingContext();
        CythonParsingScope scope = context.getScope();
        CythonDeclParsing parser2 = context.getDeclParser();
        List<String> visibilityDecl = parser2.parseVisibilityDecl();
        parser2.parseApiDecl();
        String text = builder.getTokenText();
        if (visibilityDecl.contains("extern") && this.atToken((IElementType)PyTokenTypes.FROM_KEYWORD)) {
            this.parseCdefExternBlock(endMarker);
        } else if (this.atToken((IElementType)PyTokenTypes.IMPORT_KEYWORD)) {
            this.nextToken();
            this.parseCdefExternBlock(endMarker);
        } else if (this.atToken((IElementType)PyTokenTypes.COLON)) {
            this.nextToken();
            context.pushScope(scope.withCdef(true));
            this.parseSuite(endMarker, (IElementType)CythonElementTypes.CDEF_BLOCK);
            context.popScope();
        } else if (this.atToken((IElementType)PyTokenTypes.CLASS_KEYWORD)) {
            context.pushScope(scope.withCdef(false));
            this.parseCdefClassDeclaration(endMarker);
            context.popScope();
        } else if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER) && (TOK_STRUCT.equals(text) || "union".equals(text) || "packed".equals(text))) {
            this.parseStructOrUnionDeclaration(endMarker);
        } else if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, "enum")) {
            this.parseEnumDeclaration(endMarker);
        } else if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, "fused")) {
            this.parseFusedDeclaration(endMarker);
        } else if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, "cppclass")) {
            context.pushScope(scope.withCdef(true));
            this.parseCdefClassDeclaration(endMarker);
            context.popScope();
        } else {
            this.parseCdefFunctionOrVariable(endMarker);
        }
    }

    private void parseEnumDeclaration(SyntaxTreeBuilder.Marker endMarker) {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        this.nextToken();
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            CythonStatementParsing.buildTokenElement((IElementType)CythonElementTypes.NAME_DECL, (SyntaxTreeBuilder)builder);
            this.getParsingContext().getDeclParser().parseCanonicalName();
        }
        if (this.checkMatches((IElementType)PyTokenTypes.COLON, PyParsingBundle.message((String)"PARSE.expected.colon", (Object[])new Object[0]))) {
            if (this.atToken((IElementType)PyTokenTypes.STATEMENT_BREAK)) {
                this.nextToken();
                SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
                if (this.checkMatches((IElementType)PyTokenTypes.INDENT, PyParsingBundle.message((String)"indent.expected", (Object[])new Object[0]))) {
                    while (!builder.eof() && !this.atToken((IElementType)PyTokenTypes.DEDENT)) {
                        this.parseEnumLine();
                    }
                    marker.done(PyElementTypes.STATEMENT_LIST);
                    if (!builder.eof()) {
                        assert (this.myBuilder.getTokenType() == PyTokenTypes.DEDENT);
                        this.nextToken();
                    }
                } else {
                    marker.drop();
                }
            } else {
                this.parseEnumLine();
            }
        }
        endMarker.done((IElementType)CythonElementTypes.ENUM_DECLARATION);
    }

    private void parseEnumLine() {
        if (this.atToken((IElementType)PyTokenTypes.PASS_KEYWORD)) {
            this.parseKeywordStatement(this.myBuilder, (IElementType)PyElementTypes.PASS_STATEMENT);
        } else {
            SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
            this.parseEnumItem();
            while (this.atToken((IElementType)PyTokenTypes.COMMA)) {
                this.nextToken();
                if (this.myBuilder.eof() || this.atToken((IElementType)PyTokenTypes.STATEMENT_BREAK)) break;
                this.parseEnumItem();
            }
            marker.done((IElementType)CythonElementTypes.VARIABLE_LIST);
            if (!this.myBuilder.eof()) {
                this.checkMatches((IElementType)PyTokenTypes.STATEMENT_BREAK, PyParsingBundle.message((String)"PARSE.newline.expected", (Object[])new Object[0]));
            }
        }
    }

    private void parseEnumItem() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            SyntaxTreeBuilder.Marker variable = builder.mark();
            SyntaxTreeBuilder.Marker nameDecl = builder.mark();
            SyntaxTreeBuilder.Marker assignment = builder.mark();
            SyntaxTreeBuilder.Marker target = builder.mark();
            this.nextToken();
            this.getParsingContext().getDeclParser().parseCanonicalName();
            if (this.atToken((IElementType)PyTokenTypes.EQ)) {
                target.done(PyElementTypes.TARGET_EXPRESSION);
                this.nextToken();
                this.getExpressionParser().parseSingleExpression(false);
                assignment.done((IElementType)PyElementTypes.ASSIGNMENT_STATEMENT);
            } else {
                target.drop();
                assignment.drop();
            }
            nameDecl.done((IElementType)CythonElementTypes.NAME_DECL);
            variable.done((IElementType)CythonElementTypes.VARIABLE);
        } else {
            builder.error(PyParsingBundle.message((String)"PARSE.expected.identifier", (Object[])new Object[0]));
            this.nextToken();
        }
    }

    private void parseFusedDeclaration(SyntaxTreeBuilder.Marker endMarker) {
        this.nextToken();
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            CythonStatementParsing.buildTokenElement((IElementType)CythonElementTypes.NAME_DECL, (SyntaxTreeBuilder)this.myBuilder);
        }
        if (this.checkMatches((IElementType)PyTokenTypes.COLON, PyParsingBundle.message((String)"PARSE.expected.colon", (Object[])new Object[0])) && this.checkMatches((IElementType)PyTokenTypes.STATEMENT_BREAK, PyParsingBundle.message((String)"PARSE.newline.expected", (Object[])new Object[0]))) {
            SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
            if (this.checkMatches((IElementType)PyTokenTypes.INDENT, PyParsingBundle.message((String)"indent.expected", (Object[])new Object[0]))) {
                CythonDeclParsing declParser = this.getParsingContext().getDeclParser();
                while (!this.myBuilder.eof() && !this.atToken((IElementType)PyTokenTypes.DEDENT)) {
                    if (this.atToken((IElementType)PyTokenTypes.PASS_KEYWORD)) {
                        this.parseKeywordStatement(this.myBuilder, (IElementType)PyElementTypes.PASS_STATEMENT);
                        continue;
                    }
                    declParser.parseBaseTypeDecl(false);
                    this.checkEndOfStatement();
                }
                marker.done(PyElementTypes.STATEMENT_LIST);
                if (!this.myBuilder.eof()) {
                    assert (this.myBuilder.getTokenType() == PyTokenTypes.DEDENT);
                    this.nextToken();
                }
            } else {
                marker.drop();
            }
        }
        endMarker.done((IElementType)CythonElementTypes.FUSED_TYPE_DECLARATION);
    }

    private void parseStructOrUnionDeclaration(SyntaxTreeBuilder.Marker endMarker) {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        if ("packed".equals(builder.getTokenText())) {
            this.nextToken();
            if (!this.atToken((IElementType)PyTokenTypes.IDENTIFIER) || !TOK_STRUCT.equals(builder.getTokenText())) {
                builder.error(PyParsingBundle.message((String)"PARSE.0.expected", (Object[])new Object[]{TOK_STRUCT}));
            }
        }
        this.nextToken();
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            CythonStatementParsing.buildTokenElement((IElementType)CythonElementTypes.NAME_DECL, (SyntaxTreeBuilder)builder);
        } else {
            builder.error(PyParsingBundle.message((String)"PARSE.expected.identifier", (Object[])new Object[0]));
        }
        this.getParsingContext().getDeclParser().parseCanonicalName();
        if (this.atToken((IElementType)PyTokenTypes.COLON)) {
            this.nextToken();
            if (this.checkMatches((IElementType)PyTokenTypes.STATEMENT_BREAK, PyParsingBundle.message((String)"PARSE.newline.expected", (Object[])new Object[0]))) {
                SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
                if (this.checkMatches((IElementType)PyTokenTypes.INDENT, PyParsingBundle.message((String)"indent.expected", (Object[])new Object[0]))) {
                    while (!builder.eof() && !this.atToken((IElementType)PyTokenTypes.DEDENT)) {
                        if (this.atToken((IElementType)PyTokenTypes.PASS_KEYWORD)) {
                            this.parseKeywordStatement(builder, (IElementType)PyElementTypes.PASS_STATEMENT);
                            continue;
                        }
                        SyntaxTreeBuilder.Marker field = builder.mark();
                        this.parseCdefFunctionOrVariable(field);
                    }
                    marker.done(PyElementTypes.STATEMENT_LIST);
                    if (!builder.eof()) {
                        assert (this.myBuilder.getTokenType() == PyTokenTypes.DEDENT);
                        this.nextToken();
                    }
                } else {
                    marker.drop();
                }
            }
        } else if (this.atToken((IElementType)PyTokenTypes.STATEMENT_BREAK)) {
            this.nextToken();
        } else {
            builder.error(PyParsingBundle.message((String)"PARSE.expected.symbols.first.quotation", (Object[])new Object[]{":", TOK_NEWLINE}));
        }
        endMarker.done((IElementType)CythonElementTypes.STRUCT_OR_UNION_DECLARATION);
    }

    private void parseCdefExternBlock(SyntaxTreeBuilder.Marker endMarker) {
        this.checkMatches((IElementType)PyTokenTypes.FROM_KEYWORD, PyParsingBundle.message((String)"PARSE.from.expected", (Object[])new Object[0]));
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        if (this.atToken((IElementType)PyTokenTypes.MULT)) {
            this.nextToken();
        } else if (!this.getExpressionParser().parseStringLiteralExpression()) {
            builder.error(PyParsingBundle.message((String)"PARSE.expected.symbols.second.quotation", (Object[])new Object[]{PyParsingBundle.message((String)"PARSE.string.literal", (Object[])new Object[0]), "*"}));
        }
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, "namespace")) {
            this.nextToken();
            if (!this.getExpressionParser().parseStringLiteralExpression()) {
                builder.error(PyParsingBundle.message((String)"PARSE.string.literal.expected", (Object[])new Object[0]));
            }
        }
        this.getParsingContext().getDeclParser().parseNoGilDecl();
        this.checkMatches((IElementType)PyTokenTypes.COLON, PyParsingBundle.message((String)"PARSE.expected.colon", (Object[])new Object[0]));
        this.myContext.pushScope((ParsingScope)this.getParsingContext().getScope().withCdef(true));
        this.parseSuite(endMarker, (IElementType)CythonElementTypes.CDEF_BLOCK);
        this.myContext.popScope();
    }

    private void parseCdefFunctionOrVariable(SyntaxTreeBuilder.Marker endMarker) {
        CythonParsingContext context = this.getParsingContext();
        CythonParsingScope scope = context.getScope();
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        CythonDeclParsing declParser = context.getDeclParser();
        declParser.parseInlineDecl();
        declParser.parseBaseTypeDecl(true);
        SyntaxTreeBuilder.Marker variable = builder.mark();
        CythonDeclParsing.DeclaratorType declaratorType = declParser.parseNameDecl(false, true, true);
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, TOK_CONST) && scope.isCdef()) {
            this.nextToken();
        }
        if (this.atToken((IElementType)PyTokenTypes.COLON)) {
            PyStubElementType<PyFunctionStub, PyFunction> blockType;
            variable.drop();
            if (declaratorType != CythonDeclParsing.DeclaratorType.FUNCTION) {
                blockType = CythonElementTypes.CDEF_BLOCK;
                builder.error(PyParsingBundle.message((String)"PARSE.0.expected", (Object[])new Object[]{"("}));
            } else {
                blockType = CythonStubElementTypes.FUNCTION_DECLARATION;
            }
            this.nextToken();
            context.pushScope(scope.withCdef(false));
            this.parseSuite(endMarker, (IElementType)blockType);
            context.popScope();
        } else if (declaratorType == CythonDeclParsing.DeclaratorType.FUNCTION) {
            variable.drop();
            this.myBuilder.mark().done(PyElementTypes.STATEMENT_LIST);
            this.checkEndOfStatement();
            endMarker.done(CythonStubElementTypes.FUNCTION_DECLARATION);
        } else {
            variable.done((IElementType)CythonElementTypes.VARIABLE);
            while (this.atToken((IElementType)PyTokenTypes.COMMA)) {
                this.nextToken();
                if (PyTokenTypes.END_OF_STATEMENT.contains(builder.getTokenType())) break;
                SyntaxTreeBuilder.Marker next2 = builder.mark();
                declParser.parseNameDecl(false, true, true);
                next2.done((IElementType)CythonElementTypes.VARIABLE);
            }
            this.checkEndOfStatement();
            endMarker.done((IElementType)CythonElementTypes.VARIABLE_LIST);
        }
    }

    private boolean parseIdentifier() {
        return this.checkMatches((IElementType)PyTokenTypes.IDENTIFIER, PyParsingBundle.message((String)"PARSE.expected.identifier", (Object[])new Object[0]));
    }

    protected boolean hasPrintStatement() {
        return true;
    }

    protected void parseSimpleStatement() {
        super.parseSimpleStatement(false);
    }

    @NotNull
    public IElementType filter(@NotNull IElementType source, int start, int end, @NotNull CharSequence text) {
        if (source == null) {
            CythonStatementParsing.$$$reportNull$$$0(0);
        }
        if (text == null) {
            CythonStatementParsing.$$$reportNull$$$0(1);
        }
        IElementType iElementType = super.filter(source, start, end, text, false);
        if (iElementType == null) {
            CythonStatementParsing.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/cython/parser/CythonStatementParsing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/cython/parser/CythonStatementParsing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

