/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.add.wizard.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.python.remoteInterpreter.add.wizard.ui.SyncFoldersDialog;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\b\u0010\u0014\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/remoteInterpreter/add/wizard/ui/SyncFoldersDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "initialMappings", "", "Lcom/jetbrains/plugins/webDeployment/config/DeploymentPathMapping;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/remote/RemoteCredentials;Ljava/util/List;)V", "pathsTable", "Lcom/intellij/ui/table/TableView;", "deployPathMappings", "", "createCenterPanel", "Ljavax/swing/JComponent;", "onAddMapping", "", "getDeploymentPathMappings", "updateUI", "LocalPathColumn", "DeployPathColumn", "intellij.python.remoteInterpreter"})
public final class SyncFoldersDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final RemoteCredentials remoteCredentials;
    @NotNull
    private TableView<DeploymentPathMapping> pathsTable;
    @NotNull
    private final List<DeploymentPathMapping> deployPathMappings;

    public SyncFoldersDialog(@NotNull Project project, @NotNull RemoteCredentials remoteCredentials, @NotNull List<? extends DeploymentPathMapping> initialMappings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        Intrinsics.checkNotNullParameter(initialMappings, (String)"initialMappings");
        super(project);
        this.project = project;
        this.remoteCredentials = remoteCredentials;
        this.pathsTable = new TableView();
        this.setTitle(PythonRemoteInterpreterBundle.message("sync.folder.dialog.title", new Object[0]));
        this.deployPathMappings = new ArrayList(initialMappings);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new LocalPathColumn(), new DeployPathColumn()};
        ColumnInfo[] columns = columnInfoArray;
        ListTableModel tableModel = new ListTableModel(columns, this.deployPathMappings);
        this.pathsTable.setModelAndUpdateColumns(tableModel);
        this.pathsTable.setRowHeight(Math.max(UIUtil.getBalloonWarningIcon().getIconHeight() + 2, new JTextField().getPreferredSize().height));
        this.init();
    }

    public /* synthetic */ SyncFoldersDialog(Project project, RemoteCredentials remoteCredentials, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        this(project, remoteCredentials, list);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this.pathsTable)).setAddAction(arg_0 -> SyncFoldersDialog.createCenterPanel$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> SyncFoldersDialog.createCenterPanel$lambda$1(this, arg_0)).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final void onAddMapping() {
        ((Collection)this.deployPathMappings).add(new DeploymentPathMapping());
        this.updateUI();
    }

    @NotNull
    public final List<DeploymentPathMapping> getDeploymentPathMappings() {
        return this.deployPathMappings;
    }

    private final void updateUI() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new LocalPathColumn(), new DeployPathColumn()};
        ColumnInfo[] columns = columnInfoArray;
        ListTableModel tableModel = new ListTableModel(columns, this.deployPathMappings);
        this.pathsTable.setModelAndUpdateColumns(tableModel);
    }

    private static final void createCenterPanel$lambda$0(SyncFoldersDialog this$0, AnActionButton it) {
        this$0.onAddMapping();
    }

    private static final void createCenterPanel$lambda$1(SyncFoldersDialog this$0, AnActionButton it) {
        this$0.pathsTable.stopEditing();
        int minSelectedIndex = this$0.pathsTable.getSelectionModel().getMinSelectionIndex();
        int[] selectedIndices = this$0.pathsTable.getSelectedRows();
        NavigableSet<Integer> modelIndices = new TreeSet();
        for (int selectedIndex : selectedIndices) {
            int modelIndex = this$0.pathsTable.convertRowIndexToModel(selectedIndex);
            modelIndices.add(modelIndex);
        }
        NavigableSet<Integer> navigableSet = modelIndices.descendingSet();
        Intrinsics.checkNotNullExpressionValue(navigableSet, (String)"descendingSet(...)");
        modelIndices = navigableSet;
        ListTableModel model = this$0.pathsTable.getListTableModel();
        Iterator iterator = modelIndices.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Integer entry;
            Integer n = entry = (Integer)iterator2.next();
            Intrinsics.checkNotNull((Object)n);
            model.removeRow(n.intValue());
        }
        this$0.updateUI();
        int index = Math.min(minSelectedIndex, this$0.pathsTable.getRowCount() - 1);
        if (index != -1) {
            this$0.pathsTable.setRowSelectionInterval(index, index);
        }
    }

    public static final /* synthetic */ RemoteCredentials access$getRemoteCredentials$p(SyncFoldersDialog $this) {
        return $this.remoteCredentials;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/remoteInterpreter/add/wizard/ui/SyncFoldersDialog$DeployPathColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/jetbrains/plugins/webDeployment/config/DeploymentPathMapping;", "", "<init>", "(Lcom/intellij/python/remoteInterpreter/add/wizard/ui/SyncFoldersDialog;)V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "getEditor", "Ljavax/swing/table/TableCellEditor;", "intellij.python.remoteInterpreter"})
    private final class DeployPathColumn
    extends ColumnInfo<DeploymentPathMapping, String> {
        public DeployPathColumn() {
            super(PythonRemoteInterpreterBundle.message("sync.folder.dialog.column.name.remote.path", new Object[0]));
        }

        @Nullable
        public String valueOf(@NotNull DeploymentPathMapping item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getDeployPath();
        }

        public boolean isCellEditable(@NotNull DeploymentPathMapping item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return true;
        }

        public void setValue(@NotNull DeploymentPathMapping item, @Nullable String value2) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            item.setDeployPath(value2);
        }

        @NotNull
        public TableCellEditor getEditor(@NotNull DeploymentPathMapping item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Project project = SyncFoldersDialog.this.project;
            return (TableCellEditor)new LocalPathCellEditor(SyncFoldersDialog.this, project){
                final /* synthetic */ SyncFoldersDialog this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                protected ActionListener createActionListener(JTable table) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    return arg_0 -> getEditor.1.createActionListener$lambda$1(this, this.this$0, arg_0);
                }

                private static final void createActionListener$lambda$1$lambda$0(JTextField $myPathField, boolean $myFoldersOnly, RemoteCredentials $data) {
                    WebServerConfig.RemotePath path2;
                    ServerBrowserDialog d = RemoteSdkUtil.showBrowseRemoteDialog((String)PythonRemoteInterpreterBundle.message("sync.folder.dialog.title.select.remote.path", new Object[0]), (JTextField)$myPathField, (boolean)$myFoldersOnly, (Deployable)((Deployable)RemoteSdkUtil.createDeployable((RemoteCredentials)$data)));
                    if (d.isOK() && (path2 = d.getPath()) != null) {
                        $myPathField.setText(path2.path);
                    }
                }

                private static final void createActionListener$lambda$1(getEditor.1 this$0, SyncFoldersDialog this$1, ActionEvent it) {
                    RemoteCredentials data;
                    boolean myFoldersOnly = true;
                    JTextField myPathField = (JTextField)this$0.myComponent.getChildComponent();
                    if (RemoteSdkUtil.testConnection((Component)myPathField, (RemoteCredentials)(data = SyncFoldersDialog.access$getRemoteCredentials$p(this$1)), (boolean)false)) {
                        UIUtil.invokeLaterIfNeeded(() -> getEditor.1.createActionListener$lambda$1$lambda$0(myPathField, myFoldersOnly, data));
                    }
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/remoteInterpreter/add/wizard/ui/SyncFoldersDialog$LocalPathColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/jetbrains/plugins/webDeployment/config/DeploymentPathMapping;", "", "<init>", "(Lcom/intellij/python/remoteInterpreter/add/wizard/ui/SyncFoldersDialog;)V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "getEditor", "Ljavax/swing/table/TableCellEditor;", "intellij.python.remoteInterpreter"})
    private final class LocalPathColumn
    extends ColumnInfo<DeploymentPathMapping, String> {
        public LocalPathColumn() {
            super(PythonRemoteInterpreterBundle.message("sync.folder.dialog.column.name.local.path", new Object[0]));
        }

        @Nullable
        public String valueOf(@NotNull DeploymentPathMapping item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getLocalPath();
        }

        public boolean isCellEditable(@NotNull DeploymentPathMapping item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return true;
        }

        public void setValue(@NotNull DeploymentPathMapping item, @Nullable String value2) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            item.setLocalPath(value2);
        }

        @NotNull
        public TableCellEditor getEditor(@NotNull DeploymentPathMapping item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (TableCellEditor)new LocalPathCellEditor(PythonRemoteInterpreterBundle.message("sync.folders.dialog.title.choose.local.path", new Object[0]), SyncFoldersDialog.this.project);
        }
    }
}

