/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.css;

import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.webcomponents.index.WebComponentsIndex;
import com.intellij.webcomponents.util.WebComponentsUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WebComponentCssElementDescriptorProvider
extends CssElementDescriptorProvider {
    WebComponentCssElementDescriptorProvider() {
    }

    public boolean isMyContext(@Nullable PsiElement context) {
        if (context == null || !context.isValid()) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return false;
        }
        if (!WebComponentsUtil.hasPolymerJs(context)) {
            return false;
        }
        if (HtmlUtil.hasHtml((PsiFile)file)) {
            return true;
        }
        Project project = context.getProject();
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        String dialectName = (String)CssDialectMappings.getInstance((Project)project).getMapping(virtualFile);
        return dialectName == null || dialectName.equals(CssDialect.CLASSIC.getName());
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(1);
        }
        return WebComponentsUtil.isPossibleSelector(selector, context);
    }

    public String @NotNull [] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(2);
        }
        if (!(CssUtil.isInsideKeyframes((PsiElement)context) || CssUtil.isInsideFontFace((PsiElement)context) || CssUtil.isInsidePageRuleset((PsiElement)context))) {
            String[] stringArray = ArrayUtilRt.toStringArray(WebComponentsUtil.getSelectors(context.getProject()));
            if (stringArray == null) {
                WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(4);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public PsiElement @NotNull [] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(5);
        }
        if (WebComponentsIndex.getNames(selector.getProject()).contains(selector.getElementName())) {
            PsiElement[] psiElementArray = WebComponentCssElementDescriptorProvider.tryFindWebComponent(selector);
            if (psiElementArray == null) {
                WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(6);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(7);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement[] tryFindWebComponent(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            WebComponentCssElementDescriptorProvider.$$$reportNull$$$0(8);
        }
        String selectorName = selector.getElementName();
        HashSet<String> keys = new HashSet<String>();
        keys.add(selectorName);
        ArrayList<PsiElement> declarations = WebComponentsIndex.findDeclarations(keys, selector.getManager(), selector.getResolveScope());
        return declarations.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleSelectors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsForSimpleSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleSelectors";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryFindWebComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

