/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.editor;

import com.intellij.codeInsight.generation.CommenterWithLineSuffix;
import com.intellij.lang.CustomUncommenter;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTemplateCommenter
implements CustomUncommenter,
CommenterWithLineSuffix {
    private static final Pattern COMMENT_RANGE_REGEX = Pattern.compile("(\\{% *comment .*?(?<!%})%}.*\\{% *endcomment *%})", 32);
    private static final Pattern COMMENTS_REGEX = Pattern.compile("(\\{% *comment .*?(?<!%})%}\\r?\\n?).*?(\\{% *endcomment *%})", 32);

    public String getLineCommentPrefix() {
        return "{#";
    }

    @NotNull
    public String getLineCommentSuffix() {
        return "#}";
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    public String getBlockCommentPrefix() {
        return "{% comment %}";
    }

    public String getBlockCommentSuffix() {
        return "{% endcomment %}";
    }

    @Nullable
    public TextRange findMaximumCommentedRange(@NotNull CharSequence text) {
        Matcher matcher;
        if (text == null) {
            DjangoTemplateCommenter.$$$reportNull$$$0(0);
        }
        if (!(matcher = COMMENT_RANGE_REGEX.matcher(text)).find()) {
            return null;
        }
        return new TextRange(matcher.start(1), matcher.end(1));
    }

    @NotNull
    public List<Couple<TextRange>> getCommentRangesToDelete(@NotNull CharSequence text) {
        if (text == null) {
            DjangoTemplateCommenter.$$$reportNull$$$0(1);
        }
        ArrayList<Couple<TextRange>> result = new ArrayList<Couple<TextRange>>();
        Matcher matcher = COMMENTS_REGEX.matcher(text);
        while (matcher.find()) {
            result.add((Couple<TextRange>)Couple.of((Object)new TextRange(matcher.start(1), matcher.end(1)), (Object)new TextRange(matcher.start(2), matcher.end(2))));
        }
        ArrayList<Couple<TextRange>> arrayList = result;
        if (arrayList == null) {
            DjangoTemplateCommenter.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/lang/template/editor/DjangoTemplateCommenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/lang/template/editor/DjangoTemplateCommenter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentRangesToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMaximumCommentedRange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommentRangesToDelete";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

