/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.facts;

import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactDataIndexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.FileContent;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RubyFactIndexer
implements PuppetFactDataIndexer {
    private static final Pattern RUBY_ADD_FACT_PATTERN = Pattern.compile("Facter\\s*\\.\\s*add\\s*\\((?:\"|'|:)([^ )\"']+)(?:\"|')?\\s*(?:\\)|,)");

    RubyFactIndexer() {
    }

    @NotNull
    public Map<String, Integer> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            RubyFactIndexer.$$$reportNull$$$0(0);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Matcher matcher = RUBY_ADD_FACT_PATTERN.matcher(inputData.getContentAsText());
        while (matcher.find()) {
            String factName = matcher.group(1);
            result.put(factName, matcher.start(1));
        }
        HashMap<String, Integer> hashMap = result;
        if (hashMap == null) {
            RubyFactIndexer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Override
    public boolean acceptsFile(@NotNull String fileName, @NotNull String parentDirName) {
        if (fileName == null) {
            RubyFactIndexer.$$$reportNull$$$0(2);
        }
        if (parentDirName == null) {
            RubyFactIndexer.$$$reportNull$$$0(3);
        }
        return parentDirName.equals("facter") && StringUtil.endsWithIgnoreCase((String)fileName, (String)".rb");
    }

    @Override
    @Nullable
    public FileType getSuitableFileType() {
        return FileTypeRegistry.getInstance().findFileTypeByName("Ruby");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/RubyFactIndexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/RubyFactIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

