/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.data;

import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.io.Positioned;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class V8HeapEntry
implements Positioned {
    private final V8HeapNodeType myType;
    private final long myNameId;
    private final long mySnapshotObjectId;
    private final long myChildrenCount;
    private final long mySize;
    private final long myTraceId;
    private final long myFileOffset;
    private long myEdgesOffset;
    private long myRetainedSize;
    private long myReverseEdgesOffset;
    private int myParentsCount;
    public static final long ourRecordSize = 84L;
    private int myDistance;

    private V8HeapEntry(V8HeapNodeType type, long nameId, long snapshotObjectId, long childrenCount, long size, long traceId, long offset, long edgesOffset, long retainedSize, int distance, long reverseEdgesOffset, int parentsCount) {
        this.myType = type;
        this.myNameId = nameId;
        this.mySnapshotObjectId = snapshotObjectId;
        this.myChildrenCount = childrenCount;
        this.mySize = size;
        this.myTraceId = traceId;
        this.myFileOffset = offset;
        this.myEdgesOffset = edgesOffset;
        this.myRetainedSize = retainedSize;
        this.myDistance = distance;
        this.myReverseEdgesOffset = reverseEdgesOffset;
        this.myParentsCount = parentsCount;
    }

    public static V8HeapEntry createFromJson(int typeCode, long nameId, long snapshotId, long childrenCount, long size, long traceId, long seqNumber) {
        return new V8HeapEntry(V8HeapNodeType.getByNumber(typeCode), nameId, snapshotId, childrenCount, size, traceId, seqNumber * 84L, -1L, 0L, -1, 0L, 0);
    }

    public void setEdgesOffset(long edgesOffset) {
        this.myEdgesOffset = edgesOffset;
    }

    public void setRetainedSize(long retainedSize) {
        this.myRetainedSize = retainedSize;
    }

    public long getReverseEdgesOffset() {
        return this.myReverseEdgesOffset;
    }

    public int getParentsCount() {
        return this.myParentsCount;
    }

    public void setReverseEdgesOffset(long reverseEdgesOffset) {
        this.myReverseEdgesOffset = reverseEdgesOffset;
    }

    public void setParentsCount(int parentsCount) {
        this.myParentsCount = parentsCount;
    }

    public V8HeapNodeType getType() {
        return this.myType;
    }

    public long getNameId() {
        return this.myNameId;
    }

    public long getSnapshotObjectId() {
        return this.mySnapshotObjectId;
    }

    public long getChildrenCount() {
        return this.myChildrenCount;
    }

    public long getSize() {
        return this.mySize;
    }

    public long getTraceId() {
        return this.myTraceId;
    }

    public long getRetainedSize() {
        return this.myRetainedSize;
    }

    public long getFileOffset() {
        return this.myFileOffset;
    }

    public long getEdgesOffset() {
        return this.myEdgesOffset;
    }

    public long getId() {
        return this.getFileOffset() / 84L;
    }

    @Override
    public long getOffset() {
        return this.getFileOffset();
    }

    public void setDistance(int distance) {
        this.myDistance = distance;
    }

    public int getDistance() {
        return this.myDistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V8HeapEntry entry = (V8HeapEntry)o;
        return this.mySnapshotObjectId == entry.mySnapshotObjectId;
    }

    public int hashCode() {
        return Long.hashCode(this.mySnapshotObjectId);
    }

    public long getClassIndex() {
        if (V8HeapNodeType.kObject.equals((Object)this.myType) || V8HeapNodeType.kNative.equals((Object)this.myType)) {
            return this.myNameId;
        }
        return -1 - this.myType.getNumber();
    }

    public static class MyRawSerializer
    implements RawSerializer<V8HeapEntry> {
        private static final MyRawSerializer ourInstance = new MyRawSerializer();

        public static MyRawSerializer getInstance() {
            return ourInstance;
        }

        @Override
        public long getRecordSize() {
            return 84L;
        }

        @Override
        public void write(@NotNull DataOutput dout, @NotNull V8HeapEntry entry) throws IOException {
            if (dout == null) {
                MyRawSerializer.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                MyRawSerializer.$$$reportNull$$$0(1);
            }
            RawSerializer.Helper.serializeInt(entry.getType().getNumber(), dout);
            RawSerializer.Helper.serializeLong(entry.getNameId(), dout);
            RawSerializer.Helper.serializeLong(entry.getSnapshotObjectId(), dout);
            RawSerializer.Helper.serializeLong(entry.getChildrenCount(), dout);
            RawSerializer.Helper.serializeLong(entry.getSize(), dout);
            RawSerializer.Helper.serializeLong(entry.getTraceId(), dout);
            RawSerializer.Helper.serializeLong(entry.getFileOffset(), dout);
            RawSerializer.Helper.serializeLong(entry.myEdgesOffset, dout);
            RawSerializer.Helper.serializeLong(entry.getRetainedSize(), dout);
            RawSerializer.Helper.serializeInt(entry.getDistance(), dout);
            RawSerializer.Helper.serializeLong(entry.getReverseEdgesOffset(), dout);
            RawSerializer.Helper.serializeInt(entry.getParentsCount(), dout);
        }

        @Override
        public V8HeapEntry read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyRawSerializer.$$$reportNull$$$0(2);
            }
            int type = RawSerializer.Helper.deserializeInt(in);
            long nameId = RawSerializer.Helper.deserializeLong(in);
            long snapshotId = RawSerializer.Helper.deserializeLong(in);
            long childrenCount = RawSerializer.Helper.deserializeLong(in);
            long size = RawSerializer.Helper.deserializeLong(in);
            long traceId = RawSerializer.Helper.deserializeLong(in);
            long fileOffset = RawSerializer.Helper.deserializeLong(in);
            long edgesOffset = RawSerializer.Helper.deserializeLong(in);
            long retainedSize = RawSerializer.Helper.deserializeLong(in);
            int distance = RawSerializer.Helper.deserializeInt(in);
            long reverseEdgesOffset = RawSerializer.Helper.deserializeLong(in);
            int parentsCount = RawSerializer.Helper.deserializeInt(in);
            return new V8HeapEntry(V8HeapNodeType.getByNumber(type), nameId, snapshotId, childrenCount, size, traceId, fileOffset, edgesOffset, retainedSize, distance, reverseEdgesOffset, parentsCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dout";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/data/V8HeapEntry$MyRawSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

