/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.util.Version;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0015\b\u0016\u0012\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/model/serialization/Converter;", "", "version", "Lcom/intellij/database/util/Version;", "<init>", "(Lcom/intellij/database/util/Version;)V", "ver", "", "", "([I)V", "getVersion", "()Lcom/intellij/database/util/Version;", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "convertModel", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "applyMem", "getter", "Lkotlin/Function1;", "Lcom/intellij/database/model/serialization/ModelElementMem;", "Lcom/intellij/database/model/basic/BasicModElement;", "intellij.database.core.impl"})
public abstract class Converter {
    @NotNull
    private final Version version;

    public Converter(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.version = version;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    public Converter(int ... ver) {
        Intrinsics.checkNotNullParameter((Object)ver, (String)"ver");
        Version version = Version.of(Arrays.copyOf(ver, ver.length));
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"of(...)");
        this(version);
    }

    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
    }

    public void convertModel(@NotNull BasicModModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
    }

    public void applyMem(@NotNull ModelMem modelMem, @NotNull BasicModModel model, @NotNull Function1<? super ModelElementMem, ? extends BasicModElement> getter) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(getter, (String)"getter");
    }
}

