/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ui/util/CIELabUtils;", "", "<init>", "()V", "xyz_D65", "", "fromRGB", "rgbvalue", "toRGB", "colorvalue", "RGBtoXYZ", "rgb", "XYZtoLab", "xyz", "LabtoXYZ", "lab", "XYZtoRGB", "f", "", "t", "intellij.rd.ui"})
public final class CIELabUtils {
    @NotNull
    public static final CIELabUtils INSTANCE = new CIELabUtils();
    @NotNull
    private static final float[] xyz_D65;

    private CIELabUtils() {
    }

    @NotNull
    public final float[] fromRGB(@NotNull float[] rgbvalue) {
        Intrinsics.checkNotNullParameter((Object)rgbvalue, (String)"rgbvalue");
        return this.XYZtoLab(this.RGBtoXYZ(rgbvalue));
    }

    @NotNull
    public final float[] toRGB(@NotNull float[] colorvalue) {
        Intrinsics.checkNotNullParameter((Object)colorvalue, (String)"colorvalue");
        return this.XYZtoRGB(this.LabtoXYZ(colorvalue));
    }

    private final float[] RGBtoXYZ(float[] rgb) {
        float rLinear = rgb[0];
        float gLinear = rgb[1];
        float bLinear = rgb[2];
        float r = rLinear > 0.04045f ? (float)Math.pow(((double)rLinear + 0.055) / 1.055, 2.2) : rLinear / 12.92f;
        float g = gLinear > 0.04045f ? (float)Math.pow(((double)gLinear + 0.055) / 1.055, 2.2) : gLinear / 12.92f;
        float b = bLinear > 0.04045f ? (float)Math.pow(((double)bLinear + 0.055) / 1.055, 2.2) : bLinear / 12.92f;
        float x = r * 0.4124f + g * 0.3576f + b * 0.1805f;
        float y = r * 0.2126f + g * 0.7152f + b * 0.0722f;
        float z = r * 0.0193f + g * 0.1192f + b * 0.9505f;
        float f = x > 0.9505f ? 0.9505f : (x = x < 0.0f ? 0.0f : x);
        float f2 = y > 1.0f ? 1.0f : (y = y < 0.0f ? 0.0f : y);
        z = z > 1.089f ? 1.089f : (z < 0.0f ? 0.0f : z);
        float[] fArray = new float[]{x, y, z};
        return fArray;
    }

    private final float[] XYZtoLab(float[] xyz) {
        float x = xyz[0];
        float y = xyz[1];
        float z = xyz[2];
        float[] fArray = xyz_D65;
        float X = fArray[0];
        float Y = fArray[1];
        float Z = fArray[2];
        float[] fArray2 = new float[]{116.0f * this.f(y / Y) - (float)16, 500.0f * (this.f(x / X) - this.f(y / Y)), 200.0f * (this.f(y / Y) - this.f(z / Z))};
        return fArray2;
    }

    private final float[] LabtoXYZ(float[] lab) {
        float z;
        float theta = 0.20689656f;
        float l = lab[0];
        float a = lab[1];
        float b = lab[2];
        float fy = (l + 16.0f) / 116.0f;
        float fx = fy + a / 500.0f;
        float fz = fy - b / 200.0f;
        float[] fArray = xyz_D65;
        float X = fArray[0];
        float Y = fArray[1];
        float Z = fArray[2];
        float x = fx > theta ? X * (fx * fx * fx) : (fx - 0.13793103f) * (float)3 * (theta * theta) * X;
        float y = fy > theta ? Y * (fy * fy * fy) : (fy - 0.13793103f) * (float)3 * (theta * theta) * Y;
        float f = z = fz > theta ? Z * (fz * fz * fz) : (fz - 0.13793103f) * (float)3 * (theta * theta) * Z;
        float f2 = x > 0.9505f ? 0.9505f : (x = x < 0.0f ? 0.0f : x);
        float f3 = y > 1.0f ? 1.0f : (y = y < 0.0f ? 0.0f : y);
        z = z > 1.089f ? 1.089f : (z < 0.0f ? 0.0f : z);
        float[] fArray2 = new float[]{x, y, z};
        return fArray2;
    }

    private final float[] XYZtoRGB(float[] xyz) {
        float x = xyz[0];
        float y = xyz[1];
        float z = xyz[2];
        float[] fArray = new float[]{x * 3.241f - y * 1.5374f - z * 0.4986f, -x * 0.9692f + y * 1.876f + z * 0.0416f, x * 0.0556f - y * 0.204f + z * 1.057f};
        float[] cLinear = fArray;
        for (int i = 0; i < 3; ++i) {
            float f = cLinear[i] = cLinear[i] <= 0.0031308f ? 12.92f * cLinear[i] : 1.055f * (float)Math.pow(cLinear[i], 0.45454545454545453) - 0.055f;
            if (cLinear[i] > 1.0f) {
                cLinear[i] = 1.0f;
            }
            if (!(cLinear[i] < 0.0f)) continue;
            cLinear[i] = 0.0f;
        }
        return cLinear;
    }

    private final float f(float t) {
        return t > 0.008856f ? (float)Math.pow(t, 0.3333333333333333) : 7.787f * t + 0.13793103f;
    }

    static {
        float[] fArray = new float[]{0.9505f, 1.0f, 1.089f};
        xyz_D65 = fArray;
    }
}

