/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gradle;

import com.intellij.diagram.gradle.GradleElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Objects;
import javax.swing.Icon;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleFileDependencyElement
implements GradleElement {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myId;
    @NotNull
    private final String myName;
    @NotNull
    private final String myPath;

    public GradleFileDependencyElement(@NotNull Project project, @NotNull String id, @NotNull String name, @NotNull String path) {
        if (project == null) {
            GradleFileDependencyElement.$$$reportNull$$$0(0);
        }
        if (id == null) {
            GradleFileDependencyElement.$$$reportNull$$$0(1);
        }
        if (name == null) {
            GradleFileDependencyElement.$$$reportNull$$$0(2);
        }
        if (path == null) {
            GradleFileDependencyElement.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myId = id;
        this.myName = name;
        this.myPath = StringUtil.join((Object[])path.split(File.pathSeparator), s -> StringEscapeUtils.escapeHtml4((String)s) + "<br/>", (String)"");
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleFileDependencyElement.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            GradleFileDependencyElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getHtmlDescription() {
        String string = "<html>" + this.myPath + "</html>";
        if (string == null) {
            GradleFileDependencyElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AllIcons.Vcs.Folders;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GradleFileDependencyElement.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleFileDependencyElement element = (GradleFileDependencyElement)o;
        return this.myProject.equals(element.myProject) && this.myId.equals(element.myId) && this.myName.equals(element.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myProject, this.myId, this.myName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/gradle/GradleFileDependencyElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/gradle/GradleFileDependencyElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

