/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.LocalVsRemoteTaskBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompareLocalVsRemoteTask
extends LocalVsRemoteTaskBase<LocalMappingDiffRoot> {
    private static final Logger LOG = Logger.getInstance(LocalVsRemoteTaskBase.class);

    public CompareLocalVsRemoteTask(@NotNull Project project, @NlsContexts.ProgressTitle @NotNull String title, Deployable server, String toolWindowId, LocalMappingDiffRoot root) {
        if (project == null) {
            CompareLocalVsRemoteTask.$$$reportNull$$$0(0);
        }
        if (title == null) {
            CompareLocalVsRemoteTask.$$$reportNull$$$0(1);
        }
        super(project, title, server, toolWindowId, Collections.singletonList(root));
    }

    @Override
    protected boolean execute(List<DiffRoot> roots, ExecutionContextBase context, RemoteConnection remoteConnection) {
        DiffContent remoteContent;
        LOG.assertTrue(roots.size() == 1, (Object)"Compare action is designed for a single pair of files.");
        DiffRoot pair = roots.get(0);
        FileObject remoteItem = pair.getRemote();
        VirtualFile localFile = pair.getLocal();
        context.getProgressIndicator().setText(WDBundle.message("loading.content.of", remoteItem.getName().getBaseName()));
        String remotePath = context.getServer().getPresentablePath(remoteItem);
        Project project = this.getProject();
        try {
            byte[] remoteBytes = FileTransferUtil.getContent(remoteItem, context.getProgressIndicator());
            remoteContent = DiffContentFactory.getInstance().createFromBytes(project, remoteBytes, localFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            String message = WDBundle.message("could.not.load.remote.file.content", remotePath, PublishUtils.getMessage(e, false));
            Util.showBalloonError(project, this.myToolWindowId, message);
            return false;
        }
        context.getProgressIndicator().checkCanceled();
        ApplicationManager.getApplication().invokeLater(() -> {
            DiffContent localContent = DiffContentFactory.getInstance().create(project, localFile);
            MutableDiffRequestChain request = new MutableDiffRequestChain(localContent, remoteContent, project);
            request.setWindowTitle(localFile.getPresentableUrl());
            request.setTitle1(WDBundle.message("diff.local", localFile.getPresentableUrl()));
            request.setTitle2(WDBundle.message("diff.deployed", remotePath));
            DiffManager.getInstance().showDiff(project, (DiffRequestChain)request, DiffDialogHints.DEFAULT);
        });
        return true;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    protected String validate(LocalMappingDiffRoot pair, FileObject remoteItem, ExecutionContextBase context) {
        try {
            if (!remoteItem.exists()) {
                return pair.getLocal().isDirectory() ? WDBundle.message("remote.folder.does.not.exist", context.getServer().getPresentablePath(remoteItem)) : WDBundle.message("remote.file.does.not.exist", context.getServer().getPresentablePath(remoteItem));
            }
            if (remoteItem.getType() == (pair.getLocal().isDirectory() ? FileType.FILE : FileType.FOLDER)) {
                return remoteItem.getType() == FileType.FOLDER ? WDBundle.message("remote.item.is.folder", context.getServer().getPresentablePath(remoteItem)) : WDBundle.message("remote.item.is.file", context.getServer().getPresentablePath(remoteItem));
            }
        }
        catch (FileSystemException e) {
            return PublishUtils.getMessage(e, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/CompareLocalVsRemoteTask";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

