//go:build !purego

// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package fft

import (
	"github.com/consensys/gnark-crypto/field/koalabear"
	fext "github.com/consensys/gnark-crypto/field/koalabear/extensions"
	"github.com/consensys/gnark-crypto/utils/cpu"
)

// q + r'.r = 1, i.e., qInvNeg = - q⁻¹ mod r
// used for Montgomery reduction
const qInvNeg = 2130706431
const q = 2130706433

// index table used in avx512 shuffling
var vInterleaveIndices = []uint64{
	2, 3, 8, 9, 6, 7, 12, 13,
}

//go:noescape
func innerDIFWithTwiddles_avx512(a, twiddles *koalabear.Element, start, end, m int)

//go:noescape
func innerDITWithTwiddles_avx512(a, twiddles *koalabear.Element, start, end, m int)

func innerDIFWithTwiddles(a []koalabear.Element, twiddles []koalabear.Element, start, end, m int) {
	if !cpu.SupportAVX512 || m < 16 {
		innerDIFWithTwiddlesGeneric(a, twiddles, start, end, m)
		return
	}
	innerDIFWithTwiddles_avx512(&a[0], &twiddles[0], start, end, m)
}

func innerDITWithTwiddles(a []koalabear.Element, twiddles []koalabear.Element, start, end, m int) {
	if !cpu.SupportAVX512 || m < 16 {
		innerDITWithTwiddlesGeneric(a, twiddles, start, end, m)
		return
	}
	innerDITWithTwiddles_avx512(&a[0], &twiddles[0], start, end, m)
}

//go:noescape
func kerDIFNP_256_avx512(a []koalabear.Element, twiddles [][]koalabear.Element, stage int)

func kerDIFNP_256(a []koalabear.Element, twiddles [][]koalabear.Element, stage int) {
	if !cpu.SupportAVX512 {
		kerDIFNP_256generic(a, twiddles, stage)
		return
	}
	kerDIFNP_256_avx512(a, twiddles, stage)
}

//go:noescape
func kerDITNP_256_avx512(a []koalabear.Element, twiddles [][]koalabear.Element, stage int)

func kerDITNP_256(a []koalabear.Element, twiddles [][]koalabear.Element, stage int) {
	if !cpu.SupportAVX512 {
		kerDITNP_256generic(a, twiddles, stage)
		return
	}
	kerDITNP_256_avx512(a, twiddles, stage)
}

func innerDIFWithTwiddlesExt(a []fext.E4, twiddles []koalabear.Element, start, end, m int) {
	innerDIFWithTwiddlesGenericExt(a, twiddles, start, end, m)
}

func innerDITWithTwiddlesExt(a []fext.E4, twiddles []koalabear.Element, start, end, m int) {
	innerDITWithTwiddlesGenericExt(a, twiddles, start, end, m)
}

func kerDIFNP_256Ext(a []fext.E4, twiddles [][]koalabear.Element, stage int) {
	kerDIFNP_256genericExt(a, twiddles, stage)
}

func kerDITNP_256Ext(a []fext.E4, twiddles [][]koalabear.Element, stage int) {
	kerDITNP_256genericExt(a, twiddles, stage)
}
