// bindgen-unstable

// This was originally a test case generated by creducing errors in SpiderMonkey
// bindings generation. I've tried to make it understandable by giving more
// meaningful names to everything, and a couple comments.
//
// We don't support partial template specialization, but we *should*
// successfully parse this header, and generate bindings for it, but the usage
// of the partial template specialization should result in opaque blobs.

// A base class providing a method.
template <typename T>
class Base {
public:
  void some_method(T, T);
};

// A template with a default representation.
template <typename U>
class Derived {
    bool b;
};

// A partial specialization for pointers. Note that this should have a different
// and larger layout than the template it is specializing.
template <typename U>
class Derived<U*> : public Base<U*> {
    int x;
    int y;
};

// A struct that uses the partial specialization and method from the partial
// specialization's base class.
struct Usage {
  Usage() {
      static_member.some_method(this, this);
  }

  static Derived<Usage*> static_member;
};
