# Announce: Rakudo Perl 6 compiler, Release #109 (2017.03)

On behalf of the Rakudo development team, I’m very happy to announce the
March 2017 release of Rakudo Perl 6 #109. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.03:
 + Fixes:
    + Made IO::Path.lines non-lazy so it can always close the file handle [0083c4f]
    + Fixed unwanted container re-use in `infix:<x>` [5b7b7fb]
    + Made Emoji_Modifier_Base return Bool instead of int with uniprop [2125d4d]
    + Fixed JIT rounding bug for negatives in nqp::div_i [deac603][f73d984]
    + Fixed failure in `\c[]` with non-ASCII names [deac603]
    + Fixed issues in `infix:<div>` optimization [deac603]
    + Fixed .split(...:skip-empty) not skipping with empty strings [fc86084]
    + Fixed duplicated .done/.quit on Channels in Proc::Async on exit [c4a4c84]
    + Fixed error handling when Proc::Async process failed to spawn [f73d984]
    + Made sure `infix:<xx>` always returns a Seq [1eb7b1f]
    + Partially fixed `infix:<xx>` being non-lazy [f190f24]
    + Fixed SC collision when loading identical modules from
        different dists [254f76a]
    + Fixed CURI loading of modules with identical short-names [c1a0fa7]
    + Fixed SEGV in exception handler resolution in sub/INIT/return [b2eb115]
    + Fixed SEGV on `xx` with a huge repeat values [1cafc67]
    + Fixed SEGV on chars with a huge number of combiners [1cafc67]
    + Fixed SEGV when `Scalar` type object is processed by `unique` [cfe0e04]
    + Fixed .comb(Int) failing to work on Cool [a08e953]
    + Fixed hang in dispatch of .lines/.words when given wrong args [7425737]
    + Fixed cases of lack of panic upon with quantifiers in regexes [91a4ac5]
    + Fixed broken thunking of infix:<notandthen> [5e6f30a]
    + Fixed failure to thunk RHS on `or=`, `and=`, and `notandthen=` [3e88c41]
    + Fixed precision loss with `cmp` involving Rationals/Int [9e8ecb7]
    + Fixed crash in .Bool, .so, .not, .hash, and .elems on Baggy:U [e8af855]
    + Fixed crash in .Str on Bool:U [3de5fb2]
    + Fixed crash in IO::Special .WHICH/.Str [dd4dfb1]
    + Fixed install wrapper when no binaries are found [796b6a8]
    + Fixed crash when calling .sort on reified empty Array [8e250db][75e070f]
    + Fixed `Nil` being displayed as `Mu` in REPL [a274bdd][cd47e2a]
    + Fixed previous output silencing exceptions in REPL
        [db70a1f][61a65ce][7f9235c]
    + Fixed loss of data when using a hash in assignment to itself [ae7bcf1]
    + Fixed IO::Path.e failing to detect changes on the filesystem [76f7187]
    + Fixed `infix:<eqv>` with Seq/List containing same elements [f9eb811]
    + Fixed CArray to pass NULL when for type object elements [26e6993]
    + Fixed GC deadlock when event loop worker thread was spawned [26e6993]
    + Fixed `:i` in regexes using lowercase instead of fold case [26e6993]
    + Fixed parsing issue with detached methods in `[…]` metaop [e1ebb50]
    + Fixed unwanted list flattening in triangle reduce [10f5f74]
    + Fixed Range.int-bounds for NaN and Inf end points [79f2681][16ef21c]
    + JVM backend fixes [b1def95][2f6d2c6][dc19892][cef41b2]
    + Various improvements to error reporting
        [dc5fb20][d66c382][b11dc88][6cb9be2][3bf734f][26e6993]
        [20fa14b][127338a][1934a56][27dc7b1][1e24666]
 + Additions:
    + Made symbol imports of `require`d modules lexical. For more information,
        see http://rakudo.org/2017/03/18/lexical-require-upgrade-info/
        [63cf5ca][3e86d0f][5b98caa][6771dee][9da6de4][4fce405][030c4c5]
    + Added ≤, ≥, ≠ as Unicode versions of <=, >=, and != [5c68ea6]
    + Made it possible to hyper ops that return a Seq [e2db7b8]
    + Made `infix:<∘>` keep RHS's .count and .arity and LHS's .of [032b283][cb149a8]
    + Made purity propagate up through meta-meta ASTs [68a40f7]
    + Made Proc::Async default to translating newlines [05add43][2973ccd]
    + Implemented Str.parse-names [5c1761a]
    + Added `$epsilon` argument to Complex.Rat/.FatRat [a4af702]
    + Fixed loss of precision in Instant.Rat [a4af702]
    + Implemented .FatRat coercer in Cool and Numeric [a4af702]
    + Added Mu candidate for `infix:<xx>` [e270a15]
    + Implemented Mu.iterator [81fcd1b]
    + Made sure Str.split always returns a Seq [f595733][8301a30]
    + Made List.reverse return a Seq [beda576]
    + [EXPERIMENTAL] Added support for Parameter.set_default [d6c95ea]
    + Implemented new internal braids API to make future optimizations easier.
        This affects any slang modules that access `%*LANG`, `%*PRAGMAS`, and
        `$*ACTIONS` internals using unofficial API.
 + Removals:
    + Removed IO::Path.Bridge [212cc8a]
    + Removed support for IO::Handle.lines(:close) agument [76a59cf]
 + Efficiency:
    + Made min/max/min=/max= about 3x faster [a9c5196]
    + Made .WHICH of numerous types about 1.8x faster [79bb179][65b0040]
    + Made case-insensitive regex match 20%-30% faster [5b6e0fb][f73d984]
    + Made triangle reduce right op with 2 params 2x faster [e114d52]
    + Made triangle reduce right op with 2+ params 1.5x faster [d04c47f]
    + Made IO::Handle.lines about 10% faster [9019a5b]
    + Made IO::Handle.getc about 3% faster [9019a5b]
    + Made reduce chain op about 5% faster [9cec31a]
    + Made IO::Handle.lines about 10% faster [9da50e3]
    + Made List.reverse 0%–30% faster and reduced memory pressure by up to 70%
        [beda576]
    + Made loops/maps with NEXT phaser about 5% faster [80e0bce]
    + Made `infix:<%%>` about 14x faster for Int,Int case [755e25b]
    + Made `infix:<%>` about 8x faster for Int,Int case [5ec2517]
    + Made Junction creation about 20% faster [fafe663]
    + Made callframe() about 20% faster [7966dad][9a74cd0]
    + Made meta reduce with right-assoc. op 30%–200% faster [60a8f9e][2cf9b53]
    + REMOVED caching of IO::Path.e results to fix unwanted behaviour [76f7187]
    + Assorted internal improvements to CPU/memory use
        [b2e0ac0][25a3cc5][b61b3c7][829762a][45b3af8][7010ae9][556db9d][9e9a4ad]
        [8e8cd14][7556498][adb6f87][9a109c9][3de7b08][b283e52][0be7247][74573d0]
        [79d5670][313e7b2][e723e00][5843ee6][7c279c3][318f8ee][4ef1e69][9d497e9]
        [b597398][4bc826d][9da50e3][2a2e460][0633f03][d444f65][f94a2c7]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Wenzel P. P. Peppmeyer, Samantha McVey,
Will "Coke" Coleda, Pawel Murias, Jonathan Worthington, Daniel Green,
Brian Duggan, Tom Browder, Larry Wall, Christian Bartolomäus, Altai-man,
Fernando Correa de Oliveira, Stefan Seifert, Itsuki Toyota, LLFourn,
Aleks-Daniel Jakimenko-Aleksejev, Naoum Hankache, Bart Wiegmans, Cale,
Fernando Correa, Timo Paulssen, Nick Logan, Ronald Schmidt, Brad Gilbert,
Claudio Ramirez, Will Coleda, raiph, ven, David Warring, Jan-Olof Hendig

as well as

Jonathan Scott Duff, Lucas Buchala, Moritz Lenz

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#110), is tentatively scheduled for 2017-04-15.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory documentation,
and other software that can be used with the Rakudo compiler to enhance its utility.
