/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.conn.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.org.apache.http.conn.util.DomainType;
import org.jetbrains.kotlin.org.apache.http.conn.util.PublicSuffixList;

public final class PublicSuffixListParser {
    public List<PublicSuffixList> parseByType(Reader reader) throws IOException {
        String line;
        ArrayList<PublicSuffixList> result = new ArrayList<PublicSuffixList>(2);
        BufferedReader r = new BufferedReader(reader);
        DomainType domainType = null;
        ArrayList<String> rules = null;
        ArrayList<String> exceptions = null;
        while ((line = r.readLine()) != null) {
            boolean isException;
            if (line.isEmpty()) continue;
            if (line.startsWith("//")) {
                if (domainType == null) {
                    if (line.contains("===BEGIN ICANN DOMAINS===")) {
                        domainType = DomainType.ICANN;
                        continue;
                    }
                    if (!line.contains("===BEGIN PRIVATE DOMAINS===")) continue;
                    domainType = DomainType.PRIVATE;
                    continue;
                }
                if (!line.contains("===END ICANN DOMAINS===") && !line.contains("===END PRIVATE DOMAINS===")) continue;
                if (rules != null) {
                    result.add(new PublicSuffixList(domainType, rules, exceptions));
                }
                domainType = null;
                rules = null;
                exceptions = null;
                continue;
            }
            if (domainType == null) continue;
            if (line.startsWith(".")) {
                line = line.substring(1);
            }
            if (isException = line.startsWith("!")) {
                line = line.substring(1);
            }
            if (isException) {
                if (exceptions == null) {
                    exceptions = new ArrayList<String>();
                }
                exceptions.add(line);
                continue;
            }
            if (rules == null) {
                rules = new ArrayList<String>();
            }
            rules.add(line);
        }
        return result;
    }
}

