/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class IsConstantExpressionVisitor
extends JavaElementVisitor {
    private boolean myIsConstant;
    private final Map<PsiVariable, Boolean> varIsConst = new HashMap<PsiVariable, Boolean>();

    IsConstantExpressionVisitor() {
    }

    public boolean isConstant() {
        return this.myIsConstant;
    }

    @Override
    public void visitExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(0);
        }
        this.myIsConstant = false;
    }

    @Override
    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(1);
        }
        this.myIsConstant = !"null".equals(expression.getText());
    }

    @Override
    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(2);
        }
        this.myIsConstant = true;
    }

    @Override
    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
        PsiExpression expr;
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(3);
        }
        if ((expr = expression.getExpression()) != null) {
            expr.accept(this);
        }
    }

    @Override
    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        PsiExpression operand;
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(4);
        }
        if ((operand = expression.getOperand()) == null) {
            this.myIsConstant = false;
            return;
        }
        operand.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        PsiTypeElement element = expression.getCastType();
        if (element == null) {
            this.myIsConstant = false;
            return;
        }
        PsiType type = element.getType();
        if (type instanceof PsiPrimitiveType) {
            return;
        }
        if (type.equalsToText("java.lang.String")) {
            return;
        }
        this.myIsConstant = false;
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        PsiExpression operand;
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(5);
        }
        if ((operand = expression.getOperand()) == null) {
            this.myIsConstant = false;
            return;
        }
        operand.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        IElementType opType = expression.getOperationTokenType();
        if (opType == JavaTokenType.PLUS || opType == JavaTokenType.MINUS || opType == JavaTokenType.TILDE || opType == JavaTokenType.EXCL) {
            return;
        }
        this.myIsConstant = false;
    }

    @Override
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(6);
        }
        for (PsiExpression operand : expression.getOperands()) {
            operand.accept(this);
            if (!this.myIsConstant) {
                return;
            }
            PsiType type = operand.getType();
            if (type == null || type instanceof PsiPrimitiveType || type.equalsToText("java.lang.String")) continue;
            this.myIsConstant = false;
            return;
        }
    }

    @Override
    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(7);
        }
        PsiExpression thenExpr = expression.getThenExpression();
        PsiExpression elseExpr = expression.getElseExpression();
        if (thenExpr == null || elseExpr == null) {
            this.myIsConstant = false;
            return;
        }
        expression.getCondition().accept(this);
        if (!this.myIsConstant) {
            return;
        }
        thenExpr.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        elseExpr.accept(this);
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        PsiExpression qualifierExpression;
        if (expression == null) {
            IsConstantExpressionVisitor.$$$reportNull$$$0(8);
        }
        if ((qualifierExpression = expression.getQualifierExpression()) != null && !(qualifierExpression instanceof PsiReferenceExpression)) {
            this.myIsConstant = false;
            return;
        }
        PsiElement refElement = expression.resolve();
        if (!(refElement instanceof PsiVariable)) {
            this.myIsConstant = false;
            return;
        }
        PsiVariable variable = (PsiVariable)refElement;
        Boolean isConst = this.varIsConst.get(variable);
        if (isConst != null) {
            this.myIsConstant &= isConst.booleanValue();
            return;
        }
        if (variable instanceof PsiEnumConstant) {
            this.myIsConstant = true;
            this.varIsConst.put(variable, Boolean.TRUE);
            return;
        }
        this.varIsConst.put(variable, Boolean.FALSE);
        if (!variable.hasModifierProperty("final")) {
            this.myIsConstant = false;
            return;
        }
        PsiExpression initializer = PsiFieldImpl.getDetachedInitializer(variable);
        if (initializer == null) {
            this.myIsConstant = false;
            return;
        }
        initializer.accept(this);
        this.varIsConst.put(variable, this.myIsConstant);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/intellij/psi/impl/IsConstantExpressionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteralExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClassObjectAccessExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParenthesizedExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeCastExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPolyadicExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

