/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetStateManager;
import org.jetbrains.jps.incremental.storage.FileKeyDescriptor;
import org.jetbrains.jps.incremental.storage.StampsStorage;

final class FileTimestampStorage
extends AbstractStateStorage<File, TimestampPerTarget[]>
implements StampsStorage<FileTimestamp> {
    private final BuildTargetStateManager targetStateManager;
    private final Path timestampRoot;

    FileTimestampStorage(@NotNull Path dataStorageRoot, @NotNull BuildTargetStateManager targetStateManager) throws IOException {
        if (dataStorageRoot == null) {
            FileTimestampStorage.$$$reportNull$$$0(0);
        }
        if (targetStateManager == null) {
            FileTimestampStorage.$$$reportNull$$$0(1);
        }
        super(FileTimestampStorage.calcStorageRoot(dataStorageRoot).resolve("data").toFile(), new FileKeyDescriptor(), new StateExternalizer());
        this.timestampRoot = FileTimestampStorage.calcStorageRoot(dataStorageRoot);
        this.targetStateManager = targetStateManager;
    }

    @NotNull
    private static Path calcStorageRoot(Path dataStorageRoot) {
        Path path = dataStorageRoot.resolve("timestamps");
        if (path == null) {
            FileTimestampStorage.$$$reportNull$$$0(2);
        }
        return path;
    }

    @Override
    public FileTimestamp getCurrentStampIfUpToDate(@NotNull Path file, @NotNull BuildTarget<?> target, @Nullable BasicFileAttributes attrs) throws IOException {
        TimestampPerTarget[] state;
        if (file == null) {
            FileTimestampStorage.$$$reportNull$$$0(3);
        }
        if (target == null) {
            FileTimestampStorage.$$$reportNull$$$0(4);
        }
        if ((state = (TimestampPerTarget[])this.getState(file.toFile())) == null) {
            return null;
        }
        int targetId = this.targetStateManager.getBuildTargetId(target);
        for (TimestampPerTarget timestampPerTarget : state) {
            if (timestampPerTarget.targetId != targetId) continue;
            long current = timestampPerTarget.timestamp;
            return current == FSOperations.lastModified(file, attrs) ? FileTimestamp.fromLong(current) : null;
        }
        return null;
    }

    @Override
    public void updateStamp(@NotNull Path file, BuildTarget<?> buildTarget, long currentFileTimestamp) throws IOException {
        if (file == null) {
            FileTimestampStorage.$$$reportNull$$$0(5);
        }
        int targetId = this.targetStateManager.getBuildTargetId(buildTarget);
        File ioFile = file.toFile();
        this.update(ioFile, FileTimestampStorage.updateTimestamp((TimestampPerTarget[])this.getState(ioFile), targetId, currentFileTimestamp));
    }

    private static TimestampPerTarget @NotNull [] updateTimestamp(TimestampPerTarget[] oldState, int targetId, long timestamp) {
        TimestampPerTarget newItem = new TimestampPerTarget(targetId, timestamp);
        if (oldState == null) {
            TimestampPerTarget[] timestampPerTargetArray = new TimestampPerTarget[]{newItem};
            if (timestampPerTargetArray == null) {
                FileTimestampStorage.$$$reportNull$$$0(6);
            }
            return timestampPerTargetArray;
        }
        int length = oldState.length;
        for (int i = 0; i < length; ++i) {
            if (oldState[i].targetId != targetId) continue;
            oldState[i] = newItem;
            if (oldState == null) {
                FileTimestampStorage.$$$reportNull$$$0(7);
            }
            return oldState;
        }
        TimestampPerTarget[] timestampPerTargetArray = (TimestampPerTarget[])ArrayUtil.append((Object[])oldState, (Object)newItem);
        if (timestampPerTargetArray == null) {
            FileTimestampStorage.$$$reportNull$$$0(8);
        }
        return timestampPerTargetArray;
    }

    @Override
    public void removeStamp(@NotNull Path file, BuildTarget<?> buildTarget) throws IOException {
        File ioFile;
        Object[] state;
        if (file == null) {
            FileTimestampStorage.$$$reportNull$$$0(9);
        }
        if ((state = (TimestampPerTarget[])this.getState(ioFile = file.toFile())) != null) {
            int targetId = this.targetStateManager.getBuildTargetId(buildTarget);
            for (int i = 0; i < state.length; ++i) {
                TimestampPerTarget timestampPerTarget = state[i];
                if (timestampPerTarget.targetId != targetId) continue;
                if (state.length == 1) {
                    this.remove(ioFile);
                    continue;
                }
                TimestampPerTarget[] newState = (TimestampPerTarget[])ArrayUtil.remove((Object[])state, (int)i);
                this.update(ioFile, newState);
                break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetStateManager";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/FileTimestampStorage";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/FileTimestampStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcStorageRoot";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "updateTimestamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentStampIfUpToDate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateStamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeStamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StateExternalizer
    implements DataExternalizer<TimestampPerTarget[]> {
        private StateExternalizer() {
        }

        public void save(@NotNull DataOutput out, TimestampPerTarget[] value) throws IOException {
            if (out == null) {
                StateExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.length);
            for (TimestampPerTarget target : value) {
                out.writeInt(target.targetId);
                out.writeLong(target.timestamp);
            }
        }

        public TimestampPerTarget[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                StateExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            TimestampPerTarget[] targets = new TimestampPerTarget[size];
            for (int i = 0; i < size; ++i) {
                int id = in.readInt();
                long timestamp = in.readLong();
                targets[i] = new TimestampPerTarget(id, timestamp);
            }
            return targets;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/FileTimestampStorage$StateExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class TimestampPerTarget {
        public final int targetId;
        public final long timestamp;

        private TimestampPerTarget(int targetId, long timestamp) {
            this.targetId = targetId;
            this.timestamp = timestamp;
        }
    }

    static final class FileTimestamp {
        private final long myTimestamp;

        FileTimestamp(long timestamp) {
            this.myTimestamp = timestamp;
        }

        @NotNull
        static FileTimestamp fromLong(long l) {
            return new FileTimestamp(l);
        }

        public String toString() {
            return "Timestamp{myTimestamp=" + this.myTimestamp + "}";
        }
    }
}

