/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.util;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class InsertLineAfterJumpVisitor
extends MethodVisitor {
    private final Map<Label, Integer> myLabelsWithoutLines = new HashMap<Label, Integer>();
    private Label myCurrentLabel;
    private int myCurrentLine = -1;

    /*
     * WARNING - void declaration
     */
    public InsertLineAfterJumpVisitor(MethodVisitor methodVisitor) {
        super(589824, (MethodVisitor)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        void var1_1;
        this.myCurrentLabel = label;
        super.visitLabel((Label)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        this.myCurrentLine = line;
        this.myLabelsWithoutLines.remove(start);
        super.visitLineNumber((int)var1_1, (Label)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void checkHasLineIfAfterJump() {
        void var1_1;
        if (this.myCurrentLine == -1) {
            return;
        }
        if (this.myCurrentLabel == null) {
            return;
        }
        Integer jumpedFromLine = this.myLabelsWithoutLines.remove(this.myCurrentLabel);
        if (jumpedFromLine != null && var1_1.intValue() != this.myCurrentLine) {
            InsertLineAfterJumpVisitor insertLineAfterJumpVisitor = this;
            insertLineAfterJumpVisitor.visitLineNumber(insertLineAfterJumpVisitor.myCurrentLine, this.myCurrentLabel);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitJumpInsn((int)var1_1, label);
        if (this.myCurrentLabel == null) {
            return;
        }
        if (this.myCurrentLine == -1) {
            return;
        }
        this.myLabelsWithoutLines.put((Label)var2_2, this.myCurrentLine);
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitMethodInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor, isInterface);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitLdcInsn(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitInsn((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitTypeInsn((int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitInvokeDynamicInsn((String)var1_1, (String)var2_2, (Handle)var3_3, bootstrapMethodArguments);
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int varIndex, int increment) {
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitIincInsn((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitFieldInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor);
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int varIndex) {
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitVarInsn((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        this.checkHasLineIfAfterJump();
        super.visitIntInsn((int)var1_1, (int)var2_2);
    }
}

