/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.event.InputEvent;
import org.assertj.swing.dependency.jsr305.Nonnull;

final class InputModifiers {
    static int unify(int ... modifiers) {
        if (modifiers == null) {
            return 0;
        }
        int unified = 0;
        if (modifiers.length > 0) {
            unified = modifiers[0];
            for (int i = 1; i < modifiers.length; ++i) {
                unified |= modifiers[i];
            }
        }
        return unified;
    }

    static boolean isShiftDown(int modifiers) {
        return (modifiers & 1) != 0;
    }

    static boolean isControlDown(int modifiers) {
        return (modifiers & 2) != 0;
    }

    static boolean isMetaDown(int modifiers) {
        return (modifiers & 4) != 0;
    }

    static boolean isAltDown(int modifiers) {
        return (modifiers & 8) != 0;
    }

    static boolean isAltGraphDown(int modifiers) {
        return (modifiers & 0x20) != 0;
    }

    static boolean modifiersMatch(@Nonnull InputEvent e, int modifiers) {
        if (e.isAltDown() != InputModifiers.isAltDown(modifiers)) {
            return false;
        }
        if (e.isAltGraphDown() != InputModifiers.isAltGraphDown(modifiers)) {
            return false;
        }
        if (e.isControlDown() != InputModifiers.isControlDown(modifiers)) {
            return false;
        }
        if (e.isMetaDown() != InputModifiers.isMetaDown(modifiers)) {
            return false;
        }
        return e.isShiftDown() == InputModifiers.isShiftDown(modifiers);
    }

    private InputModifiers() {
    }
}

