/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.execution.configurations.ConfigurationWithAlternativeJre;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.MisConfiguredExceptionKt;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.settings.JVMProfilerConfigurable;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a\f\u0010\r\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a8\u0006\u000e"}, d2={"validateAgentPath", "Lcom/intellij/profiler/MisConfiguredException;", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "isOpenJ9", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "homePath", "unquote", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nAsyncProfilerConfigurationExtensionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncProfilerConfigurationExtensionBase.kt\ncom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBaseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,190:1\n1#2:191\n36#3,2:192\n*S KotlinDebug\n*F\n+ 1 AsyncProfilerConfigurationExtensionBase.kt\ncom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBaseKt\n*L\n183#1:192,2\n*E\n"})
public final class AsyncProfilerConfigurationExtensionBaseKt {
    @Nullable
    public static final MisConfiguredException validateAgentPath(@NotNull String path, @NotNull Project project, @NotNull ProfilerConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return MisConfiguredExceptionKt.validateLocalPath((String)path, (String)"profiler agent", (Project)project, JVMProfilerConfigurable.class, arg_0 -> AsyncProfilerConfigurationExtensionBaseKt.validateAgentPath$lambda$0(state, arg_0));
    }

    private static final boolean isOpenJ9(RunConfigurationBase<?> configuration) {
        boolean bl;
        String sdkPath = null;
        if (configuration instanceof ConfigurationWithAlternativeJre && ((ConfigurationWithAlternativeJre)configuration).isAlternativeJrePathEnabled()) {
            String string = ((ConfigurationWithAlternativeJre)configuration).getAlternativeJrePath();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                Sdk sdk = ProjectJdkTable.getInstance().findJdk(it);
                v2 = sdk != null ? sdk.getHomePath() : null;
            } else {
                v2 = sdkPath = null;
            }
        }
        if (sdkPath == null) {
            Sdk sdk = ProjectRootManager.getInstance((Project)configuration.getProject()).getProjectSdk();
            sdkPath = sdk != null ? sdk.getHomePath() : null;
        }
        String string = sdkPath;
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            bl = AsyncProfilerConfigurationExtensionBaseKt.isOpenJ9(sdkPath);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isOpenJ9(String homePath) {
        String[] stringArray = new String[]{"release"};
        Path releaseFile = Paths.get(homePath, stringArray);
        if (Files.isRegularFile(releaseFile, new LinkOption[0])) {
            try {
                Properties p = new Properties();
                Closeable closeable = Files.newInputStream(releaseFile, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    InputStream stream = (InputStream)closeable;
                    boolean bl = false;
                    p.load(stream);
                    String string = p.getProperty("JVM_VARIANT");
                    if (string == null || (string = AsyncProfilerConfigurationExtensionBaseKt.unquote(string)) == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    String variant = string;
                    boolean bl3 = StringsKt.equals((String)"OpenJ9", (String)variant, (boolean)true);
                    return bl3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable e) {
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info(((Object)releaseFile).toString(), e);
            }
        }
        return false;
    }

    private static final String unquote(String $this$unquote) {
        String string;
        if ($this$unquote.length() >= 2 && $this$unquote.charAt(0) == '\"') {
            String string2 = $this$unquote.substring(1, $this$unquote.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = $this$unquote;
        }
        return string;
    }

    private static final Unit validateAgentPath$lambda$0(ProfilerConfigurationState $state, Configurable it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JVMProfilerConfigurable jVMProfilerConfigurable = it instanceof JVMProfilerConfigurable ? (JVMProfilerConfigurable)it : null;
            if (jVMProfilerConfigurable == null || (jVMProfilerConfigurable = jVMProfilerConfigurable.getComponent()) == null) break block0;
            jVMProfilerConfigurable.selectNodeInTree($state);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isOpenJ9(RunConfigurationBase configuration) {
        return AsyncProfilerConfigurationExtensionBaseKt.isOpenJ9(configuration);
    }
}

