/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxWithEditableItem;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.validation.CellValidation;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmCriteria;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleJvmVendorUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u000278B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000204J\u0006\u00106\u001a\u000204R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0016\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010#\u001a\u0004\u0018\u00010\u00102\b\u0010\"\u001a\u0004\u0018\u00010\u00108G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R(\u0010(\u001a\u0004\u0018\u00010\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u00128G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0016\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100.X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120.X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0017\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView;", "Ljavax/swing/JPanel;", "criteria", "Lorg/jetbrains/plugins/gradle/service/execution/GradleDaemonJvmCriteria;", "versionsDropdownList", "", "", "vendorDropdownList", "Lorg/gradle/internal/jvm/inspection/JvmVendor$KnownJvmVendor;", "displayAdvancedSettings", "", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/plugins/gradle/service/execution/GradleDaemonJvmCriteria;Ljava/util/List;Ljava/util/List;ZLcom/intellij/openapi/Disposable;)V", "initialVersion", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem;", "initialVendor", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem;", "initialCriteria", "getInitialCriteria", "()Lorg/jetbrains/plugins/gradle/service/execution/GradleDaemonJvmCriteria;", "isValidVersion", "()Z", "isValidVendor", "versionModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "getVersionModel", "()Lcom/intellij/ui/CollectionComboBoxModel;", "vendorModel", "getVendorModel", "versionRenderer", "Ljavax/swing/ListCellRenderer;", "vendorRenderer", "value", "selectedVersion", "getSelectedVersion", "()Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem;", "setSelectedVersion", "(Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem;)V", "selectedVendor", "getSelectedVendor", "()Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem;", "setSelectedVendor", "(Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem;)V", "versionComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "vendorComboBox", "component", "Lcom/intellij/openapi/ui/DialogPanel;", "isModified", "applySelection", "", "resetSelection", "validateSelection", "VersionItem", "VendorItem", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleDaemonJvmCriteriaView
extends JPanel {
    @NotNull
    private final List<Integer> versionsDropdownList;
    @NotNull
    private final List<JvmVendor.KnownJvmVendor> vendorDropdownList;
    private final boolean displayAdvancedSettings;
    @Nullable
    private VersionItem initialVersion;
    @Nullable
    private VendorItem initialVendor;
    @VisibleForTesting
    @NotNull
    private final CollectionComboBoxModel<VersionItem> versionModel;
    @VisibleForTesting
    @NotNull
    private final CollectionComboBoxModel<VendorItem> vendorModel;
    @NotNull
    private final ListCellRenderer<VersionItem> versionRenderer;
    @NotNull
    private final ListCellRenderer<VendorItem> vendorRenderer;
    private ComboBox<VersionItem> versionComboBox;
    private ComboBox<VendorItem> vendorComboBox;
    @NotNull
    private final DialogPanel component;

    /*
     * WARNING - void declaration
     */
    public GradleDaemonJvmCriteriaView(@NotNull GradleDaemonJvmCriteria criteria, @NotNull List<Integer> versionsDropdownList, @NotNull List<? extends JvmVendor.KnownJvmVendor> vendorDropdownList, boolean displayAdvancedSettings, @NotNull Disposable disposable) {
        void $this$vendorModel_u24lambda_u247;
        CollectionComboBoxModel $this$versionModel_u24lambda_u246;
        JvmVendor.KnownJvmVendor knownVendor;
        VendorItem vendorItem;
        Integer knownVersion;
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        Intrinsics.checkNotNullParameter(versionsDropdownList, (String)"versionsDropdownList");
        Intrinsics.checkNotNullParameter(vendorDropdownList, (String)"vendorDropdownList");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super((LayoutManager)new VerticalLayout(0));
        this.versionsDropdownList = versionsDropdownList;
        this.vendorDropdownList = vendorDropdownList;
        this.displayAdvancedSettings = displayAdvancedSettings;
        String version = criteria.getVersion();
        this.initialVersion = version != null ? ((knownVersion = StringsKt.toIntOrNull((String)version)) == null ? (VersionItem)new VersionItem.Custom(version) : (this.versionsDropdownList.contains(knownVersion) ? (VersionItem)new VersionItem.Default(knownVersion) : (VersionItem)new VersionItem.Custom(version))) : null;
        JvmVendor vendor = criteria.getVendor();
        if (vendor == null) {
            vendorItem = VendorItem.Any.INSTANCE;
        } else {
            knownVendor = vendor.getKnownVendor();
            if (this.vendorDropdownList.contains(knownVendor)) {
                Intrinsics.checkNotNull((Object)knownVendor);
                vendorItem = new VendorItem.Default(knownVendor);
            } else {
                String string = vendor.getRawVendor();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawVendor(...)");
                vendorItem = new VendorItem.Custom(string);
            }
        }
        this.initialVendor = vendorItem;
        CollectionComboBoxModel collectionComboBoxModel = new CollectionComboBoxModel();
        knownVendor = collectionComboBoxModel;
        GradleDaemonJvmCriteriaView gradleDaemonJvmCriteriaView = this;
        boolean bl = false;
        Iterator<Object> iterator = CollectionsKt.reversed((Iterable)this.versionsDropdownList).iterator();
        while (iterator.hasNext()) {
            int version2 = ((Number)iterator.next()).intValue();
            $this$versionModel_u24lambda_u246.add((Object)new VersionItem.Default(version2));
        }
        gradleDaemonJvmCriteriaView.versionModel = collectionComboBoxModel;
        $this$versionModel_u24lambda_u246 = collectionComboBoxModel = new CollectionComboBoxModel();
        gradleDaemonJvmCriteriaView = this;
        boolean bl2 = false;
        $this$vendorModel_u24lambda_u247.add((Object)VendorItem.Any.INSTANCE);
        $this$vendorModel_u24lambda_u247.add((Object)VendorItem.SelectCustom.INSTANCE);
        for (JvmVendor.KnownJvmVendor vendor2 : this.vendorDropdownList) {
            $this$vendorModel_u24lambda_u247.add((Object)new VendorItem.Default(vendor2));
        }
        gradleDaemonJvmCriteriaView.vendorModel = collectionComboBoxModel;
        this.versionRenderer = BuilderKt.textListCellRenderer(GradleDaemonJvmCriteriaView::versionRenderer$lambda$8);
        this.vendorRenderer = BuilderKt.textListCellRenderer(GradleDaemonJvmCriteriaView::vendorRenderer$lambda$9);
        this.component = com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> GradleDaemonJvmCriteriaView.component$lambda$23(this, arg_0));
        this.component.registerValidators(disposable);
        this.component.validateAll();
        this.add((Component)this.component);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GradleDaemonJvmCriteria getInitialCriteria() {
        Object object;
        void vendor;
        String string;
        Object version = this.initialVersion;
        boolean bl = false;
        Object object2 = version;
        if (object2 == null) {
            string = null;
        } else if (object2 instanceof VersionItem.Default) {
            string = String.valueOf(((VersionItem.Default)version).getVersion());
        } else if (object2 instanceof VersionItem.Custom) {
            string = StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)((VersionItem.Custom)version).getValue())).toString(), (boolean)false, (int)1, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        version = this.initialVendor;
        String string2 = string;
        boolean bl2 = false;
        object2 = vendor;
        if (object2 == null) {
            object = null;
        } else if (Intrinsics.areEqual((Object)object2, (Object)VendorItem.Any.INSTANCE)) {
            object = null;
        } else if (Intrinsics.areEqual((Object)object2, (Object)VendorItem.SelectCustom.INSTANCE)) {
            object = null;
        } else if (object2 instanceof VendorItem.Default) {
            object = ((VendorItem.Default)vendor).getVendor().asJvmVendor();
        } else if (object2 instanceof VendorItem.Custom) {
            String string3 = StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)((VendorItem.Custom)vendor).getValue())).toString(), (boolean)false, (int)1, null);
            object = string3 != null ? GradleJvmVendorUtil.toJvmVendor(string3) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JvmVendor jvmVendor = object;
        String string4 = string2;
        return new GradleDaemonJvmCriteria(string4, jvmVendor);
    }

    @VisibleForTesting
    public final boolean isValidVersion() {
        boolean bl;
        VersionItem version = this.getSelectedVersion();
        boolean bl2 = false;
        VersionItem versionItem = version;
        if (versionItem == null) {
            bl = false;
        } else if (versionItem instanceof VersionItem.Default) {
            bl = true;
        } else if (versionItem instanceof VersionItem.Custom) {
            String versionName = ((Object)StringsKt.trim((CharSequence)((VersionItem.Custom)version).getValue())).toString();
            boolean bl3 = false;
            bl = StringsKt.toIntOrNull((String)versionName) != null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @VisibleForTesting
    public final boolean isValidVendor() {
        boolean bl;
        VendorItem vendor = this.getSelectedVendor();
        boolean bl2 = false;
        VendorItem vendorItem = vendor;
        if (vendorItem == null) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)vendorItem, (Object)VendorItem.Any.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)vendorItem, (Object)VendorItem.SelectCustom.INSTANCE)) {
            bl = false;
        } else if (vendorItem instanceof VendorItem.Default) {
            bl = true;
        } else if (vendorItem instanceof VendorItem.Custom) {
            String vendorName = ((Object)StringsKt.trim((CharSequence)((VendorItem.Custom)vendor).getValue())).toString();
            boolean bl3 = false;
            bl = ((CharSequence)vendorName).length() > 0 && !StringsKt.contains$default((CharSequence)vendorName, (CharSequence)" ", (boolean)false, (int)2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final CollectionComboBoxModel<VersionItem> getVersionModel() {
        return this.versionModel;
    }

    @NotNull
    public final CollectionComboBoxModel<VendorItem> getVendorModel() {
        return this.vendorModel;
    }

    @VisibleForTesting
    @Nullable
    public final VersionItem getSelectedVersion() {
        Object object;
        ComboBox<VersionItem> comboBox = this.versionComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"versionComboBox");
            comboBox = null;
        }
        return (object = comboBox.getSelectedItem()) instanceof VersionItem ? (VersionItem)object : null;
    }

    @VisibleForTesting
    public final void setSelectedVersion(@Nullable VersionItem value) {
        ComboBox<VersionItem> comboBox = this.versionComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"versionComboBox");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)value);
    }

    @VisibleForTesting
    @Nullable
    public final VendorItem getSelectedVendor() {
        Object object;
        ComboBox<VendorItem> comboBox = this.vendorComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vendorComboBox");
            comboBox = null;
        }
        return (object = comboBox.getSelectedItem()) instanceof VendorItem ? (VendorItem)object : null;
    }

    @VisibleForTesting
    public final void setSelectedVendor(@Nullable VendorItem value) {
        ComboBox<VendorItem> comboBox = this.vendorComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vendorComboBox");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)value);
    }

    public final boolean isModified() {
        return this.component.isModified();
    }

    public final void applySelection() {
        this.component.apply();
    }

    public final void resetSelection() {
        this.component.reset();
    }

    public final void validateSelection() throws ConfigurationException {
        if (!this.isValidVersion()) {
            throw new ConfigurationException(GradleBundle.message("gradle.settings.text.daemon.toolchain.version.error", new Object[0]));
        }
        if (!this.isValidVendor()) {
            throw new ConfigurationException(GradleBundle.message("gradle.settings.text.daemon.toolchain.vendor.error", new Object[0]));
        }
    }

    private static final String versionRenderer$lambda$8(VersionItem versionItem) {
        String string;
        VersionItem versionItem2 = versionItem;
        if (versionItem2 == null) {
            string = GradleBundle.message("gradle.settings.text.daemon.toolchain.version.undefined", new Object[0]);
        } else if (versionItem2 instanceof VersionItem.Default) {
            string = String.valueOf(((VersionItem.Default)versionItem).getVersion());
        } else if (versionItem2 instanceof VersionItem.Custom) {
            string = ((VersionItem.Custom)versionItem).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String vendorRenderer$lambda$9(VendorItem vendorItem) {
        String string;
        VendorItem vendorItem2 = vendorItem;
        if (vendorItem2 == null) {
            string = GradleBundle.message("gradle.settings.text.daemon.toolchain.vendor.any", new Object[0]);
        } else if (Intrinsics.areEqual((Object)vendorItem2, (Object)VendorItem.Any.INSTANCE)) {
            string = GradleBundle.message("gradle.settings.text.daemon.toolchain.vendor.any", new Object[0]);
        } else if (Intrinsics.areEqual((Object)vendorItem2, (Object)VendorItem.SelectCustom.INSTANCE)) {
            string = GradleBundle.message("gradle.settings.text.daemon.toolchain.vendor.custom", new Object[0]);
        } else if (vendorItem2 instanceof VendorItem.Default) {
            string = ((VendorItem.Default)vendorItem).getVendor().asJvmVendor().getDisplayName();
        } else if (vendorItem2 instanceof VendorItem.Custom) {
            string = ((VendorItem.Custom)vendorItem).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final Unit component$lambda$23$lambda$11$lambda$10(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        $this$applyToComponent.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$23$lambda$11(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GradleBundle.message("gradle.settings.text.daemon.toolchain.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).applyToComponent(GradleDaemonJvmCriteriaView::component$lambda$23$lambda$11$lambda$10);
        return Unit.INSTANCE;
    }

    private static final boolean component$lambda$23$lambda$15$lambda$14$lambda$12(GradleDaemonJvmCriteriaView this$0) {
        return !this$0.isValidVersion();
    }

    private static final boolean component$lambda$23$lambda$15$lambda$14$lambda$13(GradleDaemonJvmCriteriaView this$0) {
        return !this$0.isValidVersion();
    }

    private static final Unit component$lambda$23$lambda$15$lambda$14(GradleDaemonJvmCriteriaView this$0, CellValidation $this$cellValidation, ComboBoxWithEditableItem it) {
        Intrinsics.checkNotNullParameter((Object)$this$cellValidation, (String)"$this$cellValidation");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = GradleBundle.message("gradle.settings.text.daemon.toolchain.version.invalid", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CellValidation.addInputRule$default((CellValidation)$this$cellValidation, (String)string, null, () -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$15$lambda$14$lambda$12(this$0), (int)2, null);
        String string2 = GradleBundle.message("gradle.settings.text.daemon.toolchain.version.invalid", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CellValidation.addApplyRule$default((CellValidation)$this$cellValidation, (String)string2, null, () -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$15$lambda$14$lambda$13(this$0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$23$lambda$15(GradleDaemonJvmCriteriaView this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.versionComboBox = (ComboBox)ComboBoxKt.bindItem((Cell)ComboBoxKt.columns((Cell)$this$row.cell((JComponent)new ComboBoxWithEditableItem((ComboBoxModel)this$0.versionModel, this$0.versionRenderer)), (int)18), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0){

            public Object get() {
                return GradleDaemonJvmCriteriaView.access$getInitialVersion$p((GradleDaemonJvmCriteriaView)this.receiver);
            }

            public void set(Object value) {
                GradleDaemonJvmCriteriaView.access$setInitialVersion$p((GradleDaemonJvmCriteriaView)this.receiver, (VersionItem)value);
            }
        })).cellValidation((arg_0, arg_1) -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$15$lambda$14(this$0, arg_0, arg_1)).getComponent();
        return Unit.INSTANCE;
    }

    private static final boolean component$lambda$23$lambda$22$lambda$19$lambda$18$lambda$16(GradleDaemonJvmCriteriaView this$0) {
        return !this$0.isValidVendor();
    }

    private static final boolean component$lambda$23$lambda$22$lambda$19$lambda$18$lambda$17(GradleDaemonJvmCriteriaView this$0) {
        return !this$0.isValidVendor();
    }

    private static final Unit component$lambda$23$lambda$22$lambda$19$lambda$18(GradleDaemonJvmCriteriaView this$0, CellValidation $this$cellValidation, ComboBoxWithEditableItem it) {
        Intrinsics.checkNotNullParameter((Object)$this$cellValidation, (String)"$this$cellValidation");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = GradleBundle.message("gradle.settings.text.daemon.toolchain.vendor.invalid", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CellValidation.addInputRule$default((CellValidation)$this$cellValidation, (String)string, null, () -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$22$lambda$19$lambda$18$lambda$16(this$0), (int)2, null);
        String string2 = GradleBundle.message("gradle.settings.text.daemon.toolchain.vendor.invalid", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CellValidation.addApplyRule$default((CellValidation)$this$cellValidation, (String)string2, null, () -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$22$lambda$19$lambda$18$lambda$17(this$0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$23$lambda$22$lambda$19(GradleDaemonJvmCriteriaView this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.vendorComboBox = (ComboBox)ComboBoxKt.bindItem((Cell)ComboBoxKt.columns((Cell)$this$row.cell((JComponent)new ComboBoxWithEditableItem((ComboBoxModel)this$0.vendorModel, this$0.vendorRenderer)), (int)18), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0){

            public Object get() {
                return GradleDaemonJvmCriteriaView.access$getInitialVendor$p((GradleDaemonJvmCriteriaView)this.receiver);
            }

            public void set(Object value) {
                GradleDaemonJvmCriteriaView.access$setInitialVendor$p((GradleDaemonJvmCriteriaView)this.receiver, (VendorItem)value);
            }
        })).cellValidation((arg_0, arg_1) -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$22$lambda$19$lambda$18(this$0, arg_0, arg_1)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$23$lambda$22$lambda$21$lambda$20(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        $this$applyToComponent.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$23$lambda$22$lambda$21(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GradleBundle.message("gradle.settings.text.daemon.toolchain.vendor.hint", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).applyToComponent(GradleDaemonJvmCriteriaView::component$lambda$23$lambda$22$lambda$21$lambda$20);
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$23$lambda$22(GradleDaemonJvmCriteriaView this$0, Panel $this$collapsibleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
        String string = GradleBundle.message("gradle.settings.text.daemon.toolchain.vendor", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$collapsibleGroup.row(string, arg_0 -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$22$lambda$19(this$0, arg_0));
        Panel.row$default((Panel)$this$collapsibleGroup, null, GradleDaemonJvmCriteriaView::component$lambda$23$lambda$22$lambda$21, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$23(GradleDaemonJvmCriteriaView this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, GradleDaemonJvmCriteriaView::component$lambda$23$lambda$11, (int)1, null);
        String string = GradleBundle.message("gradle.settings.text.daemon.toolchain.version", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$15(this$0, arg_0));
        String string2 = ApplicationBundle.message((String)"title.advanced.settings", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Panel.collapsibleGroup$default((Panel)$this$panel, (String)string2, (boolean)false, arg_0 -> GradleDaemonJvmCriteriaView.component$lambda$23$lambda$22(this$0, arg_0), (int)2, null).topGap(TopGap.NONE).visible(this$0.displayAdvancedSettings);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ VersionItem access$getInitialVersion$p(GradleDaemonJvmCriteriaView $this) {
        return $this.initialVersion;
    }

    public static final /* synthetic */ void access$setInitialVersion$p(GradleDaemonJvmCriteriaView $this, VersionItem versionItem) {
        $this.initialVersion = versionItem;
    }

    public static final /* synthetic */ VendorItem access$getInitialVendor$p(GradleDaemonJvmCriteriaView $this) {
        return $this.initialVendor;
    }

    public static final /* synthetic */ void access$setInitialVendor$p(GradleDaemonJvmCriteriaView $this, VendorItem vendorItem) {
        $this.initialVendor = vendorItem;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem;", "", "Any", "SelectCustom", "Default", "Custom", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$Any;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$Custom;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$Default;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$SelectCustom;", "intellij.gradle"})
    @VisibleForTesting
    public static interface VendorItem {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$Any;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem;", "<init>", "()V", "intellij.gradle"})
        public static final class Any
        implements VendorItem {
            @NotNull
            public static final Any INSTANCE = new Any();

            private Any() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\t\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$Custom;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem;", "Lcom/intellij/openapi/ui/ComboBoxWithEditableItem$EditableItem;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "valueOf", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "intellij.gradle"})
        public static final class Custom
        implements VendorItem,
        ComboBoxWithEditableItem.EditableItem {
            @NotNull
            private final String value;

            public Custom(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            @NotNull
            public Custom valueOf(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Custom(value);
            }

            @NotNull
            public String toString() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final Custom copy(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Custom(value);
            }

            public static /* synthetic */ Custom copy$default(Custom custom, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = custom.value;
                }
                return custom.copy(string);
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Custom)) {
                    return false;
                }
                Custom custom = (Custom)other;
                return Intrinsics.areEqual((Object)this.value, (Object)custom.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$Default;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem;", "vendor", "Lorg/gradle/internal/jvm/inspection/JvmVendor$KnownJvmVendor;", "<init>", "(Lorg/gradle/internal/jvm/inspection/JvmVendor$KnownJvmVendor;)V", "getVendor", "()Lorg/gradle/internal/jvm/inspection/JvmVendor$KnownJvmVendor;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.gradle"})
        public static final class Default
        implements VendorItem {
            @NotNull
            private final JvmVendor.KnownJvmVendor vendor;

            public Default(@NotNull JvmVendor.KnownJvmVendor vendor) {
                Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
                this.vendor = vendor;
            }

            @NotNull
            public final JvmVendor.KnownJvmVendor getVendor() {
                return this.vendor;
            }

            @NotNull
            public final JvmVendor.KnownJvmVendor component1() {
                return this.vendor;
            }

            @NotNull
            public final Default copy(@NotNull JvmVendor.KnownJvmVendor vendor) {
                Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
                return new Default(vendor);
            }

            public static /* synthetic */ Default copy$default(Default default_, JvmVendor.KnownJvmVendor knownJvmVendor, int n, Object object) {
                if ((n & 1) != 0) {
                    knownJvmVendor = default_.vendor;
                }
                return default_.copy(knownJvmVendor);
            }

            @NotNull
            public String toString() {
                return "Default(vendor=" + this.vendor + ")";
            }

            public int hashCode() {
                return this.vendor.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Default)) {
                    return false;
                }
                Default default_ = (Default)other;
                return this.vendor == default_.vendor;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$SelectCustom;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem;", "Lcom/intellij/openapi/ui/ComboBoxWithEditableItem$SelectEditableItem;", "<init>", "()V", "createItem", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VendorItem$Custom;", "intellij.gradle"})
        public static final class SelectCustom
        implements VendorItem,
        ComboBoxWithEditableItem.SelectEditableItem {
            @NotNull
            public static final SelectCustom INSTANCE = new SelectCustom();

            private SelectCustom() {
            }

            @NotNull
            public Custom createItem() {
                return new Custom("");
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem;", "", "Default", "Custom", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem$Custom;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem$Default;", "intellij.gradle"})
    @VisibleForTesting
    public static interface VersionItem {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\t\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem$Custom;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem;", "Lcom/intellij/openapi/ui/ComboBoxWithEditableItem$EditableItem;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "valueOf", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "intellij.gradle"})
        public static final class Custom
        implements VersionItem,
        ComboBoxWithEditableItem.EditableItem {
            @NotNull
            private final String value;

            public Custom(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            @NotNull
            public Custom valueOf(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Custom(value);
            }

            @NotNull
            public String toString() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final Custom copy(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Custom(value);
            }

            public static /* synthetic */ Custom copy$default(Custom custom, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = custom.value;
                }
                return custom.copy(string);
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Custom)) {
                    return false;
                }
                Custom custom = (Custom)other;
                return Intrinsics.areEqual((Object)this.value, (Object)custom.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem$Default;", "Lorg/jetbrains/plugins/gradle/service/settings/GradleDaemonJvmCriteriaView$VersionItem;", "version", "", "<init>", "(I)V", "getVersion", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.gradle"})
        public static final class Default
        implements VersionItem {
            private final int version;

            public Default(int version) {
                this.version = version;
            }

            public final int getVersion() {
                return this.version;
            }

            public final int component1() {
                return this.version;
            }

            @NotNull
            public final Default copy(int version) {
                return new Default(version);
            }

            public static /* synthetic */ Default copy$default(Default default_, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = default_.version;
                }
                return default_.copy(n);
            }

            @NotNull
            public String toString() {
                return "Default(version=" + this.version + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.version);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Default)) {
                    return false;
                }
                Default default_ = (Default)other;
                return this.version == default_.version;
            }
        }
    }
}

