//===----------------------------------------------------------------------===//
// Copyright © 2024 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//
amends ".../pkl-project-commons/packages/pkl.impl.circleci/PklCI.pkl"

prb = buildWorkflow

main = buildWorkflow

release {
  jobs {
    new {
      ["do-release"] {
        context {
          "pkl-npm-release"
        }
      }
    }
    new {
      ["github-release"] {
        requires {
          "do-release"
        }
        context {
          "pkl-github-release"
        }
      }
    }
  }
}

jobs {
  ["build"] {
    docker {
      new {
        image = "cimg/node:18.19.0"
      }
    }
    steps {
      "checkout"
      new RunStep { command = "npm ci" }
      new RunStep { command = "npm test" }
    }
  }
  ["do-release"] {
    docker {
      new {
        image = "cimg/node:18.19.0"
      }
    }
    steps {
      "checkout"
      new RunStep { command = "npm ci" }
      new RunStep { command = "npm test" }
      new RunStep {
        name = "Authenticate with registry"
        command = #"echo "//registry.npmjs.org/:_authToken=$NPM_TOKEN" > .npmrc"#
      }
      new RunStep {
        name = "Publish to NPM"
        command = "npm publish"
      }
    }
  }
  ["github-release"] {
    docker {
      new { image = "maniator/gh:v2.40.1" }
    }
    steps {
      new RunStep {
        name = "Creating GitHub release"
        command = #"""
          gh release create "${CIRCLE_TAG}" \
            --title "${CIRCLE_TAG}" \
            --target "${CIRCLE_SHA1}" \
            --verify-tag \
            --notes "Release version ${VERSION}" \
            --repo "${CIRCLE_PROJECT_USERNAME}/${CIRCLE_PROJECT_REPONAME}"
          """#
      }
    }
  }
}

local buildWorkflow = new Workflow {
  jobs {
    "build"
  }
}
