// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"
#include "Rivet/Projections/ZFinder.hh"

namespace Rivet {


  /// @brief D0 Run II Z \f$ p_\perp \f$ differential cross-section shape
  ///
  /// @author Andy Buckley
  /// @author Gavin Hesketh
  /// @author Frank Siegert
  class D0_2008_S7554427 : public Analysis {
  public:

    RIVET_DEFAULT_ANALYSIS_CTOR(D0_2008_S7554427);


    /// @name Analysis methods
    /// @{

    /// Book histograms
    void init() {
      FinalState fs;
      ZFinder zfinder(fs, Cuts::open(), PID::ELECTRON,
                      40*GeV, 200*GeV, 0.2, ZFinder::ClusterPhotons::NODECAY, ZFinder::AddPhotons::YES);
      declare(zfinder, "ZFinder");

      book(_h_ZpT         ,1, 1, 1);
      book(_h_forward_ZpT ,3, 1, 1);
    }


    /// Do the analysis
    void analyze(const Event& e) {
      const ZFinder& zfinder = apply<ZFinder>(e, "ZFinder");
      if (zfinder.bosons().size() != 1) {
        MSG_DEBUG("No unique lepton pair found.");
        vetoEvent;
      }
      const double yZ = fabs(zfinder.bosons()[0].rapidity());
      const double pTZ = zfinder.bosons()[0].pT();
      _h_ZpT->fill(pTZ);
      if (yZ > 2) _h_forward_ZpT->fill(pTZ);
    }


    // Finalize
    void finalize() {
      normalize(_h_ZpT);
      normalize(_h_forward_ZpT);
    }

    /// @}


  private:

    /// @name Histograms
    /// @{
    Histo1DPtr _h_ZpT, _h_forward_ZpT;
    /// @}

  };



  RIVET_DECLARE_ALIASED_PLUGIN(D0_2008_S7554427, D0_2008_I769689);

}
