// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetBucketAcl`](crate::operation::get_bucket_acl::builders::GetBucketAclFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_bucket_acl::builders::GetBucketAclFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_bucket_acl::builders::GetBucketAclFluentBuilder::set_bucket):<br>required: **true**<br><p>Specifies the S3 bucket whose ACL is being requested.</p> <p>When you use this API operation with an access point, provide the alias of the access point in place of the bucket name.</p> <p>When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error code <code>InvalidAccessPointAliasError</code> is returned. For more information about <code>InvalidAccessPointAliasError</code>, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_bucket_acl::builders::GetBucketAclFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_bucket_acl::builders::GetBucketAclFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`GetBucketAclOutput`](crate::operation::get_bucket_acl::GetBucketAclOutput) with field(s):
    ///   - [`owner(Option<Owner>)`](crate::operation::get_bucket_acl::GetBucketAclOutput::owner): <p>Container for the bucket owner's display name and ID.</p>
    ///   - [`grants(Option<Vec::<Grant>>)`](crate::operation::get_bucket_acl::GetBucketAclOutput::grants): <p>A list of grants.</p>
    /// - On failure, responds with [`SdkError<GetBucketAclError>`](crate::operation::get_bucket_acl::GetBucketAclError)
    pub fn get_bucket_acl(&self) -> crate::operation::get_bucket_acl::builders::GetBucketAclFluentBuilder {
        crate::operation::get_bucket_acl::builders::GetBucketAclFluentBuilder::new(self.handle.clone())
    }
}
