/*
    SPDX-FileCopyrightText: Milian Wolff <mail@milianw.de>

    SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
*/

#include "quickopentestbase.h"

#include <tests/autotestshell.h>
#include <tests/testcore.h>
#include <tests/testplugincontroller.h>
#include <tests/testproject.h>
#include <interfaces/idocumentcontroller.h>
#include <language/interfaces/quickopenfilter.h>

using namespace KDevelop;

QuickOpenTestBase::QuickOpenTestBase(Core::Setup setup_, QObject* parent)
    : QObject(parent)
    , core(nullptr)
    , setup(setup_)
    , projectController(nullptr)
{
    qRegisterMetaType<QModelIndex>("QModelIndex");
}

void QuickOpenTestBase::initTestCase()
{
    AutoTestShell::init();
    core = new TestCore;
    auto* pluginController = new TestPluginController(core);
    core->setPluginController(pluginController);
    TestCore::initialize(setup);
    projectController = new TestProjectController(core);
    delete core->projectController();
    core->setProjectController(projectController);
}

void QuickOpenTestBase::cleanupTestCase()
{
    TestCore::shutdown();
}

void QuickOpenTestBase::cleanup()
{
    projectController->closeAllProjects();
    core->documentController()->closeAllDocuments();
}

TestProject* getProjectWithFiles(int files, const Path& path)
{
    auto* project = new TestProject(path);
    auto* foo = createChild<ProjectFolderItem>(project->projectItem(), QStringLiteral("foo"));
    auto* bar = createChild<ProjectFolderItem>(foo, QStringLiteral("bar"));
    for (int i = 0; i < files; ++i) {
        createChild<ProjectFileItem>(bar, QString::number(i) + QLatin1String(".txt"));
    }

    return project;
}

QStringList items(const ProjectFileDataProvider& provider)
{
    QStringList list;
    for (uint i = 0; i < provider.itemCount(); ++i) {
        list << provider.data(i)->text();
    }

    return list;
}

#include "moc_quickopentestbase.cpp"
