/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	v1alpha2 "kubevirt.io/api/instancetype/v1alpha2"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachineInstancetypesGetter has a method to return a VirtualMachineInstancetypeInterface.
// A group's client should implement this interface.
type VirtualMachineInstancetypesGetter interface {
	VirtualMachineInstancetypes(namespace string) VirtualMachineInstancetypeInterface
}

// VirtualMachineInstancetypeInterface has methods to work with VirtualMachineInstancetype resources.
type VirtualMachineInstancetypeInterface interface {
	Create(ctx context.Context, virtualMachineInstancetype *v1alpha2.VirtualMachineInstancetype, opts v1.CreateOptions) (*v1alpha2.VirtualMachineInstancetype, error)
	Update(ctx context.Context, virtualMachineInstancetype *v1alpha2.VirtualMachineInstancetype, opts v1.UpdateOptions) (*v1alpha2.VirtualMachineInstancetype, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha2.VirtualMachineInstancetype, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha2.VirtualMachineInstancetypeList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.VirtualMachineInstancetype, err error)
	VirtualMachineInstancetypeExpansion
}

// virtualMachineInstancetypes implements VirtualMachineInstancetypeInterface
type virtualMachineInstancetypes struct {
	*gentype.ClientWithList[*v1alpha2.VirtualMachineInstancetype, *v1alpha2.VirtualMachineInstancetypeList]
}

// newVirtualMachineInstancetypes returns a VirtualMachineInstancetypes
func newVirtualMachineInstancetypes(c *InstancetypeV1alpha2Client, namespace string) *virtualMachineInstancetypes {
	return &virtualMachineInstancetypes{
		gentype.NewClientWithList[*v1alpha2.VirtualMachineInstancetype, *v1alpha2.VirtualMachineInstancetypeList](
			"virtualmachineinstancetypes",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1alpha2.VirtualMachineInstancetype { return &v1alpha2.VirtualMachineInstancetype{} },
			func() *v1alpha2.VirtualMachineInstancetypeList { return &v1alpha2.VirtualMachineInstancetypeList{} }),
	}
}
