/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import java.util.List;
import java.util.concurrent.Flow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.AIStreamPublisher;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIBaseProperties;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClient;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionChunk;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionRequest;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionResult;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatMessage;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OpenAICompletionEngine<PROPS extends OpenAIBaseProperties>
extends BaseCompletionEngine<PROPS> {
    private final DisposableLazyValue<OpenAIClient, DBException> openAiService = new DisposableLazyValue<OpenAIClient, DBException>(){

        @NotNull
        protected OpenAIClient initialize() throws DBException {
            return OpenAICompletionEngine.this.createClient();
        }

        @Override
        protected void onDispose(@NotNull OpenAIClient disposedValue) {
            disposedValue.close();
        }
    };

    public OpenAICompletionEngine() throws DBException {
    }

    public OpenAICompletionEngine(PROPS properties) throws DBException {
        super(properties);
    }

    @Override
    @NotNull
    protected String getEngineId() {
        return "openai";
    }

    @Override
    @NotNull
    public List<AIModel> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OpenAIClient)this.openAiService.getInstance()).getModels(monitor).stream().map(model -> OpenAIModels.KNOWN_MODELS.getOrDefault(model.id(), new AIModel(model.id(), null, OpenAIModels.detectModelFeatures(model.id())))).toList();
    }

    @Override
    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        ChatCompletionResult completionResult = this.complete(monitor, request.messages());
        List<String> choices = completionResult.getChoices().stream().map(it -> it.getMessage().getContent()).toList();
        return new AIEngineResponse(choices);
    }

    @Override
    @NotNull
    public AIStreamPublisher requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        ChatCompletionRequest ccr = new ChatCompletionRequest();
        ccr.setMessages(OpenAICompletionEngine.fromMessages(request.messages()));
        ccr.setTemperature(this.temperature());
        ccr.setFrequencyPenalty(0.0);
        ccr.setPresencePenalty(0.0);
        ccr.setN(1);
        ccr.setModel(this.model());
        ccr.setStream(true);
        Flow.Publisher<ChatCompletionChunk> publisher = ((OpenAIClient)this.openAiService.getInstance()).createChatCompletionStream(monitor, ccr);
        return subscriber -> publisher.subscribe(new Flow.Subscriber<ChatCompletionChunk>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(ChatCompletionChunk item) {
                List<String> choices = item.getChoices().stream().filter(it -> it.getMessage() != null).takeWhile(it -> it.getMessage().getContent() != null).map(it -> it.getMessage().getContent()).toList();
                subscriber.onNext(new AIEngineResponseChunk(choices));
            }

            @Override
            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }

    @Override
    public int getContextWindowSize(DBRProgressMonitor monitor) throws DBException {
        Integer contextWindowSize = ((OpenAIBaseProperties)this.properties).getContextWindowSize();
        if (contextWindowSize != null) {
            return contextWindowSize;
        }
        throw new DBException("Context window size is not set for the model: " + this.model());
    }

    @Override
    public void close() throws DBException {
        this.openAiService.dispose();
    }

    @NotNull
    protected ChatCompletionResult complete(@NotNull DBRProgressMonitor monitor, @NotNull List<AIMessage> messages) throws DBException {
        ChatCompletionRequest completionRequest = new ChatCompletionRequest();
        completionRequest.setMessages(OpenAICompletionEngine.fromMessages(messages));
        completionRequest.setTemperature(this.temperature());
        completionRequest.setFrequencyPenalty(0.0);
        completionRequest.setPresencePenalty(0.0);
        completionRequest.setN(1);
        completionRequest.setModel(this.model());
        return ((OpenAIClient)this.openAiService.getInstance()).createChatCompletion(monitor, completionRequest);
    }

    @NotNull
    private static List<ChatMessage> fromMessages(@NotNull List<AIMessage> messages) {
        return messages.stream().map(m -> new ChatMessage(OpenAICompletionEngine.mapRole(m.getRole()), m.getContent())).toList();
    }

    private static String mapRole(AIMessageType role) {
        return switch (role) {
            case AIMessageType.SYSTEM -> "system";
            case AIMessageType.USER -> "user";
            case AIMessageType.ASSISTANT -> "assistant";
            default -> null;
        };
    }

    @NotNull
    protected OpenAIClient createClient() throws DBException {
        String token = ((OpenAIBaseProperties)this.properties).getToken();
        if (token == null || token.isEmpty()) {
            throw new DBException("OpenAI API token is not set");
        }
        String baseUrl = ((OpenAIBaseProperties)this.properties).getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            baseUrl = "https://api.openai.com/v1/";
        }
        return OpenAIClient.createClient(baseUrl, token);
    }

    @Nullable
    protected String model() throws DBException {
        return ((OpenAIBaseProperties)this.properties).getModel();
    }

    protected double temperature() throws DBException {
        return ((OpenAIBaseProperties)this.properties).getTemperature();
    }
}

