/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.google.common.base.Strings;
import com.intellij.diagnostic.LoadingState;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionEnvCustomizerService;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.IllegalEnvVarException;
import com.intellij.execution.Platform;
import com.intellij.execution.WorkingDirectoryNotFoundException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelNioBridgeService;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.EnvironmentRestorer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCommandLine
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance(GeneralCommandLine.class);
    private String myExePath;
    @Nullable
    private Path myWorkingDirectory;
    private final Map<String, String> myEnvParams;
    private ParentEnvironmentType myParentEnvironmentType;
    private final ParametersList myProgramParams;
    private Charset myCharset;
    private boolean myRedirectErrorStream;
    @Nullable
    private File myInputFile;
    private Map<Object, Object> myUserData;
    @Nullable
    private @Nullable Ref<@Nullable EelApi> myEelApi;
    @Nullable
    private Function<ProcessBuilder, Process> myProcessCreator;

    public GeneralCommandLine() {
        this(Collections.emptyList());
    }

    public GeneralCommandLine(String ... command) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(command));
    }

    public GeneralCommandLine(@NotNull List<String> command) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(1);
        }
        this.myEnvParams = new MyMap();
        this.myParentEnvironmentType = ParentEnvironmentType.CONSOLE;
        this.myProgramParams = new ParametersList();
        this.myCharset = GeneralCommandLine.defaultCharset();
        this.myEelApi = null;
        int size = command.size();
        if (size > 0) {
            this.setExePath(command.get(0));
            if (size > 1) {
                this.addParameters(command.subList(1, size));
            }
        }
    }

    protected GeneralCommandLine(@NotNull GeneralCommandLine original) {
        if (original == null) {
            GeneralCommandLine.$$$reportNull$$$0(2);
        }
        this.myEnvParams = new MyMap();
        this.myParentEnvironmentType = ParentEnvironmentType.CONSOLE;
        this.myProgramParams = new ParametersList();
        this.myCharset = GeneralCommandLine.defaultCharset();
        this.myEelApi = null;
        this.myExePath = original.myExePath;
        this.myWorkingDirectory = original.myWorkingDirectory;
        this.myEnvParams.putAll(original.myEnvParams);
        this.myParentEnvironmentType = original.myParentEnvironmentType;
        original.myProgramParams.copyTo(this.myProgramParams);
        this.myCharset = original.myCharset;
        this.myRedirectErrorStream = original.myRedirectErrorStream;
        this.myInputFile = original.myInputFile;
        this.myUserData = null;
        this.myProcessCreator = original.myProcessCreator;
        this.myEelApi = original.myEelApi;
    }

    private static Charset defaultCharset() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() ? EncodingManager.getInstance().getDefaultConsoleEncoding() : Charset.defaultCharset();
    }

    @NotNull
    @NlsSafe
    public String getExePath() {
        String string = this.myExePath;
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public GeneralCommandLine withExePath(@NotNull String exePath) {
        if (exePath == null) {
            GeneralCommandLine.$$$reportNull$$$0(4);
        }
        this.myExePath = exePath.trim();
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    @ApiStatus.Obsolete(since="2024.2")
    public void setExePath(@NotNull String exePath) {
        if (exePath == null) {
            GeneralCommandLine.$$$reportNull$$$0(6);
        }
        this.withExePath(exePath);
    }

    @ApiStatus.Obsolete(since="2024.2")
    public File getWorkDirectory() {
        return this.myWorkingDirectory != null ? this.myWorkingDirectory.toFile() : null;
    }

    @ApiStatus.Obsolete(since="2024.2")
    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable String path) {
        GeneralCommandLine generalCommandLine = this.withWorkingDirectory(path != null ? Path.of(path, new String[0]) : null);
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(7);
        }
        return generalCommandLine;
    }

    @ApiStatus.Obsolete(since="2024.2")
    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable File workDirectory) {
        GeneralCommandLine generalCommandLine = this.withWorkingDirectory(workDirectory != null ? workDirectory.toPath() : null);
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    @ApiStatus.Obsolete(since="2024.2")
    public void setWorkDirectory(@Nullable String path) {
        this.withWorkDirectory(path);
    }

    @ApiStatus.Obsolete(since="2024.2")
    public void setWorkDirectory(@Nullable File workDirectory) {
        this.withWorkDirectory(workDirectory);
    }

    @Nullable
    public Path getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @NotNull
    public GeneralCommandLine withWorkingDirectory(@Nullable Path workDirectory) {
        this.myWorkingDirectory = workDirectory;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(9);
        }
        return generalCommandLine;
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        Map<String, String> map = this.myEnvParams;
        if (map == null) {
            GeneralCommandLine.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@Nullable Map<String, String> environment) {
        if (environment != null) {
            this.getEnvironment().putAll(environment);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@NotNull String key, @NotNull String value) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(12);
        }
        if (value == null) {
            GeneralCommandLine.$$$reportNull$$$0(13);
        }
        this.getEnvironment().put(key, value);
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(14);
        }
        return generalCommandLine;
    }

    public boolean isPassParentEnvironment() {
        return this.myParentEnvironmentType != ParentEnvironmentType.NONE;
    }

    @Deprecated(forRemoval=true)
    public void setPassParentEnvironment(boolean passParentEnvironment) {
        this.withParentEnvironmentType(passParentEnvironment ? ParentEnvironmentType.CONSOLE : ParentEnvironmentType.NONE);
    }

    @NotNull
    public ParentEnvironmentType getParentEnvironmentType() {
        ParentEnvironmentType parentEnvironmentType = this.myParentEnvironmentType;
        if (parentEnvironmentType == null) {
            GeneralCommandLine.$$$reportNull$$$0(15);
        }
        return parentEnvironmentType;
    }

    @NotNull
    public GeneralCommandLine withParentEnvironmentType(@NotNull ParentEnvironmentType type) {
        if (type == null) {
            GeneralCommandLine.$$$reportNull$$$0(16);
        }
        this.myParentEnvironmentType = type;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(17);
        }
        return generalCommandLine;
    }

    @NotNull
    public Map<String, String> getParentEnvironment() {
        Map<String, String> map = switch (this.myParentEnvironmentType) {
            case ParentEnvironmentType.SYSTEM -> System.getenv();
            case ParentEnvironmentType.CONSOLE -> EnvironmentUtil.getEnvironmentMap();
            default -> Collections.emptyMap();
        };
        if (map == null) {
            GeneralCommandLine.$$$reportNull$$$0(18);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getEffectiveEnvironment() {
        MyMap env = new MyMap();
        this.setupEnvironment((Map<String, String>)((Object)env));
        MyMap myMap = env;
        if (myMap == null) {
            GeneralCommandLine.$$$reportNull$$$0(19);
        }
        return myMap;
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(20);
        }
        this.withParameters(parameters);
    }

    public void addParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(21);
        }
        this.withParameters(parameters);
    }

    @NotNull
    public GeneralCommandLine withParameters(String ... parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(22);
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(23);
        }
        return generalCommandLine;
    }

    @NotNull
    public GeneralCommandLine withParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(24);
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(25);
        }
        return generalCommandLine;
    }

    public void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            GeneralCommandLine.$$$reportNull$$$0(26);
        }
        this.myProgramParams.add(parameter);
    }

    @NotNull
    public ParametersList getParametersList() {
        ParametersList parametersList = this.myProgramParams;
        if (parametersList == null) {
            GeneralCommandLine.$$$reportNull$$$0(27);
        }
        return parametersList;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(28);
        }
        return charset;
    }

    @NotNull
    public GeneralCommandLine withCharset(@NotNull Charset charset) {
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(29);
        }
        this.myCharset = charset;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(30);
        }
        return generalCommandLine;
    }

    @ApiStatus.Obsolete(since="2024.2")
    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(31);
        }
        this.withCharset(charset);
    }

    public boolean isRedirectErrorStream() {
        return this.myRedirectErrorStream;
    }

    @NotNull
    public GeneralCommandLine withRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(32);
        }
        return generalCommandLine;
    }

    @ApiStatus.Obsolete(since="2024.2")
    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.withRedirectErrorStream(redirectErrorStream);
    }

    @Nullable
    public File getInputFile() {
        return this.myInputFile;
    }

    @NotNull
    public GeneralCommandLine withInput(@Nullable File file) {
        this.myInputFile = file;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(33);
        }
        return generalCommandLine;
    }

    @NlsSafe
    @NotNull
    public String getCommandLineString() {
        String string = this.getCommandLineString(null);
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public String getCommandLineString(@Nullable String exeName) {
        String string = ParametersListUtil.join(this.getCommandLineList(exeName));
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(35);
        }
        return string;
    }

    public @NotNull List<@NlsSafe String> getCommandLineList(@Nullable String exeName) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(exeName != null ? exeName : (this.myExePath != null ? this.myExePath : "<null>"));
        commands.addAll(this.myProgramParams.getList());
        ArrayList<String> arrayList = commands;
        if (arrayList == null) {
            GeneralCommandLine.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    public String getPreparedCommandLine() {
        String string = this.getPreparedCommandLine(Platform.current());
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    public String getPreparedCommandLine(@NotNull Platform platform) {
        if (platform == null) {
            GeneralCommandLine.$$$reportNull$$$0(38);
        }
        String string = String.join((CharSequence)"\n", this.prepareCommandLine(this.myExePath != null ? this.myExePath : "", this.myProgramParams.getList(), platform));
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    protected List<String> prepareCommandLine(@NotNull String command, @NotNull List<String> parameters, @NotNull Platform platform) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(40);
        }
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(41);
        }
        if (platform == null) {
            GeneralCommandLine.$$$reportNull$$$0(42);
        }
        List list = CommandLineUtil.toCommandLine((String)command, parameters, (Platform)platform);
        if (list == null) {
            GeneralCommandLine.$$$reportNull$$$0(43);
        }
        return list;
    }

    @ApiStatus.NonExtendable
    @NotNull
    public Process createProcess() throws ExecutionException {
        Process process;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing [" + this.getCommandLineString() + "]");
            if (this.myWorkingDirectory != null) {
                LOG.debug("  working dir: " + String.valueOf(this.myWorkingDirectory.toAbsolutePath()));
            }
            LOG.debug("  environment: " + String.valueOf(this.myEnvParams) + " (+" + String.valueOf((Object)this.myParentEnvironmentType) + ")");
            LOG.debug("  charset: " + String.valueOf(this.myCharset));
        }
        try {
            List commands = this.myProcessCreator != null || this.tryGetEel() != null ? ContainerUtil.concat(List.of(this.myExePath), this.myProgramParams.getList()) : this.validateAndPrepareCommandLineForLocalRun();
            Process process2 = this.startProcess(commands);
            String pidString = null;
            if (LOG.isDebugEnabled()) {
                try {
                    pidString = Long.toString(process2.pid());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                LOG.debug(String.format("Process %s started with pid %s", this.getCommandLineString(), pidString));
            }
            process = process2;
        }
        catch (IOException e) {
            if (SystemInfo.isWindows) {
                String mode = System.getProperty("jdk.lang.Process.allowAmbiguousCommands");
                SecurityManager sm = System.getSecurityManager();
                if ("false".equalsIgnoreCase(mode) || sm != null) {
                    e.addSuppressed(new IllegalStateException("Suspicious state: allowAmbiguousCommands=" + mode + " SM=" + String.valueOf(sm != null ? sm.getClass() : null)));
                }
            }
            throw new ProcessNotCreatedException(e.getMessage(), e, this);
        }
        if (process == null) {
            GeneralCommandLine.$$$reportNull$$$0(44);
        }
        return process;
    }

    @ApiStatus.Internal
    public final void setProcessCreator(@Nullable Function<ProcessBuilder, Process> processCreator) {
        this.myProcessCreator = processCreator;
    }

    @ApiStatus.Internal
    public final boolean isProcessCreatorSet() {
        return this.myProcessCreator != null;
    }

    @ApiStatus.Internal
    @Nullable
    public EelApi tryGetEel() {
        Ref<EelApi> eelApiRef = this.myEelApi;
        if (eelApiRef != null) {
            return (EelApi)eelApiRef.get();
        }
        if (!Registry.is((String)"ide.general.command.line.use.eel", (boolean)false)) {
            this.myEelApi = new Ref(null);
            return null;
        }
        String exe = this.myExePath;
        Path workingDirectory = this.myWorkingDirectory;
        if (Strings.isNullOrEmpty((String)exe)) {
            return null;
        }
        Path exePath = Path.of(exe, new String[0]);
        if (ApplicationManager.getApplication().getServiceIfCreated(EelNioBridgeService.class) == null) {
            return null;
        }
        Object eelApi = SystemInfo.isWindows && OSAgnosticPathUtil.isAbsoluteDosPath((String)exe) ? null : (EelProviderUtil.getEelDescriptor((Path)exePath) != LocalEelDescriptor.INSTANCE ? EelProviderUtil.upgradeBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Path)exePath)) : (workingDirectory != null ? (EelProviderUtil.getEelDescriptor((Path)workingDirectory) != LocalEelDescriptor.INSTANCE ? EelProviderUtil.upgradeBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Path)workingDirectory)) : null) : null));
        this.myEelApi = Ref.create((Object)eelApi);
        return eelApi;
    }

    @NotNull
    public ProcessBuilder toProcessBuilder() throws ExecutionException {
        ProcessBuilder processBuilder = this.toProcessBuilder(this.validateAndPrepareCommandLineForLocalRun());
        if (processBuilder == null) {
            GeneralCommandLine.$$$reportNull$$$0(45);
        }
        return processBuilder;
    }

    private List<String> validateAndPrepareCommandLineForLocalRun() throws ExecutionException {
        if (this.myWorkingDirectory != null && !Files.isDirectory(this.myWorkingDirectory, new LinkOption[0])) {
            LOG.debug("Invalid working directory: " + String.valueOf(this.myWorkingDirectory));
            throw new WorkingDirectoryNotFoundException(this.myWorkingDirectory);
        }
        if (this.myExePath == null || this.myExePath.isBlank()) {
            LOG.debug("Invalid executable: " + this.myExePath);
            throw new ExecutionException(IdeUtilIoBundle.message("run.configuration.error.executable.not.specified", new Object[0]));
        }
        for (Map.Entry<String, String> entry : this.myEnvParams.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!EnvironmentUtil.isValidName((String)name)) {
                throw new IllegalEnvVarException(IdeUtilIoBundle.message("run.configuration.invalid.env.name", name));
            }
            if (EnvironmentUtil.isValidValue((String)value)) continue;
            throw new IllegalEnvVarException(IdeUtilIoBundle.message("run.configuration.invalid.env.value", name, value));
        }
        String exePath = this.myExePath;
        if (exePath.indexOf(File.separatorChar) == -1) {
            File exeFile;
            String shellPath;
            String lookupPath = this.myEnvParams.get("PATH");
            if (lookupPath == null && this.myParentEnvironmentType == ParentEnvironmentType.CONSOLE && SystemInfo.isMac && !Objects.equals(shellPath = EnvironmentUtil.getValue((String)"PATH"), System.getenv("PATH"))) {
                lookupPath = shellPath;
            }
            if (lookupPath != null && (exeFile = PathEnvironmentVariableUtil.findInPath(this.myExePath, lookupPath, null)) != null) {
                LOG.debug(exePath + " => " + String.valueOf(exeFile));
                exePath = exeFile.getPath();
            }
        }
        return this.prepareCommandLine(exePath, this.myProgramParams.getList(), Platform.current());
    }

    @NotNull
    protected Process createProcess(@NotNull ProcessBuilder processBuilder) throws IOException {
        LocalPtyOptions ptyOptions;
        if (processBuilder == null) {
            GeneralCommandLine.$$$reportNull$$$0(46);
        }
        if (this.myProcessCreator != null) {
            Process process = this.myProcessCreator.apply(processBuilder);
            if (process == null) {
                GeneralCommandLine.$$$reportNull$$$0(47);
            }
            return process;
        }
        EelApi eelApi = this.tryGetEel();
        if (eelApi == null) {
            Process process = processBuilder.start();
            if (process == null) {
                GeneralCommandLine.$$$reportNull$$$0(48);
            }
            return process;
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine instanceof PtyCommandLine) {
            PtyCommandLine ptyCommandLine = (PtyCommandLine)generalCommandLine;
            ptyOptions = ptyCommandLine.getPtyOptions();
        } else {
            ptyOptions = null;
        }
        Process process = ExecUtil.startProcessBlockingUsingEel(eelApi.getExec(), processBuilder, ptyOptions);
        if (process == null) {
            GeneralCommandLine.$$$reportNull$$$0(49);
        }
        return process;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected Process startProcess(@NotNull List<String> escapedCommands) throws IOException {
        if (escapedCommands == null) {
            GeneralCommandLine.$$$reportNull$$$0(50);
        }
        Process process = this.createProcess(this.toProcessBuilder(escapedCommands));
        if (process == null) {
            GeneralCommandLine.$$$reportNull$$$0(51);
        }
        return process;
    }

    private ProcessBuilder toProcessBuilder(List<String> escapedCommands) {
        ProcessBuilder builder = new ProcessBuilder(escapedCommands);
        this.setupEnvironment(builder.environment());
        if (this.myWorkingDirectory != null) {
            builder.directory(new File(this.myWorkingDirectory.toString()));
        }
        builder.redirectErrorStream(this.myRedirectErrorStream);
        if (this.myInputFile != null) {
            builder.redirectInput(ProcessBuilder.Redirect.from(this.myInputFile));
        }
        return builder;
    }

    protected void setupEnvironment(@NotNull Map<String, String> environment) {
        File workDirectory;
        if (environment == null) {
            GeneralCommandLine.$$$reportNull$$$0(52);
        }
        environment.clear();
        if (this.myParentEnvironmentType != ParentEnvironmentType.NONE && this.myProcessCreator == null && this.tryGetEel() == null) {
            environment.putAll(this.getParentEnvironment());
        }
        if (SystemInfo.isUnix && this.myProcessCreator == null && this.tryGetEel() == null && (workDirectory = this.getWorkDirectory()) != null) {
            environment.put("PWD", FileUtil.toSystemDependentName((String)workDirectory.getAbsolutePath()));
        }
        if (!this.myEnvParams.isEmpty()) {
            if (SystemInfo.isWindows && this.myProcessCreator == null && this.tryGetEel() == null) {
                Map envVars = CollectionFactory.createCaseInsensitiveStringMap();
                envVars.putAll(environment);
                envVars.putAll(this.myEnvParams);
                environment.clear();
                environment.putAll(envVars);
            } else {
                environment.putAll(this.myEnvParams);
            }
        }
        EnvironmentRestorer.restoreOverriddenVars(environment);
        this.customizeEnv(environment);
    }

    private void customizeEnv(@NotNull Map<String, String> environment) {
        ExecutionEnvCustomizerService envCustomizer;
        Application application;
        if (environment == null) {
            GeneralCommandLine.$$$reportNull$$$0(53);
        }
        if ((application = ApplicationManager.getApplication()) != null && (envCustomizer = (ExecutionEnvCustomizerService)application.getService(ExecutionEnvCustomizerService.class)) != null) {
            envCustomizer.customizeEnv(this, environment);
        }
    }

    @NotNull
    public static String inescapableQuote(@NotNull String parameter) {
        if (parameter == null) {
            GeneralCommandLine.$$$reportNull$$$0(54);
        }
        String string = CommandLineUtil.specialQuote((String)parameter);
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(55);
        }
        return string;
    }

    public String toString() {
        return this.myExePath + " " + String.valueOf(this.myProgramParams);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(56);
        }
        if (this.myUserData == null) {
            return null;
        }
        Object t = this.myUserData.get(key);
        return (T)t;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(57);
        }
        if (this.myUserData == null) {
            if (value == null) {
                return;
            }
            this.myUserData = new HashMap<Object, Object>();
        }
        this.myUserData.put(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8, 9, 10, 11, 14, 15, 17, 18, 19, 23, 25, 27, 28, 30, 32, 33, 34, 35, 36, 37, 39, 43, 44, 45, 47, 48, 49, 51, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/GeneralCommandLine";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 12: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 26: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processBuilder";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedCommands";
                break;
            }
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/GeneralCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withExePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkingDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvironment";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnvironmentType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withParentEnvironmentType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnvironment";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveEnvironment";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameters";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersList";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "withCharset";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "withRedirectErrorStream";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "withInput";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineString";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineList";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedCommandLine";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCommandLine";
                break;
            }
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "toProcessBuilder";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "inescapableQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 55: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withExePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExePath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withEnvironment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "withParentEnvironmentType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "withCharset";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedCommandLine";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "customizeEnv";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "inescapableQuote";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8, 9, 10, 11, 14, 15, 17, 18, 19, 23, 25, 27, 28, 30, 32, 33, 34, 35, 36, 37, 39, 43, 44, 45, 47, 48, 49, 51, 55 -> new IllegalStateException(string);
        };
    }

    private static final class MyMap
    extends Object2ObjectOpenCustomHashMap<String, String> {
        private MyMap() {
            super(FastUtilHashingStrategies.getStringStrategy((!SystemInfo.isWindows ? 1 : 0) != 0));
        }

        public void putAll(Map<? extends String, ? extends String> map) {
            if (map != null) {
                super.putAll(map);
            }
        }
    }

    public static enum ParentEnvironmentType {
        NONE,
        SYSTEM,
        CONSOLE;

    }
}

