/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.configurationStore.ComponentReloadingKt;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.NearestUpdate;
import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.jb.IDEData;
import com.intellij.ide.startup.importSettings.jb.JbImportSpecialHandler;
import com.intellij.ide.startup.importSettings.jb.JbSettingsImporter;
import com.intellij.ide.startup.importSettings.jb.JbSettingsImporterKt;
import com.intellij.ide.startup.importSettings.statistics.ImportSettingsEventsCollector;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.InternalPluginResults;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001IB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002J \u0010\u0019\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00150\u001aH\u0002J$\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0086@\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0 j\b\u0012\u0004\u0012\u00020\u000e`!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0002J*\u0010$\u001a\u00020\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130)H\u0082@\u00a2\u0006\u0002\u0010*J<\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0#2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0015H\u0002J\r\u0010/\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b0J \u00101\u001a\b\u0012\u0004\u0012\u00020\u000e0#2\u0006\u00102\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u00020\u000eH\u0002J0\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u0016\u00106\u001a\u0004\u0018\u0001072\n\u00108\u001a\u0006\u0012\u0002\b\u000309H\u0002J*\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J4\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020=2\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\u0010>\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0006\u0012\u0004\u0018\u00010@0\rH\u0086@\u00a2\u0006\u0002\u0010AJ&\u0010B\u001a\u00020\u00132\u0014\u0010C\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0006\u0012\u0004\u0018\u00010@0D2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010E\u001a\u00020F2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020?0#H\u0002J\u0006\u0010G\u001a\u00020\u0013J\u0006\u0010H\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbSettingsImporter;", "", "configDirPath", "Ljava/nio/file/Path;", "pluginsPath", "prevIdeHome", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "componentStore", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "defaultNewUIValue", "", "additionalSchemeDirs", "", "", "Lcom/intellij/openapi/components/SettingsCategory;", "componentNamesDependencies", "", "importOptionsAfterRestart", "", "categories", "", "pluginIds", "(Ljava/util/Set;Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadProjectDefaultComponentNames", "findComponentsAndFiles", "Lkotlin/Pair;", "importOptions", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toposortComponentNames", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "components", "", "withExternalStreamProvider", "storageManagers", "", "Lcom/intellij/configurationStore/StateStorageManager;", "action", "Lkotlin/Function0;", "([Lcom/intellij/configurationStore/StateStorageManager;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadNotLoadedComponents", "componentManagerImpl", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "componentsToLoad", "isNewUIValueChanged", "isNewUIValueChanged$intellij_ide_startup_importSettings", "filesFromFolder", "dir", "prefix", "filterComponents", "allFiles", "getStateOrNull", "Lcom/intellij/openapi/components/State;", "aClass", "Ljava/lang/Class;", "filterSchemes", "installPlugins", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "pluginsMap", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkPluginsCompatibility", "updateablePluginsMap", "", "configImportOptions", "Lcom/intellij/openapi/application/ConfigImportHelper$ConfigImportOptions;", "importRaw", "migrateLocalization", "ImportStreamProvider", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nJbSettingsImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbSettingsImporter.kt\ncom/intellij/ide/startup/importSettings/jb/JbSettingsImporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,585:1\n1611#2,9:586\n1863#2:595\n1864#2:597\n1620#2:598\n1863#2,2:599\n1#3:596\n1#3:601\n*S KotlinDebug\n*F\n+ 1 JbSettingsImporter.kt\ncom/intellij/ide/startup/importSettings/jb/JbSettingsImporter\n*L\n153#1:586,9\n153#1:595\n153#1:597\n153#1:598\n212#1:599,2\n153#1:596\n*E\n"})
public final class JbSettingsImporter {
    @NotNull
    private final Path configDirPath;
    @NotNull
    private final Path pluginsPath;
    @Nullable
    private final Path prevIdeHome;
    @NotNull
    private final ComponentStoreImpl componentStore;
    private final boolean defaultNewUIValue;
    @NotNull
    private final Map<String, SettingsCategory> additionalSchemeDirs;
    @NotNull
    private final Map<String, List<String>> componentNamesDependencies;

    public JbSettingsImporter(@NotNull Path configDirPath, @NotNull Path pluginsPath, @Nullable Path prevIdeHome) {
        Intrinsics.checkNotNullParameter((Object)configDirPath, (String)"configDirPath");
        Intrinsics.checkNotNullParameter((Object)pluginsPath, (String)"pluginsPath");
        this.configDirPath = configDirPath;
        this.pluginsPath = pluginsPath;
        this.prevIdeHome = prevIdeHome;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application));
        Intrinsics.checkNotNull((Object)iComponentStore, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        this.componentStore = (ComponentStoreImpl)iComponentStore;
        this.defaultNewUIValue = true;
        this.additionalSchemeDirs = MapsKt.mapOf((Pair)TuplesKt.to((Object)"fileTemplates", (Object)SettingsCategory.CODE));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"SshLocalRecentConnectionsManager", (Object)CollectionsKt.listOf((Object)"SshConfigs")), TuplesKt.to((Object)"SshHostStorage", (Object)CollectionsKt.listOf((Object)"SshConfigs")), TuplesKt.to((Object)"EditorColorsManagerImpl", (Object)CollectionsKt.listOf((Object)"LafManager"))};
        this.componentNamesDependencies = MapsKt.mapOf((Pair[])pairArray);
    }

    @Nullable
    public final Object importOptionsAfterRestart(@NotNull Set<? extends SettingsCategory> categories, @NotNull Set<String> pluginIds, @NotNull Continuation<? super Unit> $completion) {
        StateStorageManager storageManager = this.componentStore.getStorageManager();
        Pair<Set<String>, Set<String>> pair = this.findComponentsAndFiles();
        Set components = (Set)pair.component1();
        Set files = (Set)pair.component2();
        StateStorageManager[] stateStorageManagerArray = new StateStorageManager[]{storageManager};
        Object object = this.withExternalStreamProvider(stateStorageManagerArray, (Function0<Unit>)((Function0)() -> JbSettingsImporter.importOptionsAfterRestart$lambda$0(this, components, pluginIds, files, categories)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Set<String> loadProjectDefaultComponentNames() {
        Path path = this.configDirPath.resolve("options");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve("project.default.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path projectDefaultXmlPath = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(projectDefaultXmlPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return SetsKt.emptySet();
        }
        Element element = JDOMUtil.load((Path)projectDefaultXmlPath);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element parentElement = element;
        Element element2 = parentElement.getChild("component");
        if (element2 == null || (element2 = element2.getChild("defaultProject")) == null) {
            return SetsKt.emptySet();
        }
        Element defaultProjectElement = element2;
        Set retval = new LinkedHashSet();
        for (Element componentElement : defaultProjectElement.getChildren("component")) {
            String componentName = componentElement.getAttributeValue("name");
            Intrinsics.checkNotNull((Object)componentName);
            retval.add(componentName);
        }
        return retval;
    }

    private final Pair<Set<String>, Set<String>> findComponentsAndFiles() {
        Path path = this.configDirPath.resolve("options");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path optionsPath = path;
        Set allFiles = new LinkedHashSet();
        Set components = new LinkedHashSet();
        for (Path optionsEntry : PathsKt.listDirectoryEntries$default((Path)optionsPath, null, (int)1, null)) {
            if (Intrinsics.areEqual((Object)PathsKt.getName((Path)optionsEntry), (Object)"project.default.xml")) continue;
            String string = PathsKt.getName((Path)optionsEntry).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
                Element element;
                allFiles.add(PathsKt.getName((Path)optionsEntry));
                Intrinsics.checkNotNullExpressionValue((Object)JDOMUtil.load((Path)optionsEntry), (String)"load(...)");
                List children = element.getChildren("component");
                allFiles.add(PathsKt.getName((Path)optionsEntry));
                for (Element componentElement : children) {
                    String componentName = componentElement.getAttributeValue("name");
                    Intrinsics.checkNotNull((Object)componentName);
                    components.add(componentName);
                }
                continue;
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(optionsEntry, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            String string2 = PathsKt.getName((Path)optionsEntry).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string2, (Object)StoreUtilKt.getPerOsSettingsStorageFolderName())) continue;
            allFiles.addAll(this.filesFromFolder(optionsEntry, PathsKt.getName((Path)optionsEntry)));
        }
        return new Pair((Object)components, (Object)allFiles);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Nullable
    public final Object importOptions(@NotNull ProgressIndicator var1_1, @NotNull Set<? extends SettingsCategory> var2_2, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof importOptions.1)) ** GOTO lbl-1000
        var29_4 = $completion;
        if ((var29_4.label & -2147483648) != 0) {
            var29_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ JbSettingsImporter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.importOptions(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var30_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                progressIndicator.checkCanceled();
                allFiles = new LinkedHashSet<E>();
                notLoadedComponents = new ArrayList<E>();
                unknownStorage = new ArrayList<E>();
                v0 = this.componentStore.getStorageManager();
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
                storageManager = (StateStorageManagerImpl)v0;
                $this$mapNotNull$iv = storageManager.getCachedFileStorages();
                $i$f$mapNotNull = false;
                var11_14 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                for (T element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    element$iv$iv = element$iv$iv$iv;
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (StateStorage)element$iv$iv;
                    $i$a$-mapNotNull-JbSettingsImporter$importOptions$cachedFileStorages$1 = false;
                    v1 /* !! */  = it instanceof FileBasedStorage != false ? (FileBasedStorage)it : null;
                    if ((v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .getFile()) != null ? PathsKt.getName((Path)v1 /* !! */ ) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                cachedFileStorages = (List)destination$iv$iv;
                var9_11 = this.findComponentsAndFiles();
                components = (Set)var9_11.component1();
                files = (Set)var9_11.component2();
                notLoadedComponents.addAll(components);
                notLoadedComponents.removeAll(this.componentStore.getComponentNames());
                allFiles.addAll(files);
                unknownStorage.addAll(files);
                unknownStorage.removeAll(CollectionsKt.toSet((Iterable)cachedFileStorages));
                JbSettingsImporterKt.access$getLOG$p().info("NOT loaded components(" + notLoadedComponents.size() + "):\n" + CollectionsKt.joinToString$default((Iterable)notLoadedComponents, null, null, null, (int)0, null, null, (int)63, null));
                JbSettingsImporterKt.access$getLOG$p().info("NOT loaded storages(" + unknownStorage.size() + "):\n" + CollectionsKt.joinToString$default((Iterable)unknownStorage, null, null, null, (int)0, null, null, (int)63, null));
                progressIndicator.checkCanceled();
                v2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
                componentManagerImpl = (ComponentManagerImpl)v2;
                v3 = ProjectManager.getInstance().getDefaultProject();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getDefaultProject(...)");
                defaultProject = v3;
                v4 = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)defaultProject));
                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
                defaultProjectStore = (ComponentStoreImpl)v4;
                defaultProjectStorage = defaultProjectStore.getStorageManager().getStateStorage((Storage)new FileStorageAnnotation("", false));
                loadNotLoadedComponents = this.loadNotLoadedComponents(progressIndicator, componentManagerImpl, (Collection<String>)notLoadedComponents, null);
                notLoadedComponents.removeAll((Collection)loadNotLoadedComponents);
                projectDefaultComponentNames = this.loadProjectDefaultComponentNames();
                if (((Collection)projectDefaultComponentNames).isEmpty() == false) {
                    element$iv$iv = defaultProject.getActualComponentManager();
                    Intrinsics.checkNotNull(element$iv$iv, (String)"null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
                    this.loadNotLoadedComponents(progressIndicator, (ComponentManagerImpl)element$iv$iv, (Collection<String>)projectDefaultComponentNames, null);
                }
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = notLoadedComponents.iterator();
                Intrinsics.checkNotNullExpressionValue($i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv, (String)"iterator(...)");
                element$iv$iv = $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv;
                while (element$iv$iv.hasNext()) {
                    v5 = element$iv$iv.next();
                    Intrinsics.checkNotNullExpressionValue(v5, (String)"next(...)");
                    component = (String)v5;
                    JbSettingsImporterKt.access$getLOG$p().info("Component " + (String)component + " was not found and loaded. Its settings will not be migrated");
                }
                CodeStyleSchemes.getInstance();
                InspectionProfileManager.getInstance();
                v6 = SchemeManagerFactory.Companion.getInstance();
                Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
                schemeManagerFactory = (SchemeManagerFactoryBase)v6;
                schemeManagerFactory.process((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, importOptions$lambda$2(com.intellij.openapi.progress.ProgressIndicator com.intellij.ide.startup.importSettings.jb.JbSettingsImporter java.util.Set com.intellij.configurationStore.schemeManager.SchemeManagerImpl ), (Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)Lkotlin/Unit;)((ProgressIndicator)progressIndicator, (JbSettingsImporter)this, (Set)allFiles));
                for (Map.Entry entry : this.additionalSchemeDirs.entrySet()) {
                    v7 = this.configDirPath.resolve((String)entry.getKey());
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"resolve(...)");
                    v8 = new LinkOption[]{};
                    if (!Files.isDirectory(v7, Arrays.copyOf(v8, v8.length))) continue;
                    v9 = this.configDirPath.resolve((String)entry.getKey());
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"resolve(...)");
                    allFiles.addAll(this.filesFromFolder(v9, (String)entry.getKey()));
                }
                JbSettingsImporterKt.access$getLOG$p().info("Detected " + allFiles.size() + " files that could be imported: " + CollectionsKt.joinToString$default((Iterable)allFiles, null, null, null, (int)0, null, null, (int)63, null));
                componentAndFilesMap = this.filterComponents(allFiles, (Set<? extends SettingsCategory>)categories);
                componentFiles = CollectionsKt.toSet((Iterable)componentAndFilesMap.values());
                JbSettingsImporterKt.access$getLOG$p().info("After filtering we have " + componentFiles.size() + " component files to import: " + CollectionsKt.joinToString$default((Iterable)componentFiles, null, null, null, (int)0, null, null, (int)63, null));
                schemeFiles = this.filterSchemes(allFiles, (Set<? extends SettingsCategory>)categories);
                JbSettingsImporterKt.access$getLOG$p().info("After filtering we have " + schemeFiles.size() + " scheme files to import: " + CollectionsKt.joinToString$default((Iterable)schemeFiles, null, null, null, (int)0, null, null, (int)63, null));
                Registry.Companion.setValueChangeListener(new RegistryValueListener(){});
                $this$forEach$iv = schemeFiles;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    $i$a$-forEach-JbSettingsImporter$importOptions$4 = false;
                    v10 = this.configDirPath.resolve(it);
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"resolve(...)");
                    v11 = PathManager.getConfigDir();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getConfigDir(...)");
                    v12 = v11.resolve(it);
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"resolve(...)");
                    PathKt.copy((Path)v10, (Path)v12);
                }
                appComponentNames = this.toposortComponentNames((Collection<String>)componentAndFilesMap.keySet());
                var23_31 = new StateStorageManager[]{storageManager, defaultProjectStore.getStorageManager()};
                $continuation.L$0 = this;
                $continuation.L$1 = progressIndicator;
                $continuation.label = 1;
                v13 = this.withExternalStreamProvider(var23_31, (Function0<Unit>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, importOptions$lambda$6(com.intellij.openapi.progress.ProgressIndicator com.intellij.ide.startup.importSettings.jb.JbSettingsImporter java.util.Set java.util.Set java.util.LinkedHashSet com.intellij.configurationStore.ComponentStoreImpl java.util.Set com.intellij.openapi.components.StateStorage ), ()Lkotlin/Unit;)((ProgressIndicator)progressIndicator, (JbSettingsImporter)this, (Set)componentFiles, schemeFiles, appComponentNames, (ComponentStoreImpl)defaultProjectStore, projectDefaultComponentNames, (StateStorage)defaultProjectStorage), (Continuation<? super Unit>)$continuation);
                if (v13 == var30_6) {
                    return var30_6;
                }
                ** GOTO lbl137
            }
            case 1: {
                progressIndicator = (ProgressIndicator)$continuation.L$1;
                this = (JbSettingsImporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl137:
                // 2 sources

                progressIndicator.checkCanceled();
                JbImportSpecialHandler.INSTANCE.postProcess(this.configDirPath);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v14 = RegistryManager.Companion.getInstanceAsync((Continuation)$continuation);
                if (v14 == var30_6) {
                    return var30_6;
                }
                ** GOTO lbl149
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v14 = $result;
lbl149:
                // 2 sources

                ((RegistryManager)v14).resetValueChangeListener();
                return Boxing.boxBoolean((boolean)Registry.Companion.getInstance().isRestartNeeded());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final LinkedHashSet<String> toposortComponentNames(Collection<String> components) {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        for (String c : components) {
            List list = this.componentNamesDependencies.get(c);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (String d : list) {
                if (retval.contains(d)) continue;
                retval.add(d);
            }
            retval.add(c);
        }
        return retval;
    }

    private final Object withExternalStreamProvider(StateStorageManager[] storageManagers, Function0<Unit> action, Continuation<? super Unit> $completion) {
        ImportStreamProvider provider = new ImportStreamProvider(this.configDirPath);
        for (StateStorageManager storageManager : storageManagers) {
            StateStorageManager.addStreamProvider$default((StateStorageManager)storageManager, (StreamProvider)provider, (boolean)false, (int)2, null);
        }
        action.invoke();
        for (StateStorageManager storageManager : storageManagers) {
            storageManager.removeStreamProvider(provider.getClass());
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        Object object = StoreUtilKt.saveSettings((ComponentManager)((ComponentManager)application), (boolean)true, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Set<String> loadNotLoadedComponents(ProgressIndicator progressIndicator, ComponentManagerImpl componentManagerImpl, Collection<String> componentsToLoad, Set<String> pluginIds) {
        long start = System.currentTimeMillis();
        ArrayList<String> notLoadedComponents = new ArrayList<String>();
        notLoadedComponents.addAll(componentsToLoad);
        HashMap foundComponents = new HashMap();
        componentManagerImpl.processAllHolders((arg_0, arg_1, arg_2) -> JbSettingsImporter.loadNotLoadedComponents$lambda$7(progressIndicator, pluginIds, this, componentsToLoad, componentManagerImpl, notLoadedComponents, foundComponents, arg_0, arg_1, arg_2));
        JbSettingsImporterKt.access$getLOG$p().info("Loaded notFoundComponents in " + (System.currentTimeMillis() - start) + " ms");
        Set<String> set = foundComponents.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    public final boolean isNewUIValueChanged$intellij_ide_startup_importSettings() {
        Path path = this.configDirPath.resolve("early-access-registry.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path earlyAccessRegistryPath = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(earlyAccessRegistryPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return false;
        }
        File file = earlyAccessRegistryPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Iterator eaLinesIterator = FilesKt.readLines$default((File)file, null, (int)1, null).iterator();
        while (eaLinesIterator.hasNext()) {
            String key = (String)eaLinesIterator.next();
            if (!eaLinesIterator.hasNext()) continue;
            String value = (String)eaLinesIterator.next();
            if (!Intrinsics.areEqual((Object)key, (Object)"ide.experimental.ui")) continue;
            return !Intrinsics.areEqual((Object)value, (Object)String.valueOf(this.defaultNewUIValue));
        }
        return false;
    }

    private final Collection<String> filesFromFolder(Path dir, String prefix) {
        ArrayList<Object> retval = new ArrayList<Object>();
        for (Path entry : PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null)) {
            boolean bl;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(entry, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                if (((CharSequence)prefix).length() == 0) {
                    bl = retval.add(PathsKt.getName((Path)entry));
                    continue;
                }
                bl = retval.add(prefix + "/" + PathsKt.getName((Path)entry));
                continue;
            }
            Collection<String> folderFiles = this.filesFromFolder(entry, prefix + "/" + PathsKt.getName((Path)entry));
            bl = retval.addAll(folderFiles);
        }
        return retval;
    }

    static /* synthetic */ Collection filesFromFolder$default(JbSettingsImporter jbSettingsImporter, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = PathsKt.getName((Path)path);
        }
        return jbSettingsImporter.filesFromFolder(path, string);
    }

    private final Map<String, String> filterComponents(Set<String> allFiles, Set<? extends SettingsCategory> categories) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        ComponentManagerImpl componentManager = (ComponentManagerImpl)application;
        HashMap retval = new HashMap();
        String osFolderName = StoreUtilKt.getPerOsSettingsStorageFolderName();
        componentManager.processAllImplementationClasses((arg_0, arg_1) -> JbSettingsImporter.filterComponents$lambda$9(this, categories, allFiles, osFolderName, retval, arg_0, arg_1));
        return retval;
    }

    private final State getStateOrNull(Class<?> aClass) {
        Class<?> clazz = aClass;
        while (PersistentStateComponent.class.isAssignableFrom(clazz)) {
            State state = clazz.getAnnotation(State.class);
            if (state != null) {
                return state;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private final Set<String> filterSchemes(Set<String> allFiles, Set<? extends SettingsCategory> categories) {
        HashSet<String> retval = new HashSet<String>();
        HashSet<String> schemeCategories = new HashSet<String>();
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)schemeManagerFactory, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        ((SchemeManagerFactoryBase)schemeManagerFactory).process(arg_0 -> JbSettingsImporter.filterSchemes$lambda$10(categories, schemeCategories, arg_0));
        for (Map.Entry<String, SettingsCategory> entry : this.additionalSchemeDirs.entrySet()) {
            if (!categories.contains(entry.getValue())) continue;
            schemeCategories.add(entry.getKey());
        }
        for (String file : allFiles) {
            char[] cArray;
            List split = StringsKt.split$default((CharSequence)file, (char[])(cArray = new char[]{'/'}), (boolean)false, (int)0, (int)6, null);
            if (split.size() < 2 || !schemeCategories.contains(split.get(0))) continue;
            retval.add(file);
        }
        return retval;
    }

    @Nullable
    public final Object installPlugins(@NotNull CoroutineScope coroutineScope, @NotNull ProgressIndicator progressIndicator, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> pluginsMap, @NotNull Continuation<? super Unit> $completion) {
        if (!SettingsService.Companion.getInstance().getPluginIdsPreloaded()) {
            JbSettingsImporterKt.access$getLOG$p().warn("Couldn't preload plugin ids, which indicates problems with connection. Will use old import");
            ConfigImportHelper.ConfigImportOptions importOptions2 = this.configImportOptions(progressIndicator, (Collection<PluginId>)pluginsMap.keySet());
            ImportSettingsEventsCollector.INSTANCE.jbPluginsOldImport();
            ConfigImportHelper.migratePlugins((Path)this.pluginsPath, (Path)this.configDirPath, (Path)PathManager.getPluginsDir(), (Path)PathManager.getConfigDir(), (ConfigImportHelper.ConfigImportOptions)importOptions2, JbSettingsImporter::installPlugins$lambda$11);
            return Unit.INSTANCE;
        }
        ImportSettingsEventsCollector.INSTANCE.jbPluginsNewImport();
        RepositoryHelper.updatePluginHostsFromConfigDir((Path)this.configDirPath, (Logger)JbSettingsImporterKt.access$getLOG$p());
        HashMap<PluginId, ? extends IdeaPluginDescriptor> updateableMap = new HashMap<PluginId, IdeaPluginDescriptor>(pluginsMap);
        progressIndicator.setText2(ImportSettingsBundle.INSTANCE.message("progress.details.checking.for.plugin.updates", new Object[0]));
        InternalPluginResults internalPluginUpdates = UpdateChecker.getInternalPluginUpdates(null, (ProgressIndicator)progressIndicator, (Map)updateableMap);
        for (PluginDownloader pluginDownloader : internalPluginUpdates.getPluginUpdates().getAll()) {
            IdeaPluginDescriptor descriptor;
            JbSettingsImporterKt.access$getLOG$p().info("Downloading " + pluginDownloader.getId());
            if (pluginDownloader.prepareToInstall(progressIndicator)) {
                PluginInstaller.unpackPlugin((Path)pluginDownloader.getFilePath(), (Path)PathManager.getPluginsDir());
                JbSettingsImporterKt.access$getLOG$p().info("Downloaded and unpacked newer version of plugin '" + pluginDownloader.getId() + "' : " + pluginDownloader.getPluginVersion());
                continue;
            }
            if (pluginsMap.get(pluginDownloader.getId()) == null) continue;
            ((Map)updateableMap).put(pluginDownloader.getId(), descriptor);
            ImportSettingsEventsCollector.INSTANCE.jbPluginImportConnectionError();
            JbSettingsImporterKt.access$getLOG$p().info("Failed to download a newer version of '" + pluginDownloader.getId() + "' : " + pluginDownloader.getPluginVersion() + ". Will try to copy old version (" + descriptor.getVersion() + ") instead");
        }
        this.checkPluginsCompatibility((Map<PluginId, IdeaPluginDescriptor>)updateableMap, progressIndicator);
        progressIndicator.setText2(ImportSettingsBundle.INSTANCE.message("progress.details.copying.plugins", new Object[0]));
        Path path = PathManager.getPluginsDir();
        Collection<? extends IdeaPluginDescriptor> collection = updateableMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        ConfigImportHelper.migratePlugins((Path)path, (List)CollectionsKt.toList((Iterable)collection), (Logger)JbSettingsImporterKt.access$getLOG$p());
        return Unit.INSTANCE;
    }

    private final void checkPluginsCompatibility(Map<PluginId, IdeaPluginDescriptor> updateablePluginsMap, ProgressIndicator progressIndicator) {
        IDEData iDEData = IDEData.Companion.getSelf();
        if (iDEData == null) {
            return;
        }
        IDEData myIdeData = iDEData;
        progressIndicator.setText2(ImportSettingsBundle.INSTANCE.message("progress.details.checking.plugins.compatibility", new Object[0]));
        List updates = MarketplaceRequests.Companion.getNearestUpdate$default((MarketplaceRequests.Companion)MarketplaceRequests.Companion, updateablePluginsMap.keySet(), null, (boolean)false, (int)6, null);
        for (NearestUpdate update : updates) {
            PluginId pluginId;
            if (update.getCompatible() || update.getProducts().contains(myIdeData.getMarketplaceCode()) || PluginId.findId((String)update.getPluginId()) == null) continue;
            JbSettingsImporterKt.access$getLOG$p().info("Plugins " + update.getPluginId() + " is incompatible with " + myIdeData.getFullName() + ". Will not migrate it");
            updateablePluginsMap.remove(pluginId);
        }
    }

    private final ConfigImportHelper.ConfigImportOptions configImportOptions(ProgressIndicator progressIndicator, Collection<PluginId> pluginIds) {
        ConfigImportHelper.ConfigImportOptions importOptions2 = new ConfigImportHelper.ConfigImportOptions(JbSettingsImporterKt.access$getLOG$p());
        importOptions2.setHeadless(true);
        importOptions2.setHeadlessProgressIndicator(progressIndicator);
        importOptions2.importSettings = new ConfigImportSettings(pluginIds){
            final /* synthetic */ Collection<PluginId> $pluginIds;
            {
                this.$pluginIds = $pluginIds;
            }

            public void processPluginsToMigrate(Path newConfigDir, Path oldConfigDir, List<IdeaPluginDescriptor> bundledPlugins, List<IdeaPluginDescriptor> nonBundledPlugins) {
                Intrinsics.checkNotNullParameter((Object)newConfigDir, (String)"newConfigDir");
                Intrinsics.checkNotNullParameter((Object)oldConfigDir, (String)"oldConfigDir");
                Intrinsics.checkNotNullParameter(bundledPlugins, (String)"bundledPlugins");
                Intrinsics.checkNotNullParameter(nonBundledPlugins, (String)"nonBundledPlugins");
                nonBundledPlugins.removeIf(arg_0 -> configImportOptions.1.processPluginsToMigrate$lambda$1(arg_0 -> configImportOptions.1.processPluginsToMigrate$lambda$0(this.$pluginIds, arg_0), arg_0));
                bundledPlugins.removeIf(arg_0 -> configImportOptions.1.processPluginsToMigrate$lambda$3(arg_0 -> configImportOptions.1.processPluginsToMigrate$lambda$2(this.$pluginIds, arg_0), arg_0));
            }

            private static final boolean processPluginsToMigrate$lambda$0(Collection $pluginIds, IdeaPluginDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !$pluginIds.contains(it.getPluginId());
            }

            private static final boolean processPluginsToMigrate$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean processPluginsToMigrate$lambda$2(Collection $pluginIds, IdeaPluginDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !$pluginIds.contains(it.getPluginId());
            }

            private static final boolean processPluginsToMigrate$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
        return importOptions2;
    }

    public final void importRaw() {
        long startTime = System.currentTimeMillis();
        Path externalVmOptionsFile = (Path)CollectionsKt.firstOrNull((List)PathsKt.listDirectoryEntries((Path)this.configDirPath, (String)"*.vmoptions"));
        if (externalVmOptionsFile != null) {
            Path currentVMFile = PathManager.getConfigDir().resolve(VMOptions.getFileName());
            Intrinsics.checkNotNull((Object)currentVMFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(currentVMFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                ConfigImportHelper.mergeVmOptions((Path)externalVmOptionsFile, (Path)currentVMFile, (Logger)JbSettingsImporterKt.access$getLOG$p());
            } else {
                Files.copy(externalVmOptionsFile, currentVMFile, new CopyOption[0]);
            }
            ConfigImportHelper.updateVMOptions((Path)PathManager.getConfigDir(), (Logger)JbSettingsImporterKt.access$getLOG$p());
        }
        CustomConfigMigrationOption.MigrateFromCustomPlace migrateFromCustomPlace = new CustomConfigMigrationOption.MigrateFromCustomPlace(this.configDirPath);
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        migrateFromCustomPlace.writeConfigMarkerFile(path);
        this.migrateLocalization();
        long it = System.currentTimeMillis() - startTime;
        boolean bl = false;
        JbSettingsImporterKt.access$getLOG$p().info("Raw import finished in " + it + " ms.");
        ImportSettingsEventsCollector.INSTANCE.jbTotalImportTimeSpent(it);
    }

    public final void migrateLocalization() {
        ConfigImportHelper.migrateLocalization((Path)this.configDirPath, (Path)this.pluginsPath);
    }

    private static final Unit importOptionsAfterRestart$lambda$0(JbSettingsImporter this$0, Set $components, Set $pluginIds, Set $files, Set $categories) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        ComponentManagerImpl componentManagerImpl = (ComponentManagerImpl)application;
        Set<String> availableComponents = this$0.loadNotLoadedComponents((ProgressIndicator)new EmptyProgressIndicator(), componentManagerImpl, $components, $pluginIds);
        ComponentReloadingKt.reloadComponents$default((ComponentStoreImpl)this$0.componentStore, (Collection)$files, (Collection)CollectionsKt.emptyList(), availableComponents, (boolean)false, (int)8, null);
        if ($categories.contains(SettingsCategory.KEYMAP)) {
            KeymapManager.getInstance();
            this$0.componentStore.reloadState(KeymapManagerImpl.class);
        }
        if ($categories.contains(SettingsCategory.UI) && !ExperimentalUI.Companion.getWasThemeReset()) {
            LafManager.getInstance();
            EditorColorsManager.getInstance();
            this$0.componentStore.reloadState(LafManagerImpl.class);
            this$0.componentStore.reloadState(EditorColorsManagerImpl.class);
        }
        return Unit.INSTANCE;
    }

    private static final Unit importOptions$lambda$2(ProgressIndicator $progressIndicator, JbSettingsImporter this$0, Set $allFiles, SchemeManagerImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $progressIndicator.checkCanceled();
        Path path = this$0.configDirPath.resolve(it.getFileSpec());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path path2 = this$0.configDirPath.resolve(it.getFileSpec());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            $allFiles.addAll(this$0.filesFromFolder(path2, it.getFileSpec()));
        }
        return Unit.INSTANCE;
    }

    private static final void importOptions$lambda$6$lambda$4(JbSettingsImporter this$0, Set $componentFiles, Set $schemeFiles, LinkedHashSet $appComponentNames) {
        ComponentReloadingKt.reloadComponents((ComponentStoreImpl)this$0.componentStore, (Collection)SetsKt.plus((Set)$componentFiles, (Iterable)$schemeFiles), (Collection)CollectionsKt.emptyList(), (Set)$appComponentNames, (boolean)true);
    }

    private static final void importOptions$lambda$6$lambda$5(ComponentStoreImpl $defaultProjectStore, Set $projectDefaultComponentNames, StateStorage $defaultProjectStorage) {
        $defaultProjectStore.reinitComponents($projectDefaultComponentNames, SetsKt.setOf((Object)$defaultProjectStorage), (Collection)SetsKt.emptySet());
    }

    private static final Unit importOptions$lambda$6(ProgressIndicator $progressIndicator, JbSettingsImporter this$0, Set $componentFiles, Set $schemeFiles, LinkedHashSet $appComponentNames, ComponentStoreImpl $defaultProjectStore, Set $projectDefaultComponentNames, StateStorage $defaultProjectStorage) {
        $progressIndicator.checkCanceled();
        ApplicationKt.getApplication().runReadAction(() -> JbSettingsImporter.importOptions$lambda$6$lambda$4(this$0, $componentFiles, $schemeFiles, $appComponentNames));
        $progressIndicator.checkCanceled();
        ApplicationKt.getApplication().runReadAction(() -> JbSettingsImporter.importOptions$lambda$6$lambda$5($defaultProjectStore, $projectDefaultComponentNames, $defaultProjectStorage));
        return Unit.INSTANCE;
    }

    private static final Unit loadNotLoadedComponents$lambda$7(ProgressIndicator $progressIndicator, Set $pluginIds, JbSettingsImporter this$0, Collection $componentsToLoad, ComponentManagerImpl $componentManagerImpl, ArrayList $notLoadedComponents, HashMap $foundComponents, String key, Class clazz, PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        $progressIndicator.checkCanceled();
        if (pluginDescriptor != null && $pluginIds != null && !$pluginIds.contains(pluginDescriptor.getPluginId().getIdString())) {
            return Unit.INSTANCE;
        }
        State state = this$0.getStateOrNull(clazz);
        if (state == null) {
            return Unit.INSTANCE;
        }
        State stateAnnotation = state;
        String componentName = stateAnnotation.name();
        if ($componentsToLoad.contains(componentName)) {
            Object service = $componentManagerImpl.getServiceByClassName(key);
            if (service != null) {
                $notLoadedComponents.remove(componentName);
                ((Map)$foundComponents).put(componentName, clazz);
            } else {
                JbSettingsImporterKt.access$getLOG$p().warn("Service " + key + " is not found");
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit filterComponents$lambda$9(JbSettingsImporter this$0, Set $categories, Set $allFiles, String $osFolderName, HashMap $retval, Class aClass, PluginDescriptor pluginDescriptor) {
        Storage storage;
        State state;
        block8: {
            Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
            State state2 = this$0.getStateOrNull(aClass);
            if (state2 == null) {
                return Unit.INSTANCE;
            }
            state = state2;
            if (!$categories.contains(state.category())) {
                return Unit.INSTANCE;
            }
            Storage[] storageArray = state.storages();
            int n = storageArray.length;
            for (int i = 0; i < n; ++i) {
                Storage storage2;
                Storage it = storage2 = storageArray[i];
                boolean bl = false;
                if (!(!it.deprecated())) continue;
                storage = storage2;
                break block8;
            }
            storage = null;
        }
        if (storage == null) {
            return Unit.INSTANCE;
        }
        Storage activeStorage = storage;
        if (Intrinsics.areEqual((Object)activeStorage.value(), (Object)"$CACHE_FILE$") || !activeStorage.roamingType().canBeMigrated() && !state.exportable() && !activeStorage.exportable()) {
            return Unit.INSTANCE;
        }
        if (activeStorage.roamingType().isOsSpecific() && $allFiles.contains($osFolderName + "/" + activeStorage.value())) {
            ((Map)$retval).put(state.name(), $osFolderName + "/" + activeStorage.value());
        } else if ($allFiles.contains(activeStorage.value())) {
            ((Map)$retval).put(state.name(), activeStorage.value());
        }
        return Unit.INSTANCE;
    }

    private static final Unit filterSchemes$lambda$10(Set $categories, HashSet $schemeCategories, SchemeManagerImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($categories.contains(it.getSettingsCategory())) {
            $schemeCategories.add(it.getFileSpec());
        }
        return Unit.INSTANCE;
    }

    private static final boolean installPlugins$lambda$11(IdeaPluginDescriptor it) {
        return false;
    }

    public static final /* synthetic */ Object access$withExternalStreamProvider(JbSettingsImporter $this, StateStorageManager[] storageManagers, Function0 action, Continuation $completion) {
        return $this.withExternalStreamProvider(storageManagers, (Function0<Unit>)action, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J.\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0016J\u0088\u0001\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00070\u00162K\u0010\u001d\u001aG\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00070\u001eH\u0016J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\""}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbSettingsImporter$ImportStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "configDirPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "isExclusive", "", "()Z", "saveStorageDataOnReload", "getSaveStorageDataOnReload", "isApplicable", "fileSpec", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "write", "", "content", "", "read", "consumer", "Lkotlin/Function1;", "Ljava/io/InputStream;", "processChildren", "path", "filter", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function3;", "input", "readOnly", "delete", "intellij.ide.startup.importSettings"})
    public static final class ImportStreamProvider
    implements StreamProvider {
        @NotNull
        private final Path configDirPath;
        private final boolean isExclusive;

        public ImportStreamProvider(@NotNull Path configDirPath) {
            Intrinsics.checkNotNullParameter((Object)configDirPath, (String)"configDirPath");
            this.configDirPath = configDirPath;
        }

        public boolean isExclusive() {
            return this.isExclusive;
        }

        public boolean getSaveStorageDataOnReload() {
            return false;
        }

        public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            return false;
        }

        public void write(@NotNull String fileSpec, @NotNull byte[] content, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        }

        public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            if (Intrinsics.areEqual((Object)fileSpec, (Object)"$APP_CONFIG$/project.default.xml")) {
                Path path = this.configDirPath.resolve("options");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Path path2 = path.resolve("project.default.xml");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                Path path3 = path2;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isRegularFile(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return false;
                }
                consumer.invoke((Object)new FileInputStream(path3.toFile()));
                return true;
            }
            Path path = this.configDirPath.resolve("options");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path4 = path.resolve(fileSpec);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            Path it = path4;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                consumer.invoke((Object)new FileInputStream(it.toFile()));
                return true;
            }
            Path path5 = this.configDirPath.resolve(fileSpec);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            it = path5;
            boolean bl2 = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                consumer.invoke((Object)new FileInputStream(it.toFile()));
                return true;
            }
            return false;
        }

        public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
            JbSettingsImporterKt.access$getLOG$p().debug("Process Children " + path);
            Path folder = this.configDirPath.resolve(path);
            Intrinsics.checkNotNull((Object)folder);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return true;
            }
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(filter, this, processor2){
                final /* synthetic */ Function1<String, Boolean> $filter;
                final /* synthetic */ ImportStreamProvider this$0;
                final /* synthetic */ Function3<String, InputStream, Boolean, Boolean> $processor;
                {
                    this.$filter = $filter;
                    this.this$0 = $receiver;
                    this.$processor = $processor;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!((Boolean)this.$filter.invoke((Object)PathsKt.getName((Path)file))).booleanValue()) {
                        return FileVisitResult.CONTINUE;
                    }
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        return FileVisitResult.CONTINUE;
                    }
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                    Closeable closeable = inputStream;
                    ImportStreamProvider importStreamProvider = this.this$0;
                    Function3<String, InputStream, Boolean, Boolean> function3 = this.$processor;
                    Throwable throwable = null;
                    try {
                        InputStream inputStream2 = (InputStream)closeable;
                        boolean bl2 = false;
                        Path path = ImportStreamProvider.access$getConfigDirPath$p(importStreamProvider).relativize(file);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
                        String fileSpec = PathsKt.getInvariantSeparatorsPathString((Path)path);
                        bl = StreamProvider.read$default((StreamProvider)importStreamProvider, (String)fileSpec, null, arg_0 -> processChildren.1.visitFile$lambda$1$lambda$0(function3, file, inputStream2, arg_0), (int)2, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    boolean shouldProceed = bl;
                    return shouldProceed ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
                }

                private static final Unit visitFile$lambda$1$lambda$0(Function3 $processor, Path $file, InputStream $inputStream, InputStream it) {
                    $processor.invoke((Object)((Object)$file.getFileName()).toString(), (Object)$inputStream, (Object)false);
                    return Unit.INSTANCE;
                }
            });
            return true;
        }

        public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            JbSettingsImporterKt.access$getLOG$p().debug("Deleting " + fileSpec);
            return false;
        }

        public static final /* synthetic */ Path access$getConfigDirPath$p(ImportStreamProvider $this) {
            return $this.configDirPath;
        }
    }
}

