/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/NewLineProcessor;", "", "jsonArray", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "lineToInsert", "", "<init>", "(Lcom/fasterxml/jackson/databind/node/ArrayNode;Ljava/lang/String;)V", "currentLine", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nextCharPosition", "", "pendingCarriageReturn", "", "modifyingLastLine", "backspace", "", "putCharAndCheckForCarriage", "c", "", "putChar", "carriageReturn", "newLine", "flushLine", "intellij.jupyter.core"})
public final class NewLineProcessor {
    @NotNull
    private final ArrayNode jsonArray;
    @NotNull
    private final StringBuilder currentLine;
    private int nextCharPosition;
    private boolean pendingCarriageReturn;
    private boolean modifyingLastLine;

    public NewLineProcessor(@NotNull ArrayNode jsonArray, @NotNull String lineToInsert) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        Intrinsics.checkNotNullParameter((Object)lineToInsert, (String)"lineToInsert");
        this.jsonArray = jsonArray;
        this.currentLine = new StringBuilder();
        int size = this.jsonArray.size();
        if (size > 0) {
            Character lastChar;
            String lastLine = this.jsonArray.get(size - 1).asText();
            Intrinsics.checkNotNull((Object)lastLine);
            Character c = lastChar = StringsKt.lastOrNull((CharSequence)lastLine);
            char c2 = '\n';
            if (c == null || c.charValue() != c2) {
                this.modifyingLastLine = true;
                this.currentLine.append(lastLine);
                Character c3 = lastChar;
                c2 = '\r';
                if (c3 != null && c3.charValue() == c2) {
                    this.pendingCarriageReturn = true;
                    this.currentLine.deleteCharAt(this.currentLine.length() - 1);
                } else {
                    this.nextCharPosition = this.currentLine.length();
                }
            }
        }
        int n = ((CharSequence)lineToInsert).length();
        block5: for (int i = 0; i < n; ++i) {
            char c = lineToInsert.charAt(i);
            switch (c) {
                case '\n': {
                    this.newLine();
                    continue block5;
                }
                case '\r': {
                    this.carriageReturn();
                    continue block5;
                }
                case '\b': {
                    this.backspace();
                    continue block5;
                }
                default: {
                    this.putCharAndCheckForCarriage(c);
                }
            }
        }
        if (this.pendingCarriageReturn) {
            this.putChar('\r');
        }
        this.flushLine();
    }

    private final void backspace() {
        if (((CharSequence)this.currentLine).length() > 0) {
            this.currentLine.deleteCharAt(this.currentLine.length() - 1);
            int n = this.nextCharPosition;
            this.nextCharPosition = n + -1;
        }
    }

    private final void putCharAndCheckForCarriage(char c) {
        if (this.pendingCarriageReturn) {
            this.nextCharPosition = 0;
            this.pendingCarriageReturn = false;
        }
        this.putChar(c);
    }

    private final void putChar(char c) {
        if (this.nextCharPosition < this.currentLine.length()) {
            this.currentLine.setCharAt(this.nextCharPosition, c);
        } else {
            this.currentLine.append(c);
        }
        int n = this.nextCharPosition;
        this.nextCharPosition = n + 1;
    }

    private final void carriageReturn() {
        if (!this.pendingCarriageReturn) {
            this.pendingCarriageReturn = true;
        }
    }

    private final void newLine() {
        this.nextCharPosition = this.currentLine.length();
        if (this.pendingCarriageReturn) {
            this.pendingCarriageReturn = false;
            this.putChar('\r');
        }
        this.putChar('\n');
        this.flushLine();
    }

    private final void flushLine() {
        String string = this.currentLine.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String line = string;
        if (((CharSequence)line).length() > 0) {
            if (!this.modifyingLastLine) {
                this.jsonArray.add(line);
            } else {
                this.jsonArray.set(this.jsonArray.size() - 1, (JsonNode)TextNode.valueOf((String)line));
            }
            StringsKt.clear((StringBuilder)this.currentLine);
        }
        this.modifyingLastLine = false;
    }
}

