/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.plist.Plist;

@Deprecated
public class Bundle {
    private static final FileFilter SYNTAX_FILES_FILTER = new BundleFilesFilter("tmlanguage", "plist", "tmlanguage.json");
    private static final FileFilter PREFERENCE_FILES_FILTER = new BundleFilesFilter("tmpreferences", "plist");
    protected final String myName;
    protected final File bundleFile;
    protected final BundleType myType;

    public Bundle(@NotNull String name, @NotNull String bundle, @NotNull BundleType type) {
        if (name == null) {
            Bundle.$$$reportNull$$$0(0);
        }
        if (bundle == null) {
            Bundle.$$$reportNull$$$0(1);
        }
        if (type == null) {
            Bundle.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.bundleFile = new File(bundle);
        this.myType = type;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Bundle.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Collection<File> getGrammarFiles() {
        switch (this.myType) {
            case TEXTMATE: {
                return this.getFilesInBundle("Syntaxes", SYNTAX_FILES_FILTER);
            }
            case SUBLIME: {
                return this.getFilesInBundle("", SYNTAX_FILES_FILTER);
            }
        }
        throw new IllegalArgumentException("Only textmate and sublime bundles are supported. Use TextMateBundleReader instead.");
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Collection<File> getPreferenceFiles() {
        switch (this.myType) {
            case TEXTMATE: {
                return this.getFilesInBundle("Preferences", PREFERENCE_FILES_FILTER);
            }
            case SUBLIME: {
                return this.getFilesInBundle("", PREFERENCE_FILES_FILTER);
            }
        }
        throw new IllegalArgumentException("Only textmate and sublime bundles are supported. Use TextMateBundleReader instead.");
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Collection<File> getSnippetFiles() {
        switch (this.myType) {
            case TEXTMATE: {
                return this.getFilesInBundle("Snippets", new BundleFilesFilter("tmsnippet", "plist"));
            }
            case SUBLIME: {
                List<File> list = Collections.emptyList();
                if (list == null) {
                    Bundle.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        throw new IllegalArgumentException("Only textmate and sublime bundles are supported. Use TextMateBundleReader instead.");
    }

    @NotNull
    private Collection<File> getFilesInBundle(@NotNull String path, @Nullable FileFilter filter) {
        if (path == null) {
            Bundle.$$$reportNull$$$0(5);
        }
        File[] files = null;
        try {
            files = new File(this.bundleFile, path).listFiles(filter);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Set<File> set = files != null && files.length > 0 ? Set.of(files) : Collections.emptySet();
        if (set == null) {
            Bundle.$$$reportNull$$$0(6);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bundle bundle = (Bundle)o;
        return FileUtilRt.filesEqual((File)this.bundleFile, (File)bundle.bundleFile);
    }

    public int hashCode() {
        return FileUtilRt.pathHashCode((String)this.bundleFile.getPath());
    }

    public String toString() {
        return "Bundle{name='" + this.myName + "', path='" + String.valueOf(this.bundleFile) + "', type=" + String.valueOf((Object)this.myType) + "}";
    }

    @Deprecated(forRemoval=true)
    public Collection<String> getExtensions(@NotNull File file, @NotNull Plist plist) {
        if (file == null) {
            Bundle.$$$reportNull$$$0(7);
        }
        if (plist == null) {
            Bundle.$$$reportNull$$$0(8);
        }
        return plist.getPlistValue("fileTypes", Collections.emptyList()).getStringArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/bundles/Bundle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/bundles/Bundle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesInBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInBundle";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    private static final class BundleFilesFilter
    implements FileFilter {
        private final Set<String> myExtensions;

        private BundleFilesFilter(String ... extensions) {
            this.myExtensions = Set.of(extensions);
        }

        @Override
        public boolean accept(@NotNull File path) {
            if (path == null) {
                BundleFilesFilter.$$$reportNull$$$0(0);
            }
            return this.myExtensions.contains(FileUtilRt.getExtension((String)path.getName()).toLowerCase(Locale.US));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/textmate/bundles/Bundle$BundleFilesFilter", "accept"));
        }
    }
}

