/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.colors.pages.ANSIColoredConsoleColorsPage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.dsl.builder.TextFieldWithHistoryWithBrowseButtonKt;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.DetectedShellInfo;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalColumnSpacing;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalFontSettings;
import org.jetbrains.plugins.terminal.TerminalFontSettingsService;
import org.jetbrains.plugins.terminal.TerminalFontSize;
import org.jetbrains.plugins.terminal.TerminalLineSpacing;
import org.jetbrains.plugins.terminal.TerminalOptionsConfigurableKt;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalShellsDetector;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptions;
import org.jetbrains.plugins.terminal.block.feedback.ReworkedTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptStyle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOptionsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOptionsConfigurable.kt\norg/jetbrains/plugins/terminal/TerminalOptionsConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,394:1\n1611#2,9:395\n1863#2:404\n1864#2:406\n1620#2:407\n1557#2:409\n1628#2,2:410\n774#2:412\n865#2,2:413\n1630#2:415\n1611#2,9:416\n1863#2:425\n1864#2:427\n1620#2:428\n1#3:405\n1#3:426\n31#4:408\n*S KotlinDebug\n*F\n+ 1 TerminalOptionsConfigurable.kt\norg/jetbrains/plugins/terminal/TerminalOptionsConfigurable\n*L\n111#1:395,9\n111#1:404\n111#1:406\n111#1:407\n220#1:409\n220#1:410,2\n221#1:412\n221#1:413,2\n220#1:415\n292#1:416,9\n292#1:425\n292#1:427\n292#1:428\n111#1:405\n292#1:426\n108#1:408\n*E\n"})
public final class TerminalOptionsConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;

    public TerminalOptionsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = IdeBundle.message((String)"configurable.TerminalOptionsConfigurable.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "reference.settings.terminal", "terminal");
        this.project = project;
    }

    @NotNull
    public DialogPanel createPanel() {
        TerminalOptionsProvider optionsProvider = TerminalOptionsProvider.Companion.getInstance();
        TerminalProjectOptionsProvider projectOptionsProvider = TerminalProjectOptionsProvider.Companion.getInstance(this.project);
        BlockTerminalOptions blockTerminalOptions = BlockTerminalOptions.Companion.getInstance();
        return com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67(optionsProvider, this, blockTerminalOptions, projectOptionsProvider, arg_0));
    }

    private static final Unit createPanel$lambda$67$lambda$11$lambda$3$lambda$0(LcrRow $this$listCellRenderer) {
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        Object object = (TerminalEngine)((Object)$this$listCellRenderer.getValue());
        if (object == null || (object = object.getPresentableName()) == null) {
            object = "";
        }
        LcrRow.text$default((LcrRow)$this$listCellRenderer, (String)object, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final TerminalEngine createPanel$lambda$67$lambda$11$lambda$3$lambda$1(TerminalOptionsProvider $optionsProvider) {
        return $optionsProvider.getTerminalEngine();
    }

    private static final Unit createPanel$lambda$67$lambda$11$lambda$3$lambda$2(TerminalOptionsProvider $optionsProvider, TerminalOptionsConfigurable this$0, TerminalEngine it) {
        TerminalEngine oldEngine = $optionsProvider.getTerminalEngine();
        TerminalEngine terminalEngine = it;
        Intrinsics.checkNotNull((Object)((Object)terminalEngine));
        TerminalEngine newEngine = terminalEngine;
        $optionsProvider.setTerminalEngine(newEngine);
        ReworkedTerminalFeedbackSurveyKt.askForFeedbackIfReworkedTerminalDisabled(this$0.project, oldEngine, newEngine);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$11$lambda$3(TerminalOptionsProvider $optionsProvider, Ref.ObjectRef $terminalEngineComboBox, TerminalOptionsConfigurable this$0, Row $this$row) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if (TerminalUtil.isGenOneTerminalOptionVisible() || $optionsProvider.getTerminalEngine() == TerminalEngine.NEW_TERMINAL) {
            var5_4 = new TerminalEngine[]{TerminalEngine.REWORKED, TerminalEngine.CLASSIC, TerminalEngine.NEW_TERMINAL};
            list = CollectionsKt.listOf((Object[])var5_4);
        } else {
            var5_4 = new TerminalEngine[]{TerminalEngine.REWORKED, TerminalEngine.CLASSIC};
            list = CollectionsKt.listOf((Object[])var5_4);
        }
        List values = list;
        ListCellRenderer renderer = BuilderKt.listCellRenderer(TerminalOptionsConfigurable::createPanel$lambda$67$lambda$11$lambda$3$lambda$0);
        Cell cell = $this$row.comboBox((Collection)values, renderer);
        String string = TerminalBundle.message("settings.terminal.engine", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $terminalEngineComboBox.element = ComboBoxKt.bindItem((Cell)Cell.label$default((Cell)cell, (String)string, null, (int)2, null), () -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$11$lambda$3$lambda$1($optionsProvider), arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$11$lambda$3$lambda$2($optionsProvider, this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$11$lambda$10$lambda$7$lambda$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.singleLine.prompt", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, (Object)TerminalPromptStyle.SINGLE_LINE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$11$lambda$10$lambda$7$lambda$5(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.doubleLine.prompt", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, (Object)TerminalPromptStyle.DOUBLE_LINE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$11$lambda$10$lambda$7$lambda$6(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.shell.prompt", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, (Object)TerminalPromptStyle.SHELL);
        String string2 = TerminalBundle.message("settings.shell.prompt.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.contextHelp$default((Row)$this$row, (String)string2, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$11$lambda$10$lambda$7(Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$11$lambda$10$lambda$7$lambda$4, (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$11$lambda$10$lambda$7$lambda$5, (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$11$lambda$10$lambda$7$lambda$6, (int)1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPanel$lambda$67$lambda$11$lambda$10$lambda$9(TerminalOptionsConfigurable this$0, Panel $this$panel) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Iterable iterable = LocalTerminalCustomizer.EP_NAME.getExtensionList();
        Panel panel = $this$panel;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnnamedConfigurable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LocalTerminalCustomizer it = (LocalTerminalCustomizer)element$iv$iv;
            boolean bl2 = false;
            if (it.getBlockTerminalConfigurable(this$0.project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        TerminalOptionsConfigurableKt.access$configurables(panel, (List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPanel$lambda$67$lambda$11$lambda$10(BlockTerminalOptions $blockTerminalOptions, TerminalOptionsConfigurable this$0, Panel $this$indent) {
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$indent, (String)TerminalBundle.message("settings.prompt.style", new Object[0]), (boolean)false, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$11$lambda$10$lambda$7, (int)2, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl($blockTerminalOptions){

            public Object get() {
                return ((BlockTerminalOptions)this.receiver).getPromptStyle();
            }

            public void set(Object value) {
                ((BlockTerminalOptions)this.receiver).setPromptStyle((TerminalPromptStyle)((Object)value));
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), TerminalPromptStyle.class);
        $this$indent.panel(arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$11$lambda$10$lambda$9(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$11(Ref.ObjectRef $terminalEngineComboBox, TerminalOptionsProvider $optionsProvider, TerminalOptionsConfigurable this$0, BlockTerminalOptions $blockTerminalOptions, Panel $this$panel) {
        ComboBox comboBox;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$11$lambda$3($optionsProvider, $terminalEngineComboBox, this$0, arg_0), (int)1, null);
        RowsRange rowsRange = $this$panel.indent(arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$11$lambda$10($blockTerminalOptions, this$0, arg_0));
        if ($terminalEngineComboBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"terminalEngineComboBox");
            comboBox = null;
        } else {
            comboBox = (ComboBox)$terminalEngineComboBox.element;
        }
        rowsRange.visibleIf(ComponentPredicateKt.selectedValueIs((JComboBox)((JComboBox)comboBox), (Object)((Object)TerminalEngine.NEW_TERMINAL)));
        return Unit.INSTANCE;
    }

    private static final JTextField createPanel$lambda$67$lambda$21$lambda$15$lambda$12(TextFieldWithBrowseButton $this$setupDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$setupDefaultValue, (String)"$this$setupDefaultValue");
        JComponent jComponent = $this$setupDefaultValue.getChildComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
        return (JTextField)jComponent;
    }

    private static final String createPanel$lambda$67$lambda$21$lambda$15$lambda$13(TerminalProjectOptionsProvider $projectOptionsProvider) {
        String string = $projectOptionsProvider.getStartingDirectory();
        if (string == null && (string = $projectOptionsProvider.getDefaultStartingDirectory()) == null) {
            string = "";
        }
        return string;
    }

    private static final Unit createPanel$lambda$67$lambda$21$lambda$15$lambda$14(TerminalProjectOptionsProvider $projectOptionsProvider, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $projectOptionsProvider.setStartingDirectory(it);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$21$lambda$15(TerminalOptionsConfigurable this$0, TerminalProjectOptionsProvider $projectOptionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withDescription(TerminalBundle.message("settings.start.directory.browseFolder.description", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withDescription(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)TerminalOptionsConfigurableKt.access$setupDefaultValue(Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, (Project)this$0.project, null, (int)4, null), TerminalOptionsConfigurable::createPanel$lambda$67$lambda$21$lambda$15$lambda$12, $projectOptionsProvider.getDefaultStartingDirectory()), () -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$21$lambda$15$lambda$13($projectOptionsProvider), arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$21$lambda$15$lambda$14($projectOptionsProvider, arg_0)).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final EnvironmentVariablesData createPanel$lambda$67$lambda$21$lambda$20$lambda$16(EnvironmentVariablesTextFieldWithBrowseButton component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        EnvironmentVariablesData environmentVariablesData = component2.getData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getData(...)");
        return environmentVariablesData;
    }

    private static final Unit createPanel$lambda$67$lambda$21$lambda$20$lambda$17(EnvironmentVariablesTextFieldWithBrowseButton component2, EnvironmentVariablesData data) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        component2.setData(data);
        return Unit.INSTANCE;
    }

    private static final EnvironmentVariablesData createPanel$lambda$67$lambda$21$lambda$20$lambda$18(TerminalProjectOptionsProvider $projectOptionsProvider) {
        return $projectOptionsProvider.getEnvData();
    }

    private static final Unit createPanel$lambda$67$lambda$21$lambda$20$lambda$19(TerminalProjectOptionsProvider $projectOptionsProvider, EnvironmentVariablesData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $projectOptionsProvider.setEnvData(it);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$21$lambda$20(TerminalProjectOptionsProvider $projectOptionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)new EnvironmentVariablesTextFieldWithBrowseButton()).bind(TerminalOptionsConfigurable::createPanel$lambda$67$lambda$21$lambda$20$lambda$16, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$21$lambda$20$lambda$17, MutablePropertyKt.MutableProperty(() -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$21$lambda$20$lambda$18($projectOptionsProvider), arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$21$lambda$20$lambda$19($projectOptionsProvider, arg_0))).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$21(TerminalOptionsConfigurable this$0, TerminalProjectOptionsProvider $projectOptionsProvider, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        String string = TerminalBundle.message("settings.start.directory", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$21$lambda$15(this$0, $projectOptionsProvider, arg_0));
        String string2 = TerminalBundle.message("settings.environment.variables", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$group.row(string2, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$21$lambda$20($projectOptionsProvider, arg_0));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$67$lambda$42$lambda$30$lambda$22(FontComboBox comboBox) {
        Intrinsics.checkNotNullParameter((Object)comboBox, (String)"comboBox");
        return comboBox.getFontName();
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$30$lambda$23(FontComboBox comboBox, String value) {
        Intrinsics.checkNotNullParameter((Object)comboBox, (String)"comboBox");
        comboBox.setFontName(value);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$67$lambda$42$lambda$30$lambda$24(Ref.ObjectRef $fontSettings) {
        return ((TerminalFontSettings)$fontSettings.element).getFontFamily();
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$30$lambda$25(Ref.ObjectRef $fontSettings, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $fontSettings.element = TerminalFontSettings.copy$default((TerminalFontSettings)$fontSettings.element, it, null, null, null, null, 30, null);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$67$lambda$42$lambda$30$lambda$26(FontComboBox comboBox) {
        Intrinsics.checkNotNullParameter((Object)comboBox, (String)"comboBox");
        return comboBox.getFontName();
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$30$lambda$27(FontComboBox comboBox, String value) {
        Intrinsics.checkNotNullParameter((Object)comboBox, (String)"comboBox");
        comboBox.setFontName(value);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$67$lambda$42$lambda$30$lambda$28(Ref.ObjectRef $fontSettings) {
        return ((TerminalFontSettings)$fontSettings.element).getFallbackFontFamily();
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$30$lambda$29(Ref.ObjectRef $fontSettings, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $fontSettings.element = TerminalFontSettings.copy$default((TerminalFontSettings)$fontSettings.element, null, it, null, null, null, 29, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$30(Ref.ObjectRef $fontSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)TerminalOptionsConfigurableKt.access$fontComboBox()).bind(TerminalOptionsConfigurable::createPanel$lambda$67$lambda$42$lambda$30$lambda$22, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$42$lambda$30$lambda$23, MutablePropertyKt.toNullableProperty((MutableProperty)MutablePropertyKt.MutableProperty(() -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$30$lambda$24($fontSettings), arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$30$lambda$25($fontSettings, arg_0))));
        Cell cell = $this$row.cell((JComponent)TerminalOptionsConfigurableKt.access$fontComboBox());
        String string = TerminalBundle.message("settings.fallback.font.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.label$default((Cell)cell, (String)string, null, (int)2, null).bind(TerminalOptionsConfigurable::createPanel$lambda$67$lambda$42$lambda$30$lambda$26, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$42$lambda$30$lambda$27, MutablePropertyKt.toNullableProperty((MutableProperty)MutablePropertyKt.MutableProperty(() -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$30$lambda$28($fontSettings), arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$30$lambda$29($fontSettings, arg_0))));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$67$lambda$42$lambda$37$lambda$31(Ref.ObjectRef $fontSettings) {
        return ((TerminalFontSettings)$fontSettings.element).getFontSize().toFormattedString();
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$37$lambda$32(Ref.ObjectRef $fontSettings, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $fontSettings.element = TerminalFontSettings.copy$default((TerminalFontSettings)$fontSettings.element, null, null, TerminalFontSize.Companion.parse(it), null, null, 27, null);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$67$lambda$42$lambda$37$lambda$33(Ref.ObjectRef $fontSettings) {
        return ((TerminalFontSettings)$fontSettings.element).getLineSpacing().toFormattedString();
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$37$lambda$34(Ref.ObjectRef $fontSettings, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $fontSettings.element = TerminalFontSettings.copy$default((TerminalFontSettings)$fontSettings.element, null, null, null, TerminalLineSpacing.Companion.parse(it), null, 23, null);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$67$lambda$42$lambda$37$lambda$35(Ref.ObjectRef $fontSettings) {
        return ((TerminalFontSettings)$fontSettings.element).getColumnSpacing().toFormattedString();
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$37$lambda$36(Ref.ObjectRef $fontSettings, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $fontSettings.element = TerminalFontSettings.copy$default((TerminalFontSettings)$fontSettings.element, null, null, null, null, TerminalColumnSpacing.Companion.parse(it), 15, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$37(Ref.ObjectRef $fontSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = $this$row.textField();
        String string = TerminalBundle.message("settings.font.size", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TextFieldKt.bindText((Cell)TextFieldKt.columns((Cell)Cell.label$default((Cell)cell, (String)string, null, (int)2, null), (int)4), () -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$37$lambda$31($fontSettings), arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$37$lambda$32($fontSettings, arg_0));
        Cell cell2 = $this$row.textField();
        String string2 = TerminalBundle.message("settings.line.height", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        TextFieldKt.bindText((Cell)TextFieldKt.columns((Cell)Cell.label$default((Cell)cell2, (String)string2, null, (int)2, null), (int)4), () -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$37$lambda$33($fontSettings), arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$37$lambda$34($fontSettings, arg_0));
        Cell cell3 = $this$row.textField();
        String string3 = TerminalBundle.message("settings.column.width", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        TextFieldKt.bindText((Cell)TextFieldKt.columns((Cell)Cell.label$default((Cell)cell3, (String)string3, null, (int)2, null), (int)4), () -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$37$lambda$35($fontSettings), arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$37$lambda$36($fontSettings, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$39$lambda$38(Ref.ObjectRef $terminalEngineComboBox, ActionEvent actionEvent) {
        ComboBox comboBox;
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
        Object object = actionEvent.getSource();
        DataContext dataContext = DataManager.getInstance().getDataContext(object instanceof Component ? (Component)object : null);
        if ($terminalEngineComboBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"terminalEngineComboBox");
            comboBox = null;
        } else {
            comboBox = (ComboBox)$terminalEngineComboBox.element;
        }
        ColorAndFontOptions.selectOrEditColor((DataContext)dataContext, (String)(comboBox.getSelectedItem() == TerminalEngine.REWORKED ? ANSIColoredConsoleColorsPage.getSearchableReworkedTerminalName() : ANSIColoredConsoleColorsPage.getSearchableClassicTerminalName()), (String)ANSIColoredConsoleColorsPage.getSearchableName());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$39(Ref.ObjectRef $terminalEngineComboBox, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.colors", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.cell((JComponent)new ActionLink(string, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$39$lambda$38($terminalEngineComboBox, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$67$lambda$42$lambda$40(TerminalEngine it) {
        return it == TerminalEngine.REWORKED || it == TerminalEngine.CLASSIC;
    }

    private static final Unit createPanel$lambda$67$lambda$42$lambda$41(Ref.ObjectRef $fontSettings) {
        TerminalFontSettingsService.Companion.getInstance().setSettings$intellij_terminal((TerminalFontSettings)$fontSettings.element);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$42(Ref.ObjectRef $terminalEngineComboBox, Panel $this$group) {
        ComboBox comboBox;
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Ref.ObjectRef fontSettings = new Ref.ObjectRef();
        fontSettings.element = TerminalFontSettingsService.Companion.getInstance().getSettings();
        String string = TerminalBundle.message("settings.font.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$30(fontSettings, arg_0));
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$37(fontSettings, arg_0), (int)1, null);
        Row row = Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$39($terminalEngineComboBox, arg_0), (int)1, null);
        if ($terminalEngineComboBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"terminalEngineComboBox");
            comboBox = null;
        } else {
            comboBox = (ComboBox)$terminalEngineComboBox.element;
        }
        row.visibleIf(ComponentPredicateKt.selectedValueMatches((JComboBox)((JComboBox)comboBox), TerminalOptionsConfigurable::createPanel$lambda$67$lambda$42$lambda$40));
        $this$group.onApply(() -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42$lambda$41(fontSettings));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List createPanel$lambda$67$lambda$66$lambda$47$lambda$45() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = TerminalShellsDetector.detectShells();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void shellInfo;
            DetectedShellInfo detectedShellInfo = (DetectedShellInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = shellInfo.getOptions();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)"-i") && !LocalTerminalDirectRunner.LOGIN_CLI_OPTIONS.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List filteredOptions = (List)destination$iv$iv2;
            List shellCommand = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)shellInfo.getPath()), (Iterable)filteredOptions);
            collection.add(ParametersListUtil.join((List)shellCommand));
        }
        return (List)var3_3;
    }

    private static final JTextField createPanel$lambda$67$lambda$66$lambda$47$lambda$46(TextFieldWithHistoryWithBrowseButton $this$setupDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$setupDefaultValue, (String)"$this$setupDefaultValue");
        JTextField jTextField = ((TextFieldWithHistory)$this$setupDefaultValue.getChildComponent()).getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        return jTextField;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$47(TerminalOptionsConfigurable this$0, TerminalProjectOptionsProvider $projectOptionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Project project = this$0.project;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withDescription(TerminalBundle.message("settings.terminal.shell.executable.path.browseFolder.description", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withDescription(...)");
        TextFieldWithHistoryWithBrowseButtonKt.bindText((Cell)TerminalOptionsConfigurableKt.access$setupDefaultValue($this$row.cell((JComponent)ComponentsKt.textFieldWithHistoryWithBrowseButton$default((Project)project, (FileChooserDescriptor)fileChooserDescriptor, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$66$lambda$47$lambda$45, null, (int)8, null)), TerminalOptionsConfigurable::createPanel$lambda$67$lambda$66$lambda$47$lambda$46, $projectOptionsProvider.defaultShellPath()), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($projectOptionsProvider){

            public Object get() {
                return ((TerminalProjectOptionsProvider)this.receiver).getShellPath();
            }

            public void set(Object value) {
                ((TerminalProjectOptionsProvider)this.receiver).setShellPath((String)value);
            }
        })).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$48(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getTabName();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setTabName((String)value);
            }
        })).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$49(BlockTerminalOptions $blockTerminalOptions, Ref.ObjectRef $terminalEngineComboBox, Row $this$row) {
        ComboBox comboBox;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.show.separators.between.blocks", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($blockTerminalOptions){

            public Object get() {
                return ((BlockTerminalOptions)this.receiver).getShowSeparatorsBetweenBlocks();
            }

            public void set(Object value) {
                ((BlockTerminalOptions)this.receiver).setShowSeparatorsBetweenBlocks((Boolean)value);
            }
        }));
        if ($terminalEngineComboBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"terminalEngineComboBox");
            comboBox = null;
        } else {
            comboBox = (ComboBox)$terminalEngineComboBox.element;
        }
        cell.visibleIf(ComponentPredicateKt.selectedValueIs((JComboBox)((JComboBox)comboBox), (Object)((Object)TerminalEngine.REWORKED)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$50(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.audible.bell", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getAudibleBell();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setAudibleBell((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$51(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.close.session.when.it.ends", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getCloseSessionOnLogout();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setCloseSessionOnLogout((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$52(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.mouse.reporting", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getMouseReporting();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setMouseReporting((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$67$lambda$66$lambda$55$lambda$53() {
        return AdvancedSettings.Companion.getBoolean("terminal.escape.moves.focus.to.editor");
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$55$lambda$54(boolean it) {
        AdvancedSettings.Companion.setBoolean("terminal.escape.moves.focus.to.editor", it);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$55(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"advanced.setting.terminal.escape.moves.focus.to.editor", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), TerminalOptionsConfigurable::createPanel$lambda$67$lambda$66$lambda$55$lambda$53, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$66$lambda$55$lambda$54);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$56(TerminalOptionsProvider $optionsProvider, TerminalOptionsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.copy.to.clipboard.on.selection", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getCopyOnSelection();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setCopyOnSelection((Boolean)value);
            }
        })).visible(TerminalOptionsConfigurableKt.access$isMac(this$0.project) || TerminalOptionsConfigurableKt.access$isWindows(this$0.project));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$57(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.paste.on.middle.mouse.button.click", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getPasteOnMiddleMouseButton();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setPasteOnMiddleMouseButton((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$58(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.override.ide.shortcuts", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getOverrideIdeShortcuts();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setOverrideIdeShortcuts((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$59(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.shell.integration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getShellIntegration();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setShellIntegration((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$60(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.highlight.hyperlinks", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getHighlightHyperlinks();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setHighlightHyperlinks((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$61(TerminalOptionsProvider $optionsProvider, TerminalOptionsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TerminalBundle.message("settings.use.option.as.meta.key.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getUseOptionAsMetaKey();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setUseOptionAsMetaKey((Boolean)value);
            }
        })).visible(TerminalOptionsConfigurableKt.access$isMac(this$0.project));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPanel$lambda$67$lambda$66$lambda$63(TerminalOptionsConfigurable this$0, Panel $this$panel) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Iterable iterable = LocalTerminalCustomizer.EP_NAME.getExtensionList();
        Panel panel = $this$panel;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnnamedConfigurable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LocalTerminalCustomizer it = (LocalTerminalCustomizer)element$iv$iv;
            boolean bl2 = false;
            if (it.getConfigurable(this$0.project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        TerminalOptionsConfigurableKt.access$configurables(panel, (List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$67$lambda$66$lambda$65$lambda$64(TerminalUiSettingsManager.CursorShape it) {
        TerminalUiSettingsManager.CursorShape cursorShape = it;
        return cursorShape != null ? cursorShape.getText() : null;
    }

    private static final Unit createPanel$lambda$67$lambda$66$lambda$65(TerminalOptionsProvider $optionsProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)TerminalUiSettingsManager.CursorShape.getEntries(), BuilderKt.textListCellRenderer(TerminalOptionsConfigurable::createPanel$lambda$67$lambda$66$lambda$65$lambda$64)), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($optionsProvider){

            public Object get() {
                return ((TerminalOptionsProvider)this.receiver).getCursorShape();
            }

            public void set(Object value) {
                ((TerminalOptionsProvider)this.receiver).setCursorShape((TerminalUiSettingsManager.CursorShape)value);
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67$lambda$66(TerminalOptionsConfigurable this$0, TerminalProjectOptionsProvider $projectOptionsProvider, TerminalOptionsProvider $optionsProvider, BlockTerminalOptions $blockTerminalOptions, Ref.ObjectRef $terminalEngineComboBox, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        String string = TerminalBundle.message("settings.shell.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$47(this$0, $projectOptionsProvider, arg_0));
        String string2 = TerminalBundle.message("settings.tab.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$group.row(string2, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$48($optionsProvider, arg_0));
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$49($blockTerminalOptions, $terminalEngineComboBox, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$50($optionsProvider, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$51($optionsProvider, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$52($optionsProvider, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, TerminalOptionsConfigurable::createPanel$lambda$67$lambda$66$lambda$55, (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$56($optionsProvider, this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$57($optionsProvider, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$58($optionsProvider, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$59($optionsProvider, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$60($optionsProvider, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$61($optionsProvider, this$0, arg_0), (int)1, null);
        $this$group.panel(arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$63(this$0, arg_0));
        String string3 = TerminalBundle.message("settings.cursor.shape.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$group.row(string3, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66$lambda$65($optionsProvider, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$67(TerminalOptionsProvider $optionsProvider, TerminalOptionsConfigurable this$0, BlockTerminalOptions $blockTerminalOptions, TerminalProjectOptionsProvider $projectOptionsProvider, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Ref.ObjectRef terminalEngineComboBox = new Ref.ObjectRef();
        $this$panel.panel(arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$11(terminalEngineComboBox, $optionsProvider, this$0, $blockTerminalOptions, arg_0)).visibleIf(TerminalOptionsConfigurableKt.access$newUiPredicate());
        Panel.group$default((Panel)$this$panel, (String)TerminalBundle.message("settings.terminal.project.settings", new Object[0]), (boolean)false, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$21(this$0, $projectOptionsProvider, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)TerminalBundle.message("settings.terminal.font.settings", new Object[0]), (boolean)false, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$42(terminalEngineComboBox, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)TerminalBundle.message("settings.terminal.application.settings", new Object[0]), (boolean)false, arg_0 -> TerminalOptionsConfigurable.createPanel$lambda$67$lambda$66(this$0, $projectOptionsProvider, $optionsProvider, $blockTerminalOptions, terminalEngineComboBox, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }
}

