/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.cherrypick.GitCherryPickProcess;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitCherryPicker
extends VcsCherryPicker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;

    public GitCherryPicker(@NotNull Project project) {
        if (project == null) {
            GitCherryPicker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
    }

    public boolean cherryPick(@NotNull List<? extends VcsCommitMetadata> commits) {
        ProgressIndicator indicator;
        if (commits == null) {
            GitCherryPicker.$$$reportNull$$$0(1);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setIndeterminate(false);
        }
        GitCherryPickProcess cherryPickProcess = new GitCherryPickProcess(this.myProject, commits, indicator);
        cherryPickProcess.execute();
        return cherryPickProcess.isSuccess();
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            GitCherryPicker.$$$reportNull$$$0(2);
        }
        return vcsKey;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getActionTitle() {
        String string = DvcsBundle.message((String)"cherry.pick.action.text", (Object[])new Object[0]);
        if (string == null) {
            GitCherryPicker.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean canHandleForRoots(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            GitCherryPicker.$$$reportNull$$$0(4);
        }
        return ContainerUtil.all(roots, r -> this.myRepositoryManager.getRepositoryForRootQuick((VirtualFile)r) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/cherrypick/GitCherryPicker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/cherrypick/GitCherryPicker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canHandleForRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

