/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import git4idea.i18n.GitBundle;
import git4idea.ui.branch.dashboard.BranchesDashboardActions;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeModel;
import git4idea.ui.branch.dashboard.BranchesTreeStateHolder;
import git4idea.ui.branch.dashboard.BranchesTreeStateProvider;
import git4idea.ui.branch.dashboard.FilteringBranchesTree;
import git4idea.ui.branch.dashboard.FilteringBranchesTreeBase;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0012\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0014J\u0012\u0010$\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010%\u001a\u00020 H\u0002J\u0016\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0012J\u001e\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020 0,H\u0002J\b\u0010-\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTreeBase;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lgit4idea/ui/branch/dashboard/BranchesTreeModel;", "component", "Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "place", "", "Lorg/jetbrains/annotations/NonNls;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/BranchesTreeModel;Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Ljava/lang/String;Lcom/intellij/openapi/Disposable;)V", "getComponent", "()Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "initialUpdateDone", "", "expandedPaths", "Ljava/util/HashSet;", "Ljavax/swing/tree/TreePath;", "Lkotlin/collections/HashSet;", "treeStateProvider", "Lgit4idea/ui/branch/dashboard/BranchesTreeStateProvider;", "treeStateHolder", "Lgit4idea/ui/branch/dashboard/BranchesTreeStateHolder;", "getTreeStateHolder", "()Lgit4idea/ui/branch/dashboard/BranchesTreeStateHolder;", "installSearchField", "Lcom/intellij/ui/SearchTextField;", "setupTreeListeners", "", "restorePreviouslyExpandedPaths", "expandTreeOnSearchUpdateComplete", "pattern", "onSpeedSearchUpdateComplete", "updateSpeedSearchBackground", "update", "initial", "repaint", "runPreservingTreeState", "loadSaved", "runnable", "Lkotlin/Function0;", "initDefaultTreeExpandState", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/FilteringBranchesTree\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,518:1\n31#2,2:519\n*S KotlinDebug\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/FilteringBranchesTree\n*L\n262#1:519,2\n*E\n"})
public final class FilteringBranchesTree
extends FilteringBranchesTreeBase {
    @NotNull
    private final Project project;
    @NotNull
    private final BranchesTreeComponent component;
    @NotNull
    private final Disposable disposable;
    private boolean initialUpdateDone;
    @NotNull
    private final HashSet<TreePath> expandedPaths;
    @NotNull
    private final BranchesTreeStateProvider treeStateProvider;

    public FilteringBranchesTree(@NotNull Project project, final @NotNull BranchesTreeModel model, @NotNull BranchesTreeComponent component2, @NotNull String place, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)((Object)component2), (String)"component");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(model, (Tree)component2);
        this.project = project;
        this.component = component2;
        this.disposable = disposable;
        Tree tree = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"getTree(...)");
        UiNotifyConnector.Companion.installOn((Component)tree, new Activatable(){
            private final listener.1 listener;
            {
                this.listener = new BranchesTreeModel.Listener(this, $model, $receiver){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ BranchesTreeModel $model;
                    final /* synthetic */ FilteringBranchesTree this$1;
                    {
                        this.this$0 = $receiver;
                        this.$model = $model;
                        this.this$1 = $receiver2;
                    }

                    public void onTreeChange() {
                        1.access$updateTree(this.this$0);
                    }

                    public void onLoadingStateChange() {
                        if (this.$model.isLoading()) {
                            this.this$1.getComponent().getEmptyText().setText(GitBundle.message("action.Git.Loading.Branches.progress", new Object[0]));
                        } else {
                            this.this$1.getComponent().getEmptyText().setText(StatusText.getDefaultEmptyText());
                        }
                    }
                };
            }

            public void showNotify() {
                this.updateTree();
                model.addListener(this.listener);
            }

            public void hideNotify() {
                model.removeListener(this.listener);
            }

            private final void updateTree() {
                this.runPreservingTreeState(!initialUpdateDone, (Function0<Unit>)() -> 1.updateTree$lambda$0(this));
                initialUpdateDone = true;
            }

            private static final Unit updateTree$lambda$0(FilteringBranchesTree this$0) {
                this$0.getSearchModel().updateStructure();
                return Unit.INSTANCE;
            }

            public static final /* synthetic */ void access$updateTree(1 $this) {
                $this.updateTree();
            }
        });
        this.expandedPaths = new HashSet();
        this.treeStateProvider = new BranchesTreeStateProvider(this, this.disposable);
        ActionsKt.runInEdt$default(null, () -> FilteringBranchesTree._init_$lambda$1(this, place), (int)1, null);
    }

    @NotNull
    public final BranchesTreeComponent getComponent() {
        return this.component;
    }

    private final BranchesTreeStateHolder getTreeStateHolder() {
        Object object = BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.disposable, () -> FilteringBranchesTree._get_treeStateHolder_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runUnderDisposeAwareIndicator(...)");
        return (BranchesTreeStateHolder)object;
    }

    @NotNull
    public SearchTextField installSearchField() {
        SearchTextField searchTextField = super.installSearchField();
        Intrinsics.checkNotNullExpressionValue((Object)searchTextField, (String)"installSearchField(...)");
        SearchTextField searchField = searchTextField;
        this.component.setSearchField(searchField);
        return searchField;
    }

    private final void setupTreeListeners() {
        this.component.addTreeExpansionListener(new TreeExpansionListener(this){
            final /* synthetic */ FilteringBranchesTree this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).add(event.getPath());
                FilteringBranchesTree.access$getTreeStateHolder(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).remove(event.getPath());
                FilteringBranchesTree.access$getTreeStateHolder(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }
        });
        this.component.addTreeSelectionListener(arg_0 -> FilteringBranchesTree.setupTreeListeners$lambda$2(this, arg_0));
    }

    private final void restorePreviouslyExpandedPaths() {
        TreeUtil.restoreExpandedPaths((JTree)((JTree)((Object)this.component)), (List)CollectionsKt.toList((Iterable)this.expandedPaths));
    }

    protected void expandTreeOnSearchUpdateComplete(@Nullable String pattern) {
        this.restorePreviouslyExpandedPaths();
    }

    protected void onSpeedSearchUpdateComplete(@Nullable String pattern) {
        this.updateSpeedSearchBackground();
    }

    private final void updateSpeedSearchBackground() {
        SpeedSearchSupply speedSearchSupply = this.getSearchModel().getSpeedSearch();
        SpeedSearch speedSearch = speedSearchSupply instanceof SpeedSearch ? (SpeedSearch)speedSearchSupply : null;
        if (speedSearch == null) {
            return;
        }
        SpeedSearch speedSearch2 = speedSearch;
        SearchTextField searchTextField = this.component.getSearchField();
        if (searchTextField == null || (searchTextField = searchTextField.getTextEditor()) == null) {
            return;
        }
        SearchTextField textEditor = searchTextField;
        if (this.isEmptyModel()) {
            textEditor.setOpaque(true);
            speedSearch2.noHits();
        } else {
            textEditor.setOpaque(false);
            textEditor.setBackground(UIUtil.getTextFieldBackground());
        }
    }

    public final void update(boolean initial, boolean repaint) {
        this.runPreservingTreeState(initial, (Function0<Unit>)((Function0)() -> FilteringBranchesTree.update$lambda$3(this)));
        if (repaint) {
            this.getTree().revalidate();
            this.getTree().repaint();
        }
    }

    private final void runPreservingTreeState(boolean loadSaved, Function0<Unit> runnable) {
        if (Registry.Companion.is("git.branches.panel.persist.tree.state")) {
            TreeState treeState = loadSaved ? this.getTreeStateHolder().getInitialTreeState() : TreeState.createOn((JTree)((JTree)this.getTree()), (DefaultMutableTreeNode)this.getRoot());
            runnable.invoke();
            if (treeState != null) {
                treeState.applyTo((JTree)this.getTree());
            } else {
                this.initDefaultTreeExpandState();
            }
        } else {
            runnable.invoke();
            if (loadSaved) {
                this.initDefaultTreeExpandState();
            }
        }
    }

    private final void initDefaultTreeExpandState() {
        if (TreeUtil.hasManyNodes((Tree)this.getTree(), (int)30000)) {
            TreeUtil.collapseAll((JTree)((JTree)this.getTree()), (int)1);
        } else {
            TreeUtil.expandAll((JTree)((JTree)this.getTree()));
        }
    }

    private static final BranchesTreeStateHolder _get_treeStateHolder_$lambda$0(FilteringBranchesTree this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<BranchesTreeStateHolder> serviceClass$iv = BranchesTreeStateHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (BranchesTreeStateHolder)object;
    }

    private static final Unit _init_$lambda$1(FilteringBranchesTree this$0, String $place) {
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this$0.component)), (ActionGroup)new BranchesDashboardActions.BranchesTreeActionGroup(), (String)$place);
        this$0.setupTreeListeners();
        return Unit.INSTANCE;
    }

    private static final void setupTreeListeners$lambda$2(FilteringBranchesTree this$0, TreeSelectionEvent it) {
        this$0.getTreeStateHolder().setStateProvider(this$0.treeStateProvider);
    }

    private static final Unit update$lambda$3(FilteringBranchesTree this$0) {
        this$0.getSearchModel().updateStructure();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ HashSet access$getExpandedPaths$p(FilteringBranchesTree $this) {
        return $this.expandedPaths;
    }

    public static final /* synthetic */ BranchesTreeStateHolder access$getTreeStateHolder(FilteringBranchesTree $this) {
        return $this.getTreeStateHolder();
    }

    public static final /* synthetic */ BranchesTreeStateProvider access$getTreeStateProvider$p(FilteringBranchesTree $this) {
        return $this.treeStateProvider;
    }
}

