/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class HashNode
extends Node {
    private ListNode listNode;

    public HashNode(SourcePosition position, ListNode listNode) {
        super(position);
        this.listNode = (ListNode)this.adopt(listNode);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        HashNode other = (HashNode)node;
        if (this.getListNode() == null && other.getListNode() == null) {
            return true;
        }
        if (this.getListNode() == null || other.getListNode() == null) {
            return false;
        }
        return this.getListNode().isSame(other.getListNode());
    }

    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public ListNode getListNode() {
        return this.listNode;
    }
}

