/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSKeywordInsertHandlerBase
implements InsertHandler<LookupElement> {
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        PsiElement at;
        PsiFile file;
        Template template;
        if (context2 == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(0);
        }
        if (item == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(1);
        }
        if ((template = this.applyAndCreateTemplate(context2, file = context2.getFile(), at = file.findElementAt(context2.getStartOffset()))) != null) {
            TemplateManager.getInstance((Project)context2.getProject()).startTemplate(context2.getEditor(), template);
            context2.setAddCompletionChar(false);
        }
    }

    @Nullable
    protected abstract Template applyAndCreateTemplate(InsertionContext var1, PsiFile var2, PsiElement var3);

    protected static void insertWhitespaceIfNeeded(@NotNull PsiElement at, @NotNull InsertionContext context2) {
        PsiElement nextSibling;
        if (at == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(3);
        }
        if ((nextSibling = at.getNextSibling()) == null || nextSibling.getNode().getElementType() != JSTokenTypes.WHITE_SPACE) {
            JSKeywordInsertHandlerBase.insertWhitespace(context2);
        }
    }

    public static void insertWhitespace(@NotNull InsertionContext context2) {
        if (context2 == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(4);
        }
        JSKeywordInsertHandlerBase.insertString(context2, " ");
    }

    public static void insertString(@NotNull InsertionContext context2, String s) {
        if (context2 == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(5);
        }
        EditorModificationUtil.insertStringAtCaret((Editor)context2.getEditor(), (String)s);
        PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(context2.getDocument());
    }

    protected static boolean isKeywordWithIdentifierAppended(@Nullable PsiElement at, @NotNull String identifierText) {
        if (identifierText == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(6);
        }
        if (at == null) {
            return false;
        }
        if (at.getNode().getElementType() != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        return at.getText().startsWith(identifierText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSKeywordInsertHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insertWhitespaceIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "insertWhitespace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "insertString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isKeywordWithIdentifierAppended";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

